/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.buildablesubset.common;

import com.ibm.team.enterprise.buildablesubset.common.IBuildSubsetBinaryOperator;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableFileDesc;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableSubset;
import com.ibm.team.enterprise.buildablesubset.common.impl.BuildableSubset;
import java.util.ArrayList;

public class BuildSubsetOperatorFactory {

    public static enum OPERATOR implements IBuildSubsetBinaryOperator
    {
        OR{

            @Override
            public IBuildableSubset operate(IBuildableSubset left, IBuildableSubset right) {
                if (left == null || left.getBuildableFileDescs() == null || left.getBuildableFileDescs().size() == 0) {
                    return right;
                }
                if (right == null || right.getBuildableFileDescs() == null || right.getBuildableFileDescs().size() == 0) {
                    return left;
                }
                ArrayList<IBuildableFileDesc> results = new ArrayList<IBuildableFileDesc>(left.getBuildableFileDescs().size());
                results.addAll(left.getBuildableFileDescs());
                for (IBuildableFileDesc file : right.getBuildableFileDescs()) {
                    if (results.contains(file)) continue;
                    results.add(file);
                }
                BuildableSubset subset = new BuildableSubset();
                subset.setBuildableFileDescs(results);
                subset.setLabel(String.valueOf(left.toString()) + " | " + right.toString());
                return subset;
            }
        }
        ,
        AND{

            @Override
            public IBuildableSubset operate(IBuildableSubset left, IBuildableSubset right) {
                if (left == null || left.getBuildableFileDescs() == null || left.getBuildableFileDescs().size() == 0) {
                    return right;
                }
                if (right == null || right.getBuildableFileDescs() == null || right.getBuildableFileDescs().size() == 0) {
                    return left;
                }
                ArrayList<IBuildableFileDesc> results = new ArrayList<IBuildableFileDesc>();
                for (IBuildableFileDesc file : left.getBuildableFileDescs()) {
                    if (!right.getBuildableFileDescs().contains(file)) continue;
                    results.add(file);
                }
                BuildableSubset subset = new BuildableSubset();
                subset.setBuildableFileDescs(results);
                subset.setLabel(String.valueOf(left.toString()) + " | " + right.toString());
                return subset;
            }
        };

    }
}

