/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.vc;

import com.urbancode.air.vc.Commit;
import com.urbancode.air.vc.Handle;
import com.urbancode.air.vc.LatestVersionEntry;
import com.urbancode.air.vc.PersistenceData;
import com.urbancode.air.vc.Persistent;
import com.urbancode.air.vc.PersistentRecord;
import com.urbancode.air.vc.Repository;
import com.urbancode.air.vc.VCHelper;
import com.urbancode.air.vc.interceptors.InterceptorRegistry;
import com.urbancode.air.vc.interceptors.ReadInterceptor;
import com.urbancode.air.vc.metadata.RecordMetadataCondition;
import com.urbancode.air.vc.xml.DocumentBuilderHelper;
import com.urbancode.air.vc.xml.XMLVCHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentReader {
    private static final Logger log = Logger.getLogger(PersistentReader.class);
    private static final int ARBITRARY_MAX_DISJUNCTION_SIZE = 200;
    private static final int MAX_QUERY_SIZE = 500;
    private Repository repository;
    private Cache readCache;
    private boolean isTraceEnabled;

    public PersistentReader(Repository repository) {
        this.repository = repository;
        this.readCache = CacheManager.getInstance().getCache("vcCache");
        this.isTraceEnabled = log.isTraceEnabled();
    }

    private Session getSession() {
        return this.repository.getTxManager().getSession();
    }

    Commit readCommit(long id) {
        Criteria criteria = this.getSession().createCriteria(Commit.class);
        criteria.add((Criterion)Restrictions.eq((String)"id", (Object)id));
        return (Commit)criteria.uniqueResult();
    }

    List<Commit> readCommitsForPersistent(String path) {
        return this.readCommitsForPath(path);
    }

    List<Commit> readCommitsForPath(String path) {
        Session session = this.repository.getTxManager().getSession();
        Query query = session.createQuery("select distinct c from  Commit c, CommitPathEntry e where  e.commit = c  and e.path like :path  order by c.id");
        query.setParameter("path", (Object)(path + "%"));
        List result = query.list();
        return result;
    }

    <T extends Persistent> Integer getVersionCountForPersistent(T persistent) {
        PersistenceData persistenceData = persistent.getPersistenceData();
        String path = persistenceData.getPath();
        return this.getVersionCountForPath(path);
    }

    Integer getVersionCountForPath(String path) {
        Criteria criteria = this.getSession().createCriteria(PersistentRecord.class);
        criteria.add((Criterion)Restrictions.eq((String)"path", (Object)path));
        criteria.setProjection(Projections.rowCount());
        Long longResult = (Long)criteria.uniqueResult();
        Integer result = longResult.intValue();
        if (result == null) {
            result = 0;
        }
        return result;
    }

    Map<String, Integer> getVersionCountForPaths(Set<String> recordPaths) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        List<String> pathList = new ArrayList<String>(recordPaths);
        while (!pathList.isEmpty()) {
            int split = Math.min(pathList.size(), 500);
            List subList = pathList.subList(0, split);
            pathList = pathList.subList(split, pathList.size());
            String queryString = "select    p.path, count(*)  from   PersistentRecord p  where    p.path in :path group by p.path";
            Query query = this.repository.getTxManager().getSession().createQuery(queryString);
            query.setParameterList("path", subList);
            for (Object rawResult : query.list()) {
                Object[] rawResultArray = (Object[])rawResult;
                String path = (String)rawResultArray[0];
                Integer count = ((Long)rawResultArray[1]).intValue();
                result.put(path, count);
            }
        }
        return result;
    }

    <T extends Persistent> Integer getVersionForCommit(T persistent, Long commit) {
        PersistenceData persistenceData = persistent.getPersistenceData();
        String path = persistenceData.getPath();
        return this.getVersionForCommit(commit, path);
    }

    Integer getVersionForCommit(Long commit, String path) {
        Criteria criteria = this.getSession().createCriteria(PersistentRecord.class);
        criteria.add((Criterion)Restrictions.eq((String)"path", (Object)path));
        criteria.add((Criterion)Restrictions.le((String)"commit.id", (Object)commit));
        criteria.setProjection(Projections.rowCount());
        Long longResult = (Long)criteria.uniqueResult();
        Integer result = longResult.intValue();
        if (result == null) {
            result = 0;
        }
        return result;
    }

    public Map<String, Integer> getLatestVersionsForPathLike(String partialPath) {
        Criteria criteria = this.getSession().createCriteria(LatestVersionEntry.class);
        criteria = criteria.createAlias("record", "r");
        criteria.add((Criterion)Restrictions.like((String)"r.path", (Object)(partialPath + "%")));
        criteria.setProjection((Projection)Projections.projectionList().add((Projection)Property.forName((String)"r.path")).add((Projection)Property.forName((String)"r.relativeVersion")));
        List data = criteria.list();
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Object[] lockable : data) {
            Integer version = (Integer)lockable[1];
            String path = (String)lockable[0];
            result.put(path, version);
        }
        return result;
    }

    List<Persistent> getLatestPersistentsWithAllMetadata(boolean excludeDeleted, RecordMetadataCondition ... conditions) {
        Set<LatestVersionEntry> records = this.getLatestEntrySetForConditions(excludeDeleted, null, conditions);
        ArrayList<PersistentRecord> recordList = new ArrayList<PersistentRecord>();
        for (LatestVersionEntry record : records) {
            recordList.add(record.getPersistentRecord());
        }
        return new ArrayList<Persistent>(this.restore(recordList).values());
    }

    List<Persistent> getLatestPersistentsWithAllMetadataInPath(String path, boolean excludeDeleted, RecordMetadataCondition ... conditions) {
        Set<LatestVersionEntry> records = this.getLatestEntrySetForConditions(excludeDeleted, path, conditions);
        ArrayList<PersistentRecord> recordList = new ArrayList<PersistentRecord>();
        for (LatestVersionEntry record : records) {
            recordList.add(record.getPersistentRecord());
        }
        return new ArrayList<Persistent>(this.restore(recordList).values());
    }

    Persistent getPersistentWithMetadataAndVersion(int version, RecordMetadataCondition ... conditions) {
        Persistent result = null;
        PersistentRecord record = this.getPersistentRecordForConditions(version, null, null, conditions);
        if (record != null) {
            result = this.restore(record);
        }
        return result;
    }

    Persistent getPersistentWithMetadataAndVersion(int version, String path, RecordMetadataCondition ... conditions) {
        Persistent result = null;
        PersistentRecord record = this.getPersistentRecordForConditions(version, null, path, conditions);
        if (record != null) {
            result = this.restore(record);
        }
        return result;
    }

    Persistent getPersistentWithMetadataAtCommit(long commit, RecordMetadataCondition ... conditions) {
        Persistent result = null;
        PersistentRecord record = this.getPersistentRecordForConditions(null, commit, null, conditions);
        if (record != null) {
            result = this.restore(record);
        }
        return result;
    }

    Persistent getPersistentWithMetadataAtCommit(long commit, String path, RecordMetadataCondition ... conditions) {
        Persistent result = null;
        PersistentRecord record = this.getPersistentRecordForConditions(null, commit, path, conditions);
        if (record != null) {
            result = this.restore(record);
        }
        return result;
    }

    List<Persistent> getAllPersistentVersionsInPath(String path) {
        Session session = this.repository.getTxManager().getSession();
        Criteria criteria = session.createCriteria(PersistentRecord.class, "record");
        criteria.add((Criterion)Restrictions.eq((String)"path", (Object)path));
        criteria.createAlias("commit", "commit");
        criteria.addOrder(Order.desc((String)"commit.id"));
        List records = criteria.list();
        return this.restoreAsList(records, true);
    }

    <T extends Persistent> T readPersistent(Class<T> clazz, String path) {
        Integer version = this.getVersionCountForPath(path);
        return (T)this.readPersistentForHandle(new Handle(path, version));
    }

    <T extends Persistent> T readPersistent(Class<T> clazz, String path, int version) {
        return (T)this.readPersistentForHandle(new Handle(path, version));
    }

    <T extends Persistent> T readPersistentForCommit(Class<T> clazz, String path, long commit) {
        return (T)this.readPersistentForHandle(new Handle(path, commit));
    }

    private <T extends Persistent> void runInterceptors(T result) {
        List<ReadInterceptor> readInterceptors = InterceptorRegistry.getInstance().getReadInterceptors();
        for (ReadInterceptor interceptor : readInterceptors) {
            interceptor.interceptRead(result);
        }
    }

    <T extends Persistent> List<T> readAllInPath(Class<T> clazz, String path, boolean includeDeleted) {
        Criteria criteria = this.getSession().createCriteria(LatestVersionEntry.class);
        criteria.createCriteria("record", "pr");
        criteria.add((Criterion)Restrictions.eq((String)"pr.directory", (Object)path));
        if (!includeDeleted) {
            criteria.add((Criterion)Restrictions.eq((String)"pr.deleted", (Object)false));
        }
        criteria.setProjection((Projection)Projections.property((String)"record"));
        return this.getPersistentResultsFromObjectList(clazz, criteria.list());
    }

    <T extends Persistent> List<T> readAllLikePath(Class<T> clazz, String path, boolean includeDeleted) {
        Criteria criteria = this.getSession().createCriteria(LatestVersionEntry.class);
        criteria.createCriteria("record", "pr");
        criteria.add((Criterion)Restrictions.like((String)"pr.path", (Object)path));
        if (!includeDeleted) {
            criteria.add((Criterion)Restrictions.eq((String)"pr.deleted", (Object)false));
        }
        criteria.setProjection((Projection)Projections.property((String)"record"));
        return this.getPersistentResultsFromObjectList(clazz, criteria.list());
    }

    <T extends Persistent> List<T> readAllInPathForCommit(Class<T> clazz, String path, Long commit) {
        Session session = this.repository.getTxManager().getSession();
        Query query = session.createQuery("select pr from PersistentRecord pr where pr.directory = :path and pr.commit.id = (select max(pr2.commit.id) from PersistentRecord pr2 where pr2.path = pr.path and pr2.commit.id <= :commit)and pr.deleted = :false");
        query.setParameter("path", (Object)path);
        query.setParameter("commit", (Object)commit);
        query.setParameter("false", (Object)false);
        return this.getPersistentResultsFromObjectList(clazz, query.list());
    }

    <T extends Persistent> List<T> readAllLikePathSinceTime(Class<T> clazz, String partialPath, Long time) {
        Criteria commitCriteria = this.repository.getTxManager().getSession().createCriteria(Commit.class).add((Criterion)Restrictions.gt((String)"time", (Object)time)).setProjection((Projection)Projections.min((String)"id"));
        Object commitCriteriaResult = commitCriteria.uniqueResult();
        if (commitCriteriaResult == null) {
            return new ArrayList();
        }
        Long minCommitId = Long.parseLong(commitCriteriaResult.toString());
        return this.readAllLikePathSinceCommitInclusive(clazz, partialPath, minCommitId);
    }

    <T extends Persistent> List<T> readAllLikePathSinceCommitInclusive(Class<T> clazz, String partialPath, Long commit) {
        Criteria criteria = this.repository.getTxManager().getSession().createCriteria(LatestVersionEntry.class, "lve");
        criteria.setProjection((Projection)Projections.property((String)"lve.record"));
        criteria.createAlias("record", "r");
        criteria.add((Criterion)Restrictions.ge((String)"r.commit.id", (Object)commit));
        criteria.add((Criterion)Restrictions.like((String)"r.path", (Object)(partialPath + "%")));
        List queryResults = criteria.list();
        return new ArrayList<Persistent>(this.restore(queryResults).values());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Persistent readPersistentForHandle(Handle handle) {
        PersistentRecord record = this.attemptRestoreFromCache(handle);
        Persistent result = null;
        if (record == null) {
            String path = handle.getPath();
            int version = 0;
            Integer handleVersion = handle.getVersion();
            Long handleCommit = handle.getCommit();
            if (handleVersion != null) {
                if (handleVersion == -1) {
                    record = this.getPersistentRecordForLatest(path);
                } else {
                    version = handle.getVersion();
                    record = this.getPersistentRecord(path, version);
                }
            } else {
                if (handleCommit == null) throw new IllegalArgumentException("Invalid handle: " + handle);
                record = this.getPersistentRecordForCommit(path, handleCommit);
            }
        } else if (this.isTraceEnabled) {
            log.trace((Object)String.format("Persistent with handle '%s' was restored from cache", handle.toString()));
        }
        if (record != null) {
            return this.restore(record);
        }
        if (!this.isTraceEnabled) return result;
        log.trace((Object)String.format("PersistentRecord found for handle '%s' was not found", handle.toString()));
        return result;
    }

    public List<Persistent> readLatestWithPaths(List<String> paths, boolean skipVersionCount) {
        List<PersistentRecord> recordList = this.getLatestPersistentRecordsWithPaths(paths);
        return new ArrayList<Persistent>(this.restore(recordList, skipVersionCount).values());
    }

    public Map<PersistentRecord, Persistent> restore(List<PersistentRecord> records) {
        return this.restore(records, false);
    }

    private Collection<Persistent> restore(Collection<PersistentRecord> records, boolean skipVersionCount) {
        HashSet<Persistent> result = new HashSet<Persistent>();
        ArrayList<PersistentRecord> recordsList = new ArrayList<PersistentRecord>(records);
        result.addAll(this.restore((List<PersistentRecord>)recordsList, skipVersionCount).values());
        return result;
    }

    private List<Persistent> restoreAsList(List<PersistentRecord> records, boolean skipVersionCount) {
        ArrayList<Persistent> result = new ArrayList<Persistent>();
        result.addAll(this.restore(records, skipVersionCount).values());
        return result;
    }

    public Map<PersistentRecord, Persistent> restore(List<PersistentRecord> records, boolean skipVersionCount) {
        LinkedHashMap<PersistentRecord, Persistent> result = new LinkedHashMap<PersistentRecord, Persistent>();
        Map<Object, Object> versionMap = new HashMap();
        if (!skipVersionCount) {
            HashSet<String> recordPaths = new HashSet<String>();
            for (PersistentRecord record : records) {
                recordPaths.add(record.getPath());
            }
            versionMap = this.getVersionCountForPaths(recordPaths);
        }
        for (PersistentRecord record : records) {
            try {
                result.put(record, this.restore(record, (Integer)versionMap.get(record.getPath())));
            }
            catch (SecurityException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("User does not have permission to load persistent record in path: '%s'.", record.getPath()), (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)String.format("Exception loading persistent record in path: '%s'.", record.getPath()), (Throwable)e);
            }
        }
        return result;
    }

    public Persistent restore(PersistentRecord record, boolean skipVersionCount) {
        Integer versionCount = skipVersionCount ? record.getRelativeVersion() : this.getVersionCountForPath(record.getPath());
        return this.restore(record, versionCount);
    }

    private Persistent restore(PersistentRecord record, Integer versionCount) {
        String path = record.getPath();
        Integer version = record.getRelativeVersion();
        Persistent result = null;
        try {
            VCHelper<?> helper;
            DocumentBuilder builder = DocumentBuilderHelper.getDocumentBuilder();
            String recData = record.getData();
            recData = XMLVCHelper.replaceIllegalXmlChars(recData);
            ByteArrayInputStream stream = new ByteArrayInputStream(recData.getBytes("UTF-8"));
            Document document = builder.parse(stream);
            stream.close();
            String nodeName = null;
            NodeList list = document.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if (list.item(i).getNodeType() != 1) continue;
                nodeName = list.item(i).getNodeName();
                break;
            }
            if ((result = (Persistent)(helper = this.repository.getHelperRegistry().getHelper(nodeName)).restore(document)) == null && this.isTraceEnabled) {
                log.trace((Object)String.format("Restoring PersistentRecord '%s' returned a null Persistent!", record.toString()));
            }
            if (versionCount == null || versionCount < 0) {
                versionCount = version;
                this.cache(record, false);
            } else {
                boolean latest = version == versionCount;
                this.cache(record, latest);
            }
            PersistenceData persistenceData = result.getPersistenceData();
            persistenceData.setPath(path);
            persistenceData.setCommit(record.getCommit());
            persistenceData.setRelativeVersion(version);
            persistenceData.setVersionCount(versionCount);
            persistenceData.internalSetDeleted(record.isDeleted());
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Error reading from stored XML", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading from stored XML", e);
        }
        catch (SAXException e) {
            throw new RuntimeException("Error reading from stored XML", e);
        }
        if (result != null) {
            this.runInterceptors(result);
        }
        return result;
    }

    public Persistent restore(PersistentRecord record) {
        return this.restore(record, this.getVersionCountForPath(record.getPath()));
    }

    public boolean persistentExistsUnderPath(String path) {
        boolean result = false;
        Criteria criteria = this.repository.getTxManager().getSession().createCriteria(LatestVersionEntry.class);
        criteria.add((Criterion)Restrictions.like((String)"path", (String)path, (MatchMode)MatchMode.START));
        criteria.createAlias("record", "record");
        criteria.add((Criterion)Restrictions.eq((String)"record.deleted", (Object)false));
        criteria.setMaxResults(1);
        if (criteria.uniqueResult() != null) {
            result = true;
        }
        return result;
    }

    public boolean doesPersistentWithMetadataExistInLikePath(String path, RecordMetadataCondition ... conditions) {
        Set<LatestVersionEntry> existingObjects = this.getLatestEntrySetForConditions(true, path, conditions);
        return existingObjects != null && existingObjects.size() > 0;
    }

    private PersistentRecord getPersistentRecord(String path, Integer version) {
        Criteria criteria = this.repository.getTxManager().getSession().createCriteria(PersistentRecord.class);
        criteria.add((Criterion)Restrictions.eq((String)"path", (Object)path));
        criteria.add((Criterion)Restrictions.eq((String)"relativeVersion", (Object)version));
        PersistentRecord result = (PersistentRecord)criteria.uniqueResult();
        if (result == null && this.isTraceEnabled) {
            log.trace((Object)String.format("No Persistent record found in vc_persistent_record found with path '%s' and version '%d'", path, version));
        }
        return result;
    }

    private PersistentRecord getPersistentRecordForCommit(String path, Long commit) {
        Criteria criteria = this.repository.getTxManager().getSession().createCriteria(PersistentRecord.class);
        criteria.add((Criterion)Restrictions.eq((String)"path", (Object)path));
        criteria.add((Criterion)Restrictions.le((String)"commit.id", (Object)commit));
        criteria.addOrder(Order.desc((String)"commit.id"));
        criteria.setMaxResults(1);
        PersistentRecord record = (PersistentRecord)criteria.uniqueResult();
        if (record == null && this.isTraceEnabled) {
            log.trace((Object)String.format("No persistent with path '%s' and commit '%d' found", path, commit));
        }
        return record;
    }

    private PersistentRecord getPersistentRecordForLatest(String path) {
        PersistentRecord result = null;
        if (this.isTraceEnabled) {
            log.trace((Object)String.format("Restoring Persistent from LatestVersionEntry with path '%s'", path));
        }
        Criteria versionCriteria = this.repository.getTxManager().getSession().createCriteria(LatestVersionEntry.class);
        versionCriteria.add((Criterion)Restrictions.eq((String)"path", (Object)path));
        LatestVersionEntry versionEntry = (LatestVersionEntry)versionCriteria.uniqueResult();
        if (versionEntry != null) {
            result = versionEntry.getPersistentRecord();
        } else if (this.isTraceEnabled) {
            log.trace((Object)String.format("No Persistent found in LatestVersionEntry with path '%s'", path));
        }
        return result;
    }

    public Map<Handle, Persistent> getPersistentMapForHandles(List<Handle> handles, boolean skipVersionCount) {
        ArrayList<String> latestPaths = new ArrayList<String>();
        List specificVersionHandles = new ArrayList<Handle>();
        HashMap<Handle, Persistent> result = new HashMap<Handle, Persistent>();
        for (Handle handle : handles) {
            PersistentRecord r = this.attemptRestoreFromCache(handle);
            if (r != null) {
                result.put(handle, this.restore(r, true));
                continue;
            }
            if (handle.getVersion() == -1) {
                latestPaths.add(handle.getPath());
                continue;
            }
            specificVersionHandles.add(handle);
        }
        List<Persistent> latestPersistents = this.readLatestWithPaths(latestPaths, skipVersionCount);
        ArrayList<PersistentRecord> specificPersistentRecords = new ArrayList<PersistentRecord>(specificVersionHandles.size());
        while (specificVersionHandles.size() > 0) {
            int split = Math.min(specificVersionHandles.size(), 200);
            List<Handle> handleSubList = specificVersionHandles.subList(0, split);
            specificVersionHandles = specificVersionHandles.subList(split, specificVersionHandles.size());
            specificPersistentRecords.addAll(this.getRecordsFromSublist(handleSubList));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Restored %d records from a list of %d paths", latestPersistents.size(), latestPaths.size()));
            log.debug((Object)String.format("Restored %d records from a list of %d handles", specificPersistentRecords.size(), specificVersionHandles.size()));
        }
        for (Persistent p : latestPersistents) {
            result.put(new Handle(p.getPersistenceData().getPath(), -1), p);
        }
        Collection<Persistent> specificPersistents = this.restore((List<PersistentRecord>)specificPersistentRecords, skipVersionCount).values();
        for (Persistent p : specificPersistents) {
            result.put(new Handle(p), p);
        }
        return result;
    }

    private List<PersistentRecord> getRecordsFromSublist(List<Handle> handleSubList) {
        Criteria criteria = this.getSession().createCriteria(PersistentRecord.class);
        Disjunction disjunction = Restrictions.disjunction();
        for (Handle h : handleSubList) {
            String path = h.getPath();
            int relativeVersion = h.getVersion();
            if (relativeVersion == -1) {
                throw new IllegalArgumentException("Relative version must be a positive #");
            }
            disjunction.add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"path", (Object)path), (Criterion)Restrictions.eq((String)"relativeVersion", (Object)relativeVersion)));
        }
        criteria.add((Criterion)disjunction);
        return criteria.list();
    }

    private List<PersistentRecord> getLatestPersistentRecordsWithPaths(List<String> paths) {
        ArrayList<PersistentRecord> result = new ArrayList<PersistentRecord>();
        while (paths.size() > 0) {
            int split = Math.min(paths.size(), 500);
            ArrayList<String> pathSubList = new ArrayList<String>(paths.subList(0, split));
            paths = paths.subList(split, paths.size());
            Criteria versionCriteria = this.getSession().createCriteria(LatestVersionEntry.class);
            versionCriteria.add(Restrictions.in((String)"path", pathSubList));
            List entries = versionCriteria.list();
            for (LatestVersionEntry entry : entries) {
                result.add(entry.getPersistentRecord());
            }
        }
        return result;
    }

    private PersistentRecord attemptRestoreFromCache(Handle handle) {
        PersistentRecord result = null;
        if (handle.getVersion() != null && handle.getVersion() == -1) {
            Integer cachedLatestVersion = this.repository.getSession().getCachedLatestVersion(handle.getPath());
            if (cachedLatestVersion != null) {
                if (this.isTraceEnabled) {
                    log.trace((Object)String.format("Found cachedLatestVersion for path '%s'", handle.getPath()));
                }
                handle = new Handle(handle.getPath(), cachedLatestVersion);
            } else if (this.isTraceEnabled) {
                log.trace((Object)String.format("No cached latest version for persistent with path '%s'", handle.getPath()));
            }
        } else if (this.isTraceEnabled) {
            if (handle.getVersion() == null) {
                log.trace((Object)String.format("Failed to restore persistent with handle '%s' from cache as version is null", handle.toString()));
            } else {
                log.trace((Object)String.format("Failed to restore persistent with handle '%s' from cache as version is not -1", handle.toString()));
            }
        }
        if (this.readCache != null) {
            Element element = this.readCache.get((Serializable)((Object)handle.toString()));
            if (element != null) {
                result = (PersistentRecord)element.getValue();
            } else if (this.isTraceEnabled) {
                log.trace((Object)String.format("Nothing returned from readCache for handle '%s'", handle.toString()));
            }
        } else if (this.isTraceEnabled) {
            log.trace((Object)"readCache is null");
        }
        return result;
    }

    protected void cache(PersistentRecord p, boolean latestVersion) {
        if (this.readCache != null) {
            String path = p.getPath();
            int relativeVersion = p.getRelativeVersion();
            long commit = p.getCommitNumber();
            Handle handle = new Handle(path, relativeVersion);
            this.readCache.put(new Element((Serializable)((Object)handle.toString()), (Serializable)p));
            Handle commitHandle = new Handle(path, commit);
            this.readCache.put(new Element((Serializable)((Object)commitHandle.toString()), (Serializable)p));
            if (latestVersion) {
                if (this.isTraceEnabled) {
                    log.trace((Object)String.format("Caching new latest version '%d' of persist with path '%s'", relativeVersion, path));
                }
                this.repository.getSession().cacheLatestVersion(path, relativeVersion);
            }
        } else if (this.isTraceEnabled) {
            log.trace((Object)"readCache is null");
        }
    }

    private Set<LatestVersionEntry> getLatestEntrySetForConditions(boolean excludeDeleted, String path, RecordMetadataCondition ... conditions) {
        Session session = this.repository.getTxManager().getSession();
        HashSet<LatestVersionEntry> records = new HashSet<LatestVersionEntry>();
        boolean first = true;
        for (RecordMetadataCondition condition : conditions) {
            Criteria criteria = session.createCriteria(LatestVersionEntry.class, "latestEntry");
            Criteria metadataCriteria = criteria.createCriteria("record.metadataList");
            if (excludeDeleted) {
                criteria.createAlias("record", "record");
                criteria.add((Criterion)Restrictions.eq((String)"record.deleted", (Object)false));
            }
            if (path != null) {
                criteria.add((Criterion)Restrictions.like((String)"path", (Object)path));
            }
            metadataCriteria.add((Criterion)Restrictions.eq((String)"key", (Object)condition.getKey()));
            metadataCriteria.add((Criterion)Restrictions.eq((String)"metadataGeneratorName", (Object)condition.getGeneratorName()));
            if (condition.getComparison() == RecordMetadataCondition.MetadataComparison.EQ) {
                metadataCriteria.add((Criterion)Restrictions.eq((String)"value", (Object)condition.getValue()));
            } else if (condition.getComparison() == RecordMetadataCondition.MetadataComparison.LIKE) {
                metadataCriteria.add((Criterion)Restrictions.like((String)"value", (Object)condition.getValue()));
            } else if (condition.getComparison() == RecordMetadataCondition.MetadataComparison.ILIKE) {
                metadataCriteria.add(Restrictions.ilike((String)"value", (Object)condition.getValue()));
            }
            if (first) {
                records.addAll(criteria.list());
                first = false;
                continue;
            }
            records.retainAll(criteria.list());
        }
        return records;
    }

    private PersistentRecord getPersistentRecordForConditions(Integer version, Long commit, String path, RecordMetadataCondition ... conditions) {
        PersistentRecord result = null;
        Session session = this.repository.getTxManager().getSession();
        boolean first = true;
        HashSet records = new HashSet();
        for (RecordMetadataCondition condition : conditions) {
            Criteria criteria = session.createCriteria(PersistentRecord.class, "record");
            if (version != null) {
                criteria.add((Criterion)Restrictions.eq((String)"relativeVersion", (Object)version));
            }
            if (commit != null) {
                criteria.add((Criterion)Restrictions.le((String)"commit.id", (Object)commit));
            }
            if (path != null) {
                criteria.add((Criterion)Restrictions.like((String)"path", (Object)path));
            }
            criteria.addOrder(Order.desc((String)"commit.id"));
            criteria.setMaxResults(1);
            Criteria metadataCriteria = criteria.createCriteria("record.metadataList");
            metadataCriteria.add((Criterion)Restrictions.eq((String)"key", (Object)condition.getKey()));
            metadataCriteria.add((Criterion)Restrictions.eq((String)"metadataGeneratorName", (Object)condition.getGeneratorName()));
            if (condition.getComparison() == RecordMetadataCondition.MetadataComparison.EQ) {
                metadataCriteria.add((Criterion)Restrictions.eq((String)"value", (Object)condition.getValue()));
            } else if (condition.getComparison() == RecordMetadataCondition.MetadataComparison.LIKE) {
                metadataCriteria.add((Criterion)Restrictions.like((String)"value", (Object)condition.getValue()));
            } else if (condition.getComparison() == RecordMetadataCondition.MetadataComparison.ILIKE) {
                metadataCriteria.add(Restrictions.ilike((String)"value", (Object)condition.getValue()));
            }
            if (first) {
                records.addAll(criteria.list());
                first = false;
                continue;
            }
            records.retainAll(criteria.list());
        }
        if (records.size() > 1) {
            throw new RuntimeException("Found multiple persistents when expecting only one.");
        }
        if (records.size() == 1) {
            result = (PersistentRecord)new ArrayList(records).get(0);
        }
        return result;
    }

    private <T extends Persistent> List<T> getPersistentResultsFromObjectList(Class<T> clazz, List<Object> rawObjects) {
        ArrayList<PersistentRecord> records = new ArrayList<PersistentRecord>();
        for (Object rawResult : rawObjects) {
            PersistentRecord record = (PersistentRecord)rawResult;
            records.add(record);
        }
        return new ArrayList<Persistent>(this.restore(records).values());
    }
}

