/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonPrimitive;
import com.jayway.restassured.RestAssured;
import com.urbancode.release.rest.framework.ClientDescribed;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.Role;
import com.urbancode.release.rest.models.internal.Task;

public abstract class Segment<T extends Segment>
extends ClientDescribed<T> {
    public Boolean enforceSequential;
    public String executionPattern;
    public Role executorRole;
    public String[] prerequisiteIds = new String[0];
    @JsonReadOnly
    public Integer relativePosition;
    @JsonReadOnly
    public Long lastRefresh;

    public T executorRole(Role executorRole) {
        this.executorRole = executorRole;
        return (T)this;
    }

    public T executionPattern(String executorRole) {
        this.executionPattern = executorRole;
        return (T)this;
    }

    public T enforceSequential(Boolean enforceSequential) {
        this.enforceSequential = enforceSequential;
        return (T)this;
    }

    public T reorderTasksWithinSegment(int statusCode, Task ... tasks) {
        return this.reorderTasksToAnotherSegment(this, statusCode, tasks);
    }

    public T reorderTasksWithinSegment(Task ... tasks) {
        return this.reorderTasksWithinSegment(200, tasks);
    }

    public T reorderTasksToAnotherSegment(Segment segment, Task ... tasks) {
        return this.reorderTasksToAnotherSegment(segment, 200, tasks);
    }

    public T reorderTasksToAnotherSegment(Segment segment, int statusCode, Task ... tasks) {
        JsonArray ids = new JsonArray();
        for (Task t : tasks) {
            ids.add(new JsonPrimitive(t.getId()));
        }
        String json = ids.toString();
        RestAssured.given().body(json).expect().statusCode(statusCode).put(segment.path(this.id) + "/tasks", new Object[0]);
        return (T)((Segment)this.get());
    }
}

