/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.internal.Connection;
import com.ibm.team.scm.client.internal.SCMClientUtil;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IRepositoryProgressMonitorHandle;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import com.ibm.team.scm.common.dto.ISynchronizationTimes;
import com.ibm.team.scm.common.internal.dto.ServiceConfigurationProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class ClientConfigurationProxy
extends EventSource
implements IConfiguration {
    protected abstract WorkspaceManager workspaceManager();

    protected IRepositoryProgressMonitor monitorFor(IProgressMonitor monitor) {
        return IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor);
    }

    protected abstract ServiceConfigurationProvider getServiceConfigurationProvider();

    @Override
    public List determineAncestorsInHistory(List versionableHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.determineAncestorsInHistory(versionableHandles, null, monitor);
    }

    public List determineAncestorsInHistory(List versionableHandles, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (versionableHandles == null) {
            throw new IllegalArgumentException();
        }
        monitor = SCMClientUtil.getMonitor(monitor, versionableHandles.size());
        try {
            for (Object element : versionableHandles) {
                if (element != null && element instanceof IVersionableHandle) continue;
                throw new IllegalArgumentException();
            }
            ArrayList<IAncestorReport> result = new ArrayList<IAncestorReport>();
            int left = versionableHandles.size();
            ISynchronizationTimes[] synchronizationTimes = Connection.getSyncTimes(syncInfo);
            IScmService service = this.workspaceManager().getServerConfigurationService();
            int i = 0;
            while (left > 0) {
                int from = i * 2048;
                int size = Math.min(2048, left);
                IAncestorReport[] reports = service.configurationDetermineAncestorsInHistory(this.getServiceConfigurationProvider(), versionableHandles.subList(from, from + size).toArray(new IVersionableHandle[size]), synchronizationTimes, (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
                result.addAll(Arrays.asList(reports));
                left -= size;
                SCMClientUtil.checkMonitor(monitor);
                monitor.worked(size);
                ++i;
            }
            ArrayList<IAncestorReport> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }
}

