/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas.validator;

import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalMetadataValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.LoadedComponent;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.DiskBackedHashMapEntriesValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.HeapValidator;
import com.ibm.team.internal.repository.rcp.util.RAFWrapper;
import com.ibm.team.repository.transport.client.TeamServerFactoryImpl;
import com.ibm.team.scm.common.IContextHandle;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;

public class LoadedComponentsMapValidator
extends DiskBackedHashMapEntriesValidator {
    private static final int METADATA_VERSION = 0;
    protected File cfaRoot;

    public LoadedComponentsMapValidator(File rootPath, HeapValidator hv, GlobalMetadataValidator gv) throws IOException {
        super(hv, gv);
        this.cfaRoot = rootPath;
    }

    @Override
    public void beginValidation() throws IOException {
        super.beginValidation();
        if (!this.hv.getHeapFile().getName().equals(".components")) {
            this.log.append("Invalid loaded components map file name " + this.hv.getHeapFile() + "\n");
        }
        if (!this.hv.getHeapFile().getParentFile().equals(this.cfaRoot)) {
            this.log.append("Invalid loaded components map location " + this.hv.getHeapFile() + " relative to root " + this.cfaRoot + "\n");
        }
    }

    @Override
    public void validateEntry(long entryOffset, long keyOffset, boolean keyIsHeapADT, long valueOffset, boolean valueIsHeapADT, int hash, RAFWrapper raf) throws IOException {
        if (keyIsHeapADT) {
            this.log.append("HeapADT attribute unexpectedly set on loaded components key of entry at " + entryOffset + "\n");
        }
        if (valueIsHeapADT) {
            this.log.append("HeapADT attribute unexpectedly set on loaded components value of entry at " + entryOffset + "\n");
        }
        LoadedComponent lc = this.validateKey(entryOffset, keyOffset, hash, raf);
        this.validateValue(entryOffset, valueOffset, raf, lc);
    }

    protected LoadedComponent validateKey(long entryOffset, long keyOffset, int hashCode, RAFWrapper raf) throws IOException {
        LoadedComponent result = new LoadedComponent();
        if (keyOffset < 0L || keyOffset > this.hv.getWorkingAreaSize()) {
            this.log.append("The loaded components key pointer is at an impossible location " + keyOffset + " at " + entryOffset + "\n");
            return result;
        }
        this.setPosition(keyOffset);
        try {
            String componentId = this.validateUUID("loaded components key", keyOffset, "component UUID", raf);
            result.setComponentId(componentId);
            String connectionType = this.validateString("loaded components key", keyOffset, "connection type name", raf);
            result.setConnectionType(connectionType);
            String connectionTypeNs = this.validateString("loaded components key", keyOffset, "connection type namespace", raf);
            result.setConnectionTypeNS(connectionTypeNs);
            this.validateItemType(connectionType, connectionTypeNs, IContextHandle.class, "loaded components key", keyOffset, "connection type");
            String connectionId = this.validateUUID("loaded components key", keyOffset, "connection UUID", raf);
            result.setConnectionId(connectionId);
            if (componentId != null && connectionId != null) {
                if (connectionType != null && connectionTypeNs != null) {
                    this.addKey(result, entryOffset, keyOffset, "loaded components");
                }
                if (hashCode != (connectionId.hashCode() ^ componentId.hashCode())) {
                    this.log.append("The entry at " + entryOffset + " contains a hash code (" + hashCode + ") for loaded components key at " + keyOffset + " with connectionId \"" + connectionId + "\" and component id \"" + componentId + "\" whose hash code is " + (connectionId.hashCode() ^ componentId.hashCode()) + "\n");
                }
            }
        }
        finally {
            this.hv.claim(new HeapValidator.HeapClaimant(keyOffset, this.getPosition() - keyOffset, "Loaded Components Key"));
        }
        return result;
    }

    protected void validateValue(long entryOffset, long valueOffset, RAFWrapper raf, LoadedComponent lc) throws IOException {
        if (valueOffset < 0L || valueOffset > this.hv.getWorkingAreaSize()) {
            this.log.append("The loaded components value pointer is at an impossible location " + valueOffset + " at " + entryOffset + "\n");
            return;
        }
        this.setPosition(valueOffset);
        try {
            String repo;
            String connectionTypeNs;
            String connectionType;
            String componentId = this.validateUUID("loaded components value", valueOffset, "component UUID", raf);
            if (componentId != null && lc.getComponentId() != null && !componentId.equals(lc.getComponentId())) {
                this.log.append("Mismatch between loaded component id in key and value of loaded components map, key is " + lc.getComponentId() + " and value is " + componentId + "\n");
            }
            if (lc.getComponentId() == null && componentId != null) {
                lc.setComponentId(componentId);
            }
            if ((connectionType = this.validateString("loaded components value", valueOffset, "connection type name", raf)) != null && lc.getConnectionType() != null && !connectionType.equals(lc.getConnectionType())) {
                this.log.append("Mismatch between loaded connection type in key and value of loaded components map, key is " + lc.getConnectionType() + " and value is " + connectionType + "\n");
            }
            if (lc.getConnectionType() == null && connectionType != null) {
                lc.setConnectionType(connectionType);
            }
            if ((connectionTypeNs = this.validateString("loaded components value", valueOffset, "connection type namespace", raf)) != null && lc.getConnectionTypeNS() != null && !connectionTypeNs.equals(lc.getConnectionTypeNS())) {
                this.log.append("Mismatch between loaded connection type namespace in key and value of loaded components map, key is " + lc.getConnectionTypeNS() + " and value is " + connectionTypeNs + "\n");
            }
            if (lc.getConnectionTypeNS() == null && connectionTypeNs != null) {
                lc.setConnectionTypeNS(connectionTypeNs);
            }
            this.validateItemType(connectionType, connectionTypeNs, IContextHandle.class, "loaded components value", valueOffset, "connection type");
            String connectionId = this.validateUUID("loaded components value", valueOffset, "connection UUID", raf);
            if (connectionId != null && lc.getConnectionId() != null && !connectionId.equals(lc.getConnectionId())) {
                this.log.append("Mismatch between loaded connection id in key and value of loaded components map, key is " + lc.getConnectionId() + " and value is " + connectionId + "\n");
            }
            if (lc.getConnectionId() == null && connectionId != null) {
                lc.setConnectionId(connectionId);
            }
            if (lc.getConnectionId() != null && lc.getComponentId() != null) {
                this.gv.addLoadedComponent(lc);
            }
            if ((repo = this.validateString("loaded components value", valueOffset, "repository URI", raf)) != null && repo.length() != 0 && TeamServerFactoryImpl.INSTANCE.validateURL(repo) != 0) {
                this.log.append("The loaded components value at " + valueOffset + " contains a repository URI \"" + repo + "\" which is not valid\n");
            }
            this.validateUUID("loaded components value", valueOffset, "repo UUID", raf);
            this.validateString("loaded components value", valueOffset, "connection name", raf);
            this.validateString("loaded components value", valueOffset, "component name", raf);
        }
        finally {
            this.hv.claim(new HeapValidator.HeapClaimant(valueOffset, this.getPosition() - valueOffset, "Loaded Components Value"));
        }
    }

    @Override
    public boolean validateCustomMetadata(DataInputStream in) throws IOException {
        int v = in.readInt();
        if (v != 0) {
            this.log.append("Metadata version mismatch for loaded components map: " + v + " != " + 0);
            return false;
        }
        return true;
    }
}

