/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.ShareOutOfSync;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.ICurrentComponentInfo;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class VerifySharesOperation
extends FileSystemOperation
implements IVerifyInSyncOperation {
    private boolean alreadyExecuted;
    protected final OutOfSyncDilemmaHandler verifyInSyncDilemmaHandler;
    private boolean verifyAgainstCache;
    private HashMap<UUID, IWorkspaceConnection> connectionsToVerify;
    private HashMap<ConfigurationFacade, IConnection> configurationsToVerify;
    private ArrayList<IShare> sharesToVerify;
    private ArrayList<IConnection> shareConnections;
    private HashMap<UUID, HashMap<UUID, ISyncTime>> connectionComponentStates;

    public VerifySharesOperation(OutOfSyncDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? OutOfSyncDilemmaHandler.getDefault() : dilemmaHandler);
        this.verifyInSyncDilemmaHandler = dilemmaHandler == null ? OutOfSyncDilemmaHandler.getDefault() : dilemmaHandler;
        this.verifyAgainstCache = false;
        this.connectionsToVerify = new HashMap();
        this.configurationsToVerify = new HashMap();
        this.sharesToVerify = new ArrayList();
        this.shareConnections = new ArrayList();
        this.connectionComponentStates = new HashMap();
    }

    @Override
    public void setVerifyAgainstCache(boolean verifyAgainstCache) {
        this.verifyAgainstCache = verifyAgainstCache;
    }

    @Override
    public void addToVerify(IWorkspaceConnection workspaceConnection) {
        if (workspaceConnection == null) {
            throw new IllegalArgumentException();
        }
        this.connectionsToVerify.put(workspaceConnection.getContextHandle().getItemId(), workspaceConnection);
    }

    @Override
    public void addToVerify(IConnection connection, IComponentHandle componentHandle) {
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (componentHandle == null) {
            throw new IllegalArgumentException();
        }
        this.configurationsToVerify.put(new ConfigurationFacade(connection, componentHandle), connection);
    }

    @Override
    public void addToVerify(IConnection connection, Collection<IShare> shares) {
        if (shares == null) {
            throw new IllegalArgumentException();
        }
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        for (IShare shareToVerify : shares) {
            if (!shareToVerify.getSharingDescriptor().isAssociatedWithConnection(connection)) {
                throw new IllegalArgumentException();
            }
            this.shareConnections.add(connection);
            this.sharesToVerify.add(shareToVerify);
        }
    }

    @Override
    public void addToVerify(IConnection connection, IShare shareToVerify) {
        if (shareToVerify == null) {
            throw new IllegalArgumentException();
        }
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (!shareToVerify.getSharingDescriptor().isAssociatedWithConnection(connection)) {
            throw new IllegalArgumentException();
        }
        this.shareConnections.add(connection);
        this.sharesToVerify.add(shareToVerify);
    }

    public void addToVerifyAgainst(IConnection connection, Collection<IComponentStateSummary> expectedStates) {
        IWorkspace connectionHandle;
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (expectedStates == null) {
            throw new IllegalArgumentException();
        }
        if (connection instanceof IWorkspaceConnection) {
            connectionHandle = ((IWorkspaceConnection)connection).getResolvedWorkspace();
        } else if (connection instanceof IBaselineConnection) {
            connectionHandle = ((IBaselineConnection)connection).getBaseline();
        } else {
            throw new IllegalArgumentException();
        }
        for (IComponentStateSummary summary : expectedStates) {
            if (summary != null) continue;
            throw new IllegalArgumentException();
        }
        HashMap<Object, Object> states = this.connectionComponentStates.get(connectionHandle.getItemId());
        if (states == null) {
            states = new HashMap();
            this.connectionComponentStates.put(connectionHandle.getItemId(), states);
        }
        for (IComponentStateSummary summary : expectedStates) {
            states.put(summary.getComponent().getItemId(), summary.getConfigurationTime());
        }
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        if (this.alreadyExecuted) {
            throw new IllegalStateException();
        }
        this.alreadyExecuted = true;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (this.sharesToVerify.isEmpty() && this.configurationsToVerify.isEmpty() && this.connectionsToVerify.isEmpty()) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        Collection<ConfigurationFacade> affectedConfigurations = this.getAffectedConfigurationsToLock((IProgressMonitor)progress.newChild(1));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireReadForConfigurations(affectedConfigurations, (IProgressMonitor)progress.newChild(1));
        HashMap<ITeamRepository, Set<IShare>> inconsistentShares = new HashMap<ITeamRepository, Set<IShare>>();
        try {
            ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
            Collection<ICopyFileAreaLockRequest> locksToObtain = this.getCopyFileAreaLocksToObtain((IProgressMonitor)progress.newChild(1));
            ICopyFileAreasLock cfaLock = cfaMgr.lock(locksToObtain, (IProgressMonitor)progress.newChild(1));
            try {
                this.getComponentStatesToVerifyAgainst((IProgressMonitor)progress.newChild(50));
                this.verifyShares(inconsistentShares, (IProgressMonitor)progress.newChild(20));
                this.verifyConfigurations(inconsistentShares, (IProgressMonitor)progress.newChild(20));
                this.verifyConnections(inconsistentShares, (IProgressMonitor)progress.newChild(5));
            }
            finally {
                cfaLock.release((IProgressMonitor)progress.newChild(1));
            }
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
        if (!inconsistentShares.isEmpty()) {
            this.handleOutOfSyncShares(inconsistentShares, (IProgressMonitor)progress.newChild(100));
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private Collection<ICopyFileAreaLockRequest> getCopyFileAreaLocksToObtain(IProgressMonitor monitor) throws TeamRepositoryException {
        ICopyFileAreaManager.ICopyFileAreaLockRequestFactory lockFactory = ICopyFileAreaManager.instance.lockRequestFactory();
        ArrayList<ICopyFileAreaLockRequest> cfaLocks = new ArrayList<ICopyFileAreaLockRequest>(2);
        HashSet<ConfigurationFacade> configurationsToLock = new HashSet<ConfigurationFacade>();
        for (IWorkspaceConnection connection : this.connectionsToVerify.values()) {
            for (IComponentHandle component : connection.getComponents()) {
                configurationsToLock.add(new ConfigurationFacade((IConnection)connection, component));
            }
        }
        configurationsToLock.addAll(this.configurationsToVerify.keySet());
        if (!configurationsToLock.isEmpty()) {
            cfaLocks.add(lockFactory.getLockRequest(configurationsToLock, false));
        }
        ArrayList<IShareable> shareablesToLock = new ArrayList<IShareable>(this.sharesToVerify.size());
        for (IShare share : this.sharesToVerify) {
            shareablesToLock.add(share.getShareable());
        }
        if (!shareablesToLock.isEmpty()) {
            lockFactory.getLockRequest(shareablesToLock);
        }
        return cfaLocks;
    }

    private Collection<ConfigurationFacade> getAffectedConfigurationsToLock(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashSet<ConfigurationFacade> configurationsToLock = new HashSet<ConfigurationFacade>();
        if (this.verifyAgainstCache) {
            for (IWorkspaceConnection connection : this.connectionsToVerify.values()) {
                for (IComponentHandle component : connection.getComponents()) {
                    configurationsToLock.add(new ConfigurationFacade((IConnection)connection, component));
                }
            }
            configurationsToLock.addAll(this.configurationsToVerify.keySet());
            Iterator<IConnection> shareConnectionIter = this.shareConnections.iterator();
            for (IShare share : this.sharesToVerify) {
                IConnection connection = shareConnectionIter.next();
                if (connection instanceof IBaselineConnection) continue;
                ISharingDescriptor descriptor = share.getSharingDescriptor();
                configurationsToLock.add(new ConfigurationFacade((IConnection)((IWorkspaceConnection)connection), descriptor.getComponent()));
            }
        }
        progress.done();
        return configurationsToLock;
    }

    private void getComponentStatesToVerifyAgainst(IProgressMonitor monitor) throws TeamRepositoryException {
        block9: {
            SubMonitor progress;
            block8: {
                progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 * (this.sharesToVerify.size() + this.configurationsToVerify.size() + this.connectionsToVerify.size())));
                if (!this.verifyAgainstCache) break block8;
                for (IWorkspaceConnection connection : this.connectionsToVerify.values()) {
                    for (ICurrentComponentInfo componentInfo : connection.getComponentsInfo()) {
                        this.addSyncTime((IContextHandle)connection.getResolvedWorkspace(), componentInfo.getComponent(), componentInfo.configurationTime());
                    }
                }
                for (ConfigurationFacade configurationDescriptor : this.configurationsToVerify.keySet()) {
                    IConnection connection = configurationDescriptor.getConnection((IProgressMonitor)progress.newChild(1));
                    if (connection instanceof IBaselineConnection) {
                        this.addSyncTime(connection.getContextHandle(), ((IBaselineConnection)connection).getComponent(), ISyncTime.FACTORY.getConfigTimeFor((IBaselineHandle)((IBaselineConnection)connection).getResolvedBaseline(), null));
                        continue;
                    }
                    ICurrentComponentInfo componentInfo = ((IWorkspaceConnection)connection).getComponentInfo(configurationDescriptor.getComponentHandle());
                    this.addSyncTime(connection.getContextHandle(), configurationDescriptor.getComponentHandle(), componentInfo.configurationTime());
                }
                Iterator<IConnection> shareConnectionIter = this.shareConnections.iterator();
                for (IShare iShare : this.sharesToVerify) {
                    IConnection connection = shareConnectionIter.next();
                    if (connection instanceof IBaselineConnection) {
                        this.addSyncTime(connection.getContextHandle(), ((IBaselineConnection)connection).getComponent(), ISyncTime.FACTORY.getConfigTimeFor((IBaselineHandle)((IBaselineConnection)connection).getResolvedBaseline(), null));
                        continue;
                    }
                    ISharingDescriptor descriptor = iShare.getSharingDescriptor();
                    ICurrentComponentInfo componentInfo = ((IWorkspaceConnection)connection).getComponentInfo(descriptor.getComponent());
                    this.addSyncTime(connection.getContextHandle(), descriptor.getComponent(), componentInfo.configurationTime());
                }
                break block9;
            }
            if (!this.connectionComponentStates.isEmpty()) break block9;
            HashSet<Object> connections = new HashSet<Object>();
            connections.addAll(this.connectionsToVerify.values());
            connections.addAll(this.configurationsToVerify.values());
            connections.addAll(this.shareConnections);
            for (IConnection iConnection : connections) {
                FileSystemServiceProxy fileSystemService = ((FileSystemManager)FileSystemCore.getFileSystemManager(iConnection.teamRepository())).getFileSystemService();
                List<IComponentStateSummary> stateSummaries = fileSystemService.getComponentStateSummaries(iConnection, (IProgressMonitor)progress.newChild(1));
                for (IComponentStateSummary stateSummary : stateSummaries) {
                    this.addSyncTime(iConnection.getContextHandle(), stateSummary.getComponent(), stateSummary.getConfigurationTime());
                }
            }
        }
    }

    private void addSyncTime(IContextHandle context, IComponentHandle component, ISyncTime syncTime) {
        HashMap<Object, Object> componentInfos = this.connectionComponentStates.get(context.getItemId());
        if (componentInfos == null) {
            componentInfos = new HashMap();
            this.connectionComponentStates.put(context.getItemId(), componentInfos);
        }
        componentInfos.put(component.getItemId(), syncTime);
    }

    private void verifyShares(Map<ITeamRepository, Set<IShare>> inconsistentShares, IProgressMonitor monitor) {
        Iterator<IConnection> shareConnectionIter = this.shareConnections.iterator();
        for (IShare share : this.sharesToVerify) {
            IConnection connection = shareConnectionIter.next();
            this.validShare(connection, share, inconsistentShares);
        }
    }

    private boolean validShare(IConnection connection, IShare share, Map<ITeamRepository, Set<IShare>> inconsistentShares) {
        boolean isValid = false;
        SharingDescriptor descriptor = (SharingDescriptor)share.getSharingDescriptor();
        HashMap<UUID, ISyncTime> componentStates = this.connectionComponentStates.get(descriptor.getConnectionHandle().getItemId());
        ISyncTime expectedState = null;
        if (componentStates != null) {
            expectedState = componentStates.get(descriptor.getComponent().getItemId());
        }
        if (!(isValid = descriptor.getConfigurationState().equals(expectedState))) {
            Set<IShare> shares = inconsistentShares.get(connection.teamRepository());
            if (shares == null) {
                shares = new HashSet<IShare>();
                inconsistentShares.put(connection.teamRepository(), shares);
            }
            shares.add(share);
        }
        return isValid;
    }

    private HashMap<IConnection, HashMap<UUID, IComponentHandle>> verifyConnections(Map<ITeamRepository, Set<IShare>> inconsistentShares, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.connectionsToVerify.size() * 10));
        HashMap<IConnection, HashMap<UUID, IComponentHandle>> componentsToReload = new HashMap<IConnection, HashMap<UUID, IComponentHandle>>();
        SharingManager sm = SharingManager.getInstance();
        for (IConnection iConnection : this.connectionsToVerify.values()) {
            Collection<IShare> allShares = sm.getShares(iConnection, (IProgressMonitor)progress);
            for (IShare share : allShares) {
                if (this.validShare(iConnection, share, inconsistentShares)) continue;
                HashMap<Object, Object> components = componentsToReload.get(iConnection);
                if (components == null) {
                    components = new HashMap();
                    componentsToReload.put(iConnection, components);
                }
                ISharingDescriptor descriptor = share.getSharingDescriptor();
                components.put(descriptor.getComponent().getItemId(), descriptor.getComponent());
            }
        }
        return componentsToReload;
    }

    private HashMap<IConnection, HashMap<UUID, IComponentHandle>> verifyConfigurations(Map<ITeamRepository, Set<IShare>> inconsistentShares, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.connectionsToVerify.size() * 10));
        HashMap<IConnection, HashMap<UUID, IComponentHandle>> componentsToReload = new HashMap<IConnection, HashMap<UUID, IComponentHandle>>();
        SharingManager sm = SharingManager.getInstance();
        for (Map.Entry<ConfigurationFacade, IConnection> entry : this.configurationsToVerify.entrySet()) {
            ConfigurationFacade configuration = entry.getKey();
            IConnection connection = entry.getValue();
            Collection<IShare> allShares = sm.getShares(configuration, (IProgressMonitor)progress);
            for (IShare share : allShares) {
                if (this.validShare(connection, share, inconsistentShares)) continue;
                HashMap<Object, Object> components = componentsToReload.get(connection);
                if (components == null) {
                    components = new HashMap();
                    componentsToReload.put(connection, components);
                }
                ISharingDescriptor descriptor = share.getSharingDescriptor();
                components.put(descriptor.getComponent().getItemId(), descriptor.getComponent());
            }
        }
        return componentsToReload;
    }

    private void handleOutOfSyncShares(Map<ITeamRepository, Set<IShare>> inconsistentShares, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        ArrayList<IShareOutOfSync> problemShares = new ArrayList<IShareOutOfSync>();
        for (Set<IShare> shares : inconsistentShares.values()) {
            for (IShare share : shares) {
                problemShares.add(new ShareOutOfSync(share));
            }
        }
        int result = this.verifyInSyncDilemmaHandler.outOfSync(problemShares);
        if (result == 100) {
            this.reloadOutOfSync(inconsistentShares, progress);
        } else if (result != 1) {
            IStatus[] statuses = new IStatus[problemShares.size()];
            int i = 0;
            for (IShareOutOfSync shareOutOfSync : problemShares) {
                statuses[i] = FileSystemStatusUtil.getStatusFor(1, NLS.bind((String)Messages.VerifySharesOperation_0, (Object)shareOutOfSync.getShare().getPath().toString()));
                ++i;
            }
            MultiStatus status = new MultiStatus("com.ibm.team.filesystem.client", 4, statuses, Messages.VerifySharesOperation_1, null);
            if (result != 0) {
                this.collectStatus((IStatus)status);
            }
        } else {
            throw new OperationCanceledException();
        }
    }

    protected void reloadOutOfSync(Map<ITeamRepository, Set<IShare>> inconsistentShares, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        if (!inconsistentShares.isEmpty()) {
            for (Map.Entry<ITeamRepository, Set<IShare>> entry : inconsistentShares.entrySet()) {
                final ITeamRepository repo = entry.getKey();
                IRepositoryResolver resolver = new IRepositoryResolver(){

                    @Override
                    public ITeamRepository getRepoFor(String uri, UUID id) throws TeamRepositoryException {
                        return repo;
                    }
                };
                ILoadOperation op = IOperationFactory.instance.getLoadOperation(this.verifyInSyncDilemmaHandler);
                op.setEclipseSpecificLoadOptions(4);
                op.requestReLoad((Collection<IShare>)entry.getValue(), resolver, true, (IProgressMonitor)monitor.newChild(10));
                op.run((IProgressMonitor)monitor.newChild(90));
            }
        }
    }
}

