/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.rest.parameters;

import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.ParmValidation;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import java.util.List;

public final class ParmsLoadComponentVersionables
implements IParameterWrapper {
    public String sandboxPath;
    public String relativeLoadPath;
    public ParmsWorkspace workspace;
    public String componentItemId;
    public String[] folderItemIds;
    public String[] fileItemIds;
    public String[] symbolicLinkItemIds;

    public void validate(String requestName, Object ... parameterName) {
        ParmValidation.requiredValue(this.sandboxPath, requestName, parameterName, "sandboxPath");
        this.sandboxPath = ParmValidation.validCanonicalPath(this.sandboxPath, requestName, parameterName, "sandboxPath");
        if (this.relativeLoadPath != null && this.relativeLoadPath.trim().length() > 0) {
            this.relativeLoadPath = ParmValidation.validRelativeCanonicalPath(this.sandboxPath, this.relativeLoadPath, requestName, parameterName, "relativeLoadPath");
        }
        ParmValidation.requiredValue(this.workspace, requestName, parameterName, "workspace");
        this.workspace.validate(requestName, parameterName, "workspace");
        ParmValidation.requiredValue(this.componentItemId, requestName, parameterName, "componentItemId");
        if (this.folderItemIds != null) {
            ParmValidation.requiredArray(this.folderItemIds, requestName, parameterName, "folderItemIds");
        }
        if (this.fileItemIds != null) {
            ParmValidation.requiredArray(this.fileItemIds, requestName, parameterName, "fileItemIds");
        }
        if (this.symbolicLinkItemIds != null) {
            ParmValidation.requiredArray(this.symbolicLinkItemIds, requestName, parameterName, "symbolicLinkItemIds");
        }
    }

    public List<IFolderHandle> getFolderHandles() {
        return CommonUtil.createHandles(IFolder.ITEM_TYPE, this.workspace.repositoryUrl, this.folderItemIds);
    }

    public List<IFileItemHandle> getFileItemHandles() {
        return CommonUtil.createHandles(IFileItem.ITEM_TYPE, this.workspace.repositoryUrl, this.fileItemIds);
    }

    public List<ISymbolicLinkHandle> getSymbolicLinkHandles() {
        return CommonUtil.createHandles(ISymbolicLink.ITEM_TYPE, this.workspace.repositoryUrl, this.symbolicLinkItemIds);
    }

    public IComponentHandle getComponentHandle() throws TeamRepositoryException {
        ITeamRepository repo = CommonUtil.getTeamRepository(this.workspace.repositoryUrl);
        return (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.componentItemId), null);
    }
}

