/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.analysis;

import com.ibm.team.fulltext.common.TokenizerTypes;
import com.ibm.team.fulltext.common.internal.analysis.ArtifactAttribute;
import com.ibm.team.fulltext.common.internal.analysis.ArtifactAttributeImpl;
import com.ibm.team.fulltext.common.internal.query.PorterStemmingCache;
import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.tartarus.snowball.SnowballProgram;

public final class PorterStemFilter
extends TokenFilter {
    private ArtifactAttribute attribute = ArtifactAttributeImpl.addAttributeToStream((TokenStream)this);
    private final SnowballProgram stemmer;

    public PorterStemFilter(TokenStream in, SnowballProgram stemmer) {
        super(in);
        this.stemmer = stemmer;
    }

    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        if (this.attribute.isArtifact() && !this.attribute.applies(TokenizerTypes.PORTER_STEM_WORDS)) {
            return true;
        }
        char[] termBuffer = this.attribute.buffer();
        int length = this.attribute.length();
        this.stemmer.setCurrent(termBuffer, length);
        String original = new String(termBuffer, 0, length);
        if (this.stemmer.stem()) {
            char[] newBuffer = this.stemmer.getCurrentBuffer();
            int newLength = this.stemmer.getCurrentBufferLength();
            if (newBuffer != termBuffer) {
                this.attribute.copyBuffer(newBuffer, 0, newLength);
            } else {
                this.attribute.setLength(newLength);
            }
            PorterStemmingCache.put(new String(newBuffer, 0, newLength), original);
        }
        return true;
    }
}

