/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common;

import org.eclipse.core.runtime.Assert;

public class ContentType {
    public static final ContentType HTML = new ContentType("text/html");
    public static final ContentType HOVER_HTML = new ContentType("text/html", "hover");
    public static final ContentType HOVER_HTML_SMALL = new ContentType("text/html", "smallHover");
    public static final ContentType JSON = new ContentType("application/json");
    public static final ContentType JSON_DEPRECATED = new ContentType("text/json");
    public static final ContentType ATOM = new ContentType("application/atom+xml");
    public static final ContentType RSS = new ContentType("application/rss+xml");
    public static final ContentType RDF = new ContentType("application/rdf+xml");
    public static final ContentType XHTML = new ContentType("application/xhtml+xml");
    public static final ContentType XML = new ContentType("text/xml");
    public static final ContentType XML_APP = new ContentType("application/xml");
    public static final ContentType TEXT_PLAIN = new ContentType("text/plain");
    public static final ContentType CSS = new ContentType("text/css");
    public static final ContentType FORM_URLENCODED = new ContentType("application/x-www-form-urlencoded");
    public static final ContentType MULTIPART_FORMDATA = new ContentType("multipart/form-data");
    public static final ContentType OSLC_CHANGE_REQUEST_XML = new ContentType("application/x-oslc-cm-change-request+xml");
    public static final ContentType OSLC_CHANGE_REQUEST_XML2 = new ContentType("application/x-oslc-cm-changerequest+xml");
    public static final ContentType OSLC_CHANGE_REQUEST_JSON = new ContentType("application/x-oslc-cm-change-request+json");
    public static final ContentType OSLC_CHANGE_REQUEST_JSON2 = new ContentType("application/x-oslc-cm-changerequest+json");
    public static final ContentType OSLC_SERVICE_CATALOG_XML = new ContentType("application/x-oslc-disc-service-provider-catalog+xml");
    public static final ContentType OSLC_SERVICE_XML = new ContentType("application/x-oslc-cm-service-description+xml");
    public static final ContentType COMPACT_RENDERING = new ContentType("application/x-jazz-compact-rendering");
    public static final ContentType UI_PREVIEW = new ContentType("application/x-oslc-compact+xml");
    public static final ContentType TURTLE = new ContentType("text/turtle");
    public static final ContentType TURTLE_PROV = new ContentType("application/x-turtle");
    public static final ContentType N3 = new ContentType("text/rdf+n3");
    public static final ContentType SPARQL_QUERY = new ContentType("application/sparql-query");
    public static final ContentType PDF = new ContentType("application/pdf");
    public static final ContentType ANY = new ContentType("*/*");
    public static final ContentType UNKNOWN = new ContentType("application/unknown");
    public static final ContentType OCTET_STREAM = new ContentType("application/octet-stream");
    private final String fContentType;
    private final String fMimeType;
    private final String fSelector;

    public ContentType(String contentType) {
        this(contentType, null);
    }

    public ContentType(String contentType, String selector) {
        Assert.isNotNull((Object)contentType);
        this.fContentType = contentType;
        int delimiter = contentType.indexOf(59);
        this.fMimeType = (delimiter == -1 ? contentType : contentType.substring(0, delimiter)).trim();
        this.fSelector = selector == null ? "" : selector;
    }

    public String getMimeType() {
        return this.fMimeType;
    }

    public String getValue() {
        return this.fContentType;
    }

    public String toString() {
        return this.fContentType;
    }

    public int hashCode() {
        return this.fContentType.hashCode() ^ this.fSelector.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ContentType other = (ContentType)object;
        return this.fContentType.equals(other.fContentType) && this.fSelector.equals(other.fSelector);
    }

    public boolean sameMimeType(ContentType other) {
        return this.fMimeType.equals(other.fMimeType);
    }

    public boolean sameMimeType(String mimeType) {
        return this.fMimeType.equals(mimeType);
    }

    public String getSelector() {
        return this.fSelector;
    }
}

