/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.internal.linking;

import com.ibm.team.calm.foundation.common.UnsupportedVersionException;
import com.ibm.team.calm.foundation.common.internal.Messages;
import com.ibm.team.calm.foundation.common.internal.OSLCResource;
import com.ibm.team.calm.foundation.common.internal.linking.CALMBackLink;
import com.ibm.team.calm.foundation.common.internal.linking.CALMBackLinkOperation;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformation;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.transport.UriUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class CMBackLinkOperation
extends CALMBackLinkOperation {
    private static final String CM_LINK_URL_ID = "rdf:resource";
    private static final String CM_LINK_LABEL_ID = "oslc_cm:label";

    @Override
    public List<CALMBackLink> loadExistingLinks() throws TeamRepositoryException, UnsupportedVersionException {
        String linkCollectionUrl = this.createLinkCollectionURL();
        OSLCResource resource = super.loadResource(linkCollectionUrl);
        JSONObject jsObj = null;
        try {
            jsObj = JSONObject.parse((Reader)new StringReader(resource.getContent()));
        }
        catch (IOException ex) {
            String message = MessageFormat.format(Messages.getString("CALMBackLinkOperation.ERROR_PARSING_RESOURCE_JSON"), linkCollectionUrl);
            throw new TeamRepositoryException(message, (Throwable)ex);
        }
        Object jsLinksObj = jsObj.get((Object)this.createLinkName());
        if (jsLinksObj == null || !(jsLinksObj instanceof JSONArray)) {
            String message = MessageFormat.format(Messages.getString("CALMBackLinkOperation.ERROR_NO_LINK_IN_RESOURCE"), this.createLinkName());
            throw new TeamRepositoryException(message);
        }
        return this.parseBackLinks((JSONArray)jsLinksObj);
    }

    @Override
    public void storeLinks(List<CALMBackLink> newLinks) throws TeamRepositoryException {
        JSONObject jsObj = this.createJasonObject(newLinks);
        super.storeResource(jsObj.toString());
    }

    @Override
    public CALMBackLinkOperation clone() {
        CMBackLinkOperation result = new CMBackLinkOperation();
        result.setVersion(this.getVersion());
        result.setContentType(this.getContentType());
        result.setElementName(this.getElementName());
        result.setHttpHeaders(this.getHttpHeaders());
        return result;
    }

    private JSONObject createJasonObject(List<CALMBackLink> newLinks) {
        JSONArray array = new JSONArray();
        for (CALMBackLink curLink : newLinks) {
            JSONObject linkItem = new JSONObject();
            linkItem.put((Object)CM_LINK_URL_ID, (Object)curLink.getTargetURL());
            linkItem.put((Object)CM_LINK_LABEL_ID, (Object)curLink.getLinkComment());
            array.add((Object)linkItem);
        }
        JSONObject result = new JSONObject();
        result.put((Object)this.createLinkName(), (Object)array);
        return result;
    }

    private List<CALMBackLink> parseBackLinks(JSONArray jsLinks) throws TeamRepositoryException {
        ArrayList<CALMBackLink> result = new ArrayList<CALMBackLink>();
        int idx = 0;
        while (idx < jsLinks.size()) {
            if (jsLinks.get(idx) instanceof JSONObject) {
                JSONObject curJsObj = (JSONObject)jsLinks.get(idx);
                Object curTarget = curJsObj.get((Object)CM_LINK_URL_ID);
                Object curLabel = curJsObj.get((Object)CM_LINK_LABEL_ID);
                if (curTarget instanceof String && curLabel instanceof String) {
                    result.add(this.createBackLink((String)curTarget, (String)curLabel));
                } else {
                    throw new TeamRepositoryException(MessageFormat.format(Messages.getString("CALMBackLinkOperation.ERROR_PARSING_RESOURCE_JSON"), this.createLinkCollectionURL()));
                }
            }
            ++idx;
        }
        return result;
    }

    private String createLinkName() {
        CALMLinkTypeInformation.BackLinkElement backLink = this.getBackLinkElement();
        return this.getNamespaces().qualify(backLink.getNamespaceURI(), backLink.getTypeId());
    }

    private String createLinkCollectionURL() {
        return String.valueOf(this.getBackLink().getSourceURL()) + "?oslc_cm.properties=" + UriUtil.encode((String)this.createLinkName());
    }
}

