/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.internal.linking;

import com.ibm.team.calm.foundation.common.HttpHeaders;
import com.ibm.team.calm.foundation.common.IHttpClient;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Locale;
import java.util.Map;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeaderValueParser;

public interface IHttpAccess {
    public boolean isModifyingResponse();

    public void setModifyingResponse(boolean var1);

    public String encodeURL(String var1);

    public String encodeURL(String var1, String var2);

    public Response performGet(String var1, String var2) throws TeamRepositoryException;

    public Response performGet(String var1, Map<String, String> var2) throws TeamRepositoryException;

    public Response performGetWithExtraParameters(String var1, String var2, String var3, String var4) throws TeamRepositoryException;

    public Response performPut(String var1, String var2, String var3, Map<String, String> var4) throws TeamRepositoryException;

    public Response performPost(String var1, String var2, String var3, Map<String, String> var4) throws TeamRepositoryException;

    public static class HttpAccessUtil {
        public static String getAcceptLanguageHeader(Locale locale) {
            String variant;
            StringBuilder buffer = new StringBuilder(locale.getLanguage());
            String country = locale.getCountry();
            if (country.length() > 0) {
                buffer.append('-').append(country);
            }
            if ((variant = locale.getVariant()).length() > 0) {
                buffer.append('-').append(variant);
            }
            return buffer.toString();
        }
    }

    public static class Response
    implements IHttpClient.IResponse {
        private final HttpHeaders fHeaders;
        private String fContent;
        private InputStream fStream;
        private final int fStatusCode;

        public Response(IHttpClient.IResponse response) throws TeamRepositoryException {
            this.fStatusCode = response.getStatusCode();
            this.fHeaders = response.getResponseHeaders();
            this.fContent = response.getContent();
            this.fStream = null;
        }

        public Response(int statusCode, Map<String, String> headers, String content) {
            this.fStatusCode = statusCode;
            this.fHeaders = new HttpHeaders(headers);
            this.fContent = content;
            this.fStream = null;
        }

        public Response(int statusCode, Map<String, String> headers, InputStream stream) {
            this.fStatusCode = statusCode;
            this.fHeaders = new HttpHeaders(headers);
            this.fStream = stream;
            this.fContent = null;
        }

        @Override
        public int getStatusCode() {
            return this.fStatusCode;
        }

        @Override
        public String getContent() throws TeamRepositoryException {
            if (this.fContent == null) {
                this.fContent = this.readResponse();
            }
            return this.fContent;
        }

        public String getResponseHeader(String header) {
            return this.fHeaders.getValue(header);
        }

        @Override
        public HttpHeaders getResponseHeaders() {
            return this.fHeaders;
        }

        @Override
        public InputStream getResponseStream() {
            if (this.fStream == null && this.fContent != null) {
                return new ByteArrayInputStream(this.fContent.getBytes());
            }
            return this.fStream;
        }

        @Override
        public Reader getResponseReader() throws TeamRepositoryException {
            if (this.fStream == null && this.fContent != null) {
                return new StringReader(this.fContent);
            }
            if (this.fStream != null) {
                try {
                    return new InputStreamReader(this.fStream, this.getEncoding("UTF-8"));
                }
                catch (IOException ex) {
                    throw new TeamRepositoryException(ex.getMessage(), (Throwable)ex);
                }
            }
            return new StringReader(new String());
        }

        private String readResponse() throws TeamRepositoryException {
            try {
                if (this.fStream != null) {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream(8192);
                    byte[] bytes = new byte[8192];
                    try {
                        int ch = this.fStream.read(bytes);
                        while (ch != -1) {
                            buffer.write(bytes, 0, ch);
                            ch = this.fStream.read(bytes);
                        }
                    }
                    finally {
                        if (this.fStream != null) {
                            this.fStream.close();
                        }
                    }
                    return buffer.toString(this.getEncoding("UTF-8"));
                }
                return null;
            }
            catch (IOException ex) {
                throw new TeamRepositoryException(ex.getMessage(), (Throwable)ex);
            }
        }

        private String getEncoding(String defaultCharset) {
            NameValuePair param;
            HeaderElement[] values;
            String contentTypeHeader = this.getResponseHeaders().getValue("Content-Type");
            if (contentTypeHeader != null && (values = BasicHeaderValueParser.parseElements((String)contentTypeHeader, null)).length > 0 && (param = values[0].getParameterByName("charset")) != null) {
                return param.getValue();
            }
            return defaultCharset;
        }

        @Override
        public Throwable getException() {
            return null;
        }
    }
}

