/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.vfs.client.cache;

import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.IO;
import com.urbancode.vfs.client.cache.Cache;
import com.urbancode.vfs.client.cache.CacheStagingFileOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class CacheStagingFile {
    private final Object lock = new Object();
    private final File file;
    private final byte[] identifier;
    private final Cache cache;
    private final CacheStagingFileOutputStream stream;
    private boolean committed;
    private boolean aborted;

    CacheStagingFile(File file, byte[] identifier, Cache cache) throws IOException {
        Check.nonNull((Object)file, (String)"file");
        Check.nonNull((Object)identifier, (String)"identifier");
        Check.nonNull((Object)cache, (String)"cache");
        this.file = file;
        this.identifier = (byte[])identifier.clone();
        this.cache = cache;
        this.stream = new CacheStagingFileOutputStream(file);
    }

    public OutputStream getStream() {
        return this.stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws IOException {
        if (!this.stream.isClosed()) {
            throw new IllegalStateException("Stream not closed");
        }
        boolean committing = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.aborted) {
                throw new IllegalStateException("Aborted");
            }
            if (!this.committed) {
                this.committed = true;
                committing = true;
            }
        }
        if (committing) {
            this.cache.cache(this.file, this.identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        boolean aborting = false;
        Object object = this.lock;
        synchronized (object) {
            if (!this.aborted && !this.committed) {
                this.aborted = true;
                aborting = true;
            }
        }
        if (aborting) {
            IO.closeNoThrow((OutputStream)this.stream);
            this.file.delete();
        }
    }
}

