/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.ri.impl.BaselineImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoFolderItem;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoStream;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.connector.scm.client.JzRepoVersionHistory;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.dto.IBaselineSetSearchCriteria;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.Baseline;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.Version;
import javax.wvcm.VersionSet;
import javax.wvcm.WvcmException;

public class JzRepoBaseline
extends JzRepoResource {
    public JzRepoBaseline(JzProvider provider, JzLocation loc) {
        super(provider, (Location)loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return BaselineImpl.class;
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Baseline.VERSION_HISTORY)) {
            return this.getComponent(feedback);
        }
        if (propertyName.equals((Object)Baseline.VERSION_LIST)) {
            return this.getVersionList(feedback);
        }
        if (propertyName.equals((Object)Version.VERSION_NAME) || propertyName.equals((Object)Resource.DISPLAY_NAME)) {
            if (JzLocation.Kind.Snapshot.equals((Object)this.location().kind())) {
                IBaselineSet snapshot = this.getSnapshot(feedback);
                return snapshot.getName();
            }
            return this.getConnection(feedback).getName();
        }
        if (propertyName.equals((Object)Baseline.SUB_BASELINE_LIST)) {
            return this.getSubBaselineList(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    public List<JzRepoBaseline> getSubBaselineList(SrvcFeedback feedback) throws WvcmException {
        if (JzLocation.Kind.Snapshot.equals((Object)this.location().kind())) {
            JzProvider p = this.provider();
            IBaselineSet snapshot = this.getSnapshot(feedback);
            List subs = snapshot.getBaselines();
            IWorkspaceManager workspaceManager = this.getWorkspaceManager();
            ArrayList<JzRepoBaseline> results = new ArrayList<JzRepoBaseline>(subs.size());
            try {
                for (IBaselineHandle h : subs) {
                    IBaselineConnection conn = workspaceManager.getBaselineConnection(h, JzProvider.getMonitor(feedback, 20));
                    JzRepoComponent jrComp = JzRepoComponent.create(conn.getComponent(), p);
                    results.add(JzRepoBaseline.create(jrComp, h));
                }
                return results;
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException(e);
            }
        }
        return null;
    }

    public IBaselineSet getSnapshot(SrvcFeedback feedback) throws WvcmException {
        IBaselineSetHandle h = (IBaselineSetHandle)this.getItemHandle(feedback.nest(50));
        IBaselineSet snapshot = (IBaselineSet)JzProvider.fetchCompleteItem((IItemHandle)h, this.provider().getRepo(), JzProvider.getMonitor(feedback, 100));
        return snapshot;
    }

    @Override
    public IConfiguration getConfiguration(SrvcFeedback feedback) throws WvcmException {
        return this.getConnection(feedback).configuration();
    }

    private List<JzRepoVersion> getVersionList(SrvcFeedback feedback) throws WvcmException {
        JzRepoComponent comp = this.getComponent(feedback);
        ArrayList<JzRepoVersion> result = new ArrayList<JzRepoVersion>();
        JzRepoBaseline.getVersionList(this.provider(), comp, this.getConfiguration(feedback), result, feedback);
        return result;
    }

    public List<SrvcResource.SrvcCompareReport> doCompareReport(SrvcResource otherVersionSet, VersionSet.CompareFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        IBaselineConnection thisConn = this.getConnection(feedback);
        IBaselineConnection otherConnection = otherVersionSet instanceof JzRepoBaseline ? ((JzRepoBaseline)otherVersionSet).getConnection(feedback) : ((JzRepoStream)otherVersionSet).getRefreshedConnection(feedback);
        this.logDebug(String.format("comparing this BL: %s with other VersionSet: %s", this.location().string(), otherVersionSet.location().string()));
        List nullCHL = Collections.EMPTY_LIST;
        return this.computeWvcmCompareReport((IConnection)thisConn, (IConnection)otherConnection, Collections.singletonList(thisConn.getComponent()), nullCHL, flags, feedback);
    }

    public IBaselineConnection getConnection(SrvcFeedback feedback) throws WvcmException {
        IBaselineHandle blH = (IBaselineHandle)this.getItemHandle(feedback);
        IWorkspaceManager workspaceManager = this.getWorkspaceManager();
        try {
            IBaselineConnection result = workspaceManager.getBaselineConnection(blH, JzProvider.getMonitor(feedback, 100));
            return result;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
    }

    public static JzRepoBaseline lookup(JzProvider provider, JzLocation location, SrvcFeedback feedback) throws WvcmException {
        JzRepoBaseline result = new JzRepoBaseline(provider, location);
        try {
            JzLocation.Kind k = location.kind();
            if (JzLocation.Kind.Snapshot.equals((Object)k)) {
                IItemHandle h = JzRepoBaseline.getItemHandle(provider, location);
                IItem snapshot = JzProvider.fetchCompleteItem(h, provider.getRepo(), JzProvider.getMonitor(feedback, 100));
                if (snapshot == null) {
                    result = null;
                } else {
                    result.setItemHandle(h);
                }
            } else {
                result.getConnection(feedback);
            }
        }
        catch (WvcmException e) {
            if (!WvcmException.ReasonCode.NOT_FOUND.equals((Object)e.getReasonCode())) {
                throw e;
            }
            provider.logIgnoredExceptionAsNotAlwaysVisible("JzRepoBaseline.lookup", (Exception)((Object)e));
            result = null;
        }
        return result;
    }

    protected SrvcResource locateByHistory(SrvcResource genericVersionHistory, SrvcFeedback feedback) throws WvcmException {
        return ((JzRepoVersionHistory)genericVersionHistory).lookupVersion(this.getConnection(feedback).configuration(), feedback);
    }

    public Map<String, SrvcResource> getFolderVersionChildMap(SrvcResource folderVersion, SrvcFeedback feedback) throws WvcmException {
        Map<String, JzRepoResource> childMap = ((JzRepoFolderItem)folderVersion).childMap(true, this.getConnection(feedback).configuration(), feedback);
        HashMap<String, SrvcResource> results = new HashMap<String, SrvcResource>(childMap);
        return results;
    }

    public List<SrvcResource> getFolderVersionChildList(SrvcResource folderVersion, SrvcFeedback feedback) throws WvcmException {
        return ((JzRepoFolderItem)folderVersion).childList(this.getConnection(feedback).configuration(), feedback);
    }

    public static JzRepoBaseline create(JzProvider provider, JzLocation loc, IBaselineHandle myItemHandle) {
        JzRepoBaseline result = new JzRepoBaseline(provider, loc);
        result.setItemHandle((IItemHandle)myItemHandle);
        return result;
    }

    public static JzRepoBaseline create(JzRepoComponent comp, IBaselineHandle myItemHandle) throws WvcmException {
        JzLocation resultLoc = JzRepoBaseline.createBaselineLocation(comp, myItemHandle);
        return JzRepoBaseline.create(comp.provider(), resultLoc, myItemHandle);
    }

    public static JzLocation createBaselineLocation(JzRepoComponent comp, IBaselineHandle myItemHandle) throws WvcmException {
        String displayName = JzRepoResource.getCurrentStateDisplayName((IItemHandle)myItemHandle);
        JzLocation resultLoc = comp.location().createBaselineLoc(displayName);
        return resultLoc;
    }

    public static JzRepoBaseline createSnapshot(JzProvider p, IBaselineSetHandle h) throws WvcmException {
        JzLocation myLoc = JzLocation.createSnapshotLocation(JzRepoBaseline.getCurrentStateDisplayName((IItemHandle)h));
        return new JzRepoBaseline(p, myLoc);
    }

    public static List<SrvcResource> doFindSnapshots(JzProvider p, Baseline query, boolean all, SrvcFeedback feedback) throws WvcmException {
        IProcessArea area = p.getProcessArea(feedback.nest(10));
        IBaselineSetSearchCriteria crit = IBaselineSetSearchCriteria.FACTORY.newInstance().setProcessArea((IProcessAreaHandle)area);
        Object value = query.lookupProperty(Resource.DISPLAY_NAME);
        if (value instanceof String) {
            crit.setExactName((String)value);
        }
        try {
            List sets = SCMPlatform.getWorkspaceManager((ITeamRepository)p.getRepo()).findBaselineSets(crit, Integer.MAX_VALUE, JzProvider.getMonitor(feedback, 100));
            ArrayList<SrvcResource> results = new ArrayList<SrvcResource>(sets.size());
            for (IBaselineSetHandle handle : sets) {
                results.add(JzRepoBaseline.createSnapshot(p, handle));
            }
            return results;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
    }

    public JzRepoComponent getComponent(SrvcFeedback feedback) throws WvcmException {
        return (JzRepoComponent)this.provider().get((Location)this.location().getComponentLocation(), feedback);
    }
}

