/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.interop.InteropCore;
import com.ibm.rational.wvcm.ri.impl.VersionHistoryImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.Forest;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoChangeSet;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoControllableResource;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoRootVersion;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.connector.scm.client.JzRepoWorkspace;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.connector.scm.client.TreeNode;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.IChangeSetSearchCriteria;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.wvcm.ControllableResource;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.VersionHistory;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;

public class JzRepoVersionHistory
extends JzRepoResource {
    @Override
    public Class<?> get_proxyClass() {
        return VersionHistoryImpl.class;
    }

    public JzRepoVersionHistory(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    public JzRepoControllableResource createControllableResource(JzRepoWorkspace jzWS, SrvcFeedback feedback) throws WvcmException {
        List heritage;
        IVersionableHandle me;
        IConfiguration config;
        JzProvider provider;
        block4: {
            provider = this.provider();
            JzRepoComponent comp = this.getJzRepoComponent(feedback);
            config = jzWS.lookupConfiguration(comp.location(), feedback);
            if (config == null) {
                return null;
            }
            try {
                me = (IVersionableHandle)this.getItemHandle(feedback);
                IAncestorReport ancestorReport = (IAncestorReport)config.locateAncestors(Collections.singletonList(me), JzProvider.getMonitor(feedback, 100)).get(0);
                heritage = ancestorReport.getNameItemPairs();
                if (heritage.size() != 0) break block4;
                return null;
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException(e);
            }
        }
        JzLocation bcfLoc = jzWS.computeBcfLoc(config.component());
        JzLocation crLoc = JzRepoVersionHistory.createCompoundLocation(bcfLoc, heritage);
        JzRepoControllableResource result = JzRepoControllableResource.createFromVersionable(provider, crLoc, me);
        return result;
    }

    public static JzLocation createCompoundLocation(JzLocation parent, List<INameItemPair> heritage) throws WvcmException {
        JzLocation result = parent;
        for (INameItemPair nameItemPair : heritage) {
            String bindingName = nameItemPair.getName();
            if (bindingName == null) continue;
            result = result.child(bindingName);
        }
        return result;
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER)) {
            return this.getVersionHistoryResourceIdentifier(feedback);
        }
        if (propertyName.equals((Object)VersionHistory.ROOT_VERSION)) {
            return this.getRootVersion();
        }
        if (propertyName.equals((Object)Folder.CHILD_LIST)) {
            return this.getAllVersions(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    public String getVersionHistoryResourceIdentifier(SrvcFeedback feedback) throws WvcmException {
        JzLocation verLoc = JzRepoVersionHistory.getVersionHistoryLocation(this.getJzRepoComponent(feedback).location(), (IVersionableHandle)this.getItemHandle(feedback));
        return verLoc.string();
    }

    public JzRepoVersion getRootVersion() throws WvcmException {
        JzLocation verLoc = this.location().createRootVersionLocation();
        JzRepoRootVersion result = new JzRepoRootVersion(this.provider(), (Location)verLoc);
        return result;
    }

    @Override
    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)InteropCore.PN_CLONE)) {
            this.storeInteropCloneValue((String)value, feedback);
        } else {
            super.setPropertyFromClient(propertyName, value, initialize, feedback);
        }
    }

    @Override
    public void removePropertyFromClient(PropertyNameList.PropertyName<?> propertyName, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)InteropCore.PN_CLONE)) {
            this.removeInteropCloneValue(feedback);
        } else {
            super.removePropertyFromClient(propertyName, feedback);
        }
    }

    private static JzRepoComponent lookupJzRepoComponent(JzProvider provider, JzLocation myLoc, IVersionableHandle vH, SrvcFeedback feedback) throws WvcmException {
        JzLocation compLoc = myLoc.lookupContextLocation(JzLocation.Kind.Component);
        if (compLoc != null) {
            return JzRepoComponent.lookup(provider, compLoc, feedback);
        }
        return JzRepoVersionHistory.lookupJzRepoComponent(provider, vH, feedback);
    }

    public static JzRepoComponent lookupJzRepoComponent(JzProvider provider, IVersionableHandle vH, SrvcFeedback feedback) throws WvcmException {
        IComponentHandle cH = null;
        String componentCurrentStateDisplayName = (String)JzRepoVersionHistory.getCustomProperty(provider, (IItemHandle)vH, JzRepoVersionHistory.getVHInitialComponentPropertyName(), feedback);
        if (componentCurrentStateDisplayName == null) {
            JzLocation compLoc;
            JzRepoComponent comp;
            String defaultComponentRI = provider.getDefaultComponentRI();
            if (defaultComponentRI != null && (comp = JzRepoComponent.lookup(provider, compLoc = new JzLocation(defaultComponentRI), feedback)) != null) {
                cH = comp.getComponentItemHandle(feedback);
            }
        } else {
            JzLocation compLoc = new JzLocation(componentCurrentStateDisplayName);
            cH = (IComponentHandle)JzRepoVersionHistory.lookupItemHandle(provider, compLoc);
        }
        return cH == null ? null : JzRepoComponent.create(cH, provider);
    }

    public JzRepoComponent getJzRepoComponent(SrvcFeedback feedback) throws WvcmException {
        return JzRepoVersionHistory.getJzRepoComponent(this.provider(), this.location(), (IVersionableHandle)this.getItemHandle(feedback), feedback);
    }

    private static JzRepoComponent getJzRepoComponent(JzProvider provider, JzLocation location, IVersionableHandle vH, SrvcFeedback feedback) throws WvcmException {
        JzRepoComponent result = JzRepoVersionHistory.lookupJzRepoComponent(provider, location, vH, feedback);
        if (result == null) {
            throw new WvcmException(Messages.JzRepoVersionHistory_ERROR_COULDNT_LOOKUP_DEFAULT_COMPONENT, WvcmException.ReasonCode.FORBIDDEN);
        }
        return result;
    }

    public static JzLocation getPathnameLocation(JzProvider provider, JzLocation location) {
        return null;
    }

    public static JzRepoVersionHistory create(JzProvider provider, JzLocation compLoc, IVersionableHandle h) throws WvcmException {
        JzLocation resultLoc = compLoc.createVersionHistoryLocation(JzRepoVersionHistory.getCurrentStateDisplayName((IItemHandle)h));
        JzRepoVersionHistory result = new JzRepoVersionHistory(provider, (Location)resultLoc);
        result.setItemHandle((IItemHandle)h);
        return result;
    }

    public JzRepoVersion getVersion(IConfiguration config, SrvcFeedback feedback) throws WvcmException {
        JzRepoVersion result = this.lookupVersion(config, feedback);
        if (result == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoVersionHistory_ERROR_VERSION_NOT_FOUND_IN_CONFIG, (Object)JzRepoVersionHistory.getCurrentStateDisplayName(this.getItemHandle(feedback)), (Object[])new Object[0]), WvcmException.ReasonCode.NOT_FOUND);
        }
        return result;
    }

    public JzRepoVersion lookupVersion(IConfiguration config, SrvcFeedback feedback) throws WvcmException {
        JzRepoVersion result = null;
        JzProvider provider = this.provider();
        IVersionableHandle vH = (IVersionableHandle)this.getItemHandle(feedback);
        JzRepoComponent comp = JzRepoVersionHistory.lookupJzRepoComponent(provider, this.location(), vH, feedback);
        IVersionable itemState = this.lookupItemState(vH, config, feedback);
        if (comp != null && itemState != null) {
            JzLocation compLoc = comp.location();
            result = JzRepoVersion.createAppropriateProxy(provider, compLoc.createVersionLocation(JzRepoVersionHistory.getItemStateDisplayName((IVersionableHandle)itemState)), (IItemHandle)itemState, feedback);
        }
        return result;
    }

    public static JzRepoVersionHistory lookup(JzProvider provider, JzLocation loc, JzRepoComponent comp, SrvcFeedback feedback) throws WvcmException {
        JzRepoVersionHistory result = null;
        try {
            IVersionableHandle vh = (IVersionableHandle)JzRepoVersionHistory.getItemHandle(provider, loc);
            if (comp == null) {
                comp = JzRepoVersionHistory.lookupJzRepoComponent(provider, loc, vh, feedback);
            }
            if (comp != null) {
                result = JzRepoVersionHistory.create(provider, comp.location(), vh);
            }
        }
        catch (WvcmException e) {
            if (!WvcmException.ReasonCode.NOT_FOUND.equals((Object)e.getReasonCode())) {
                throw e;
            }
            provider.logIgnoredExceptionAsNotAlwaysVisible("JzRepoVersionHistory.lookup", (Exception)((Object)e));
            result = null;
        }
        return result;
    }

    public static List<JzRepoControllableResource> computeControllableResources(JzProvider provider, List<ControllableResource> queries, SrvcFeedback feedback) throws WvcmException {
        String lastWsLocString = null;
        JzRepoWorkspace jzWS = null;
        ArrayList<JzRepoVersionHistory> us = new ArrayList<JzRepoVersionHistory>(queries.size());
        HashMap<Object, JzRepoVersionHistory> vhloc2Jzvh = new HashMap<Object, JzRepoVersionHistory>(queries.size());
        for (ControllableResource query : queries) {
            VersionHistory vh = query.getVersionHistory();
            Location vhLoc = vh.getPathnameLocation();
            JzRepoVersionHistory jzRepoVersionHistory = (JzRepoVersionHistory)provider.get(vhLoc, feedback);
            us.add(jzRepoVersionHistory);
            vhloc2Jzvh.put(vhLoc, jzRepoVersionHistory);
            Workspace ws = query.getWorkspace();
            Location wsLoc = ws.getPathnameLocation();
            String wsLocString = wsLoc.string();
            if (lastWsLocString == null) {
                lastWsLocString = wsLocString;
                jzWS = (JzRepoWorkspace)provider.get(wsLoc, feedback);
                continue;
            }
            if (lastWsLocString.equals(wsLocString)) continue;
            throw new IllegalArgumentException(String.format("only one workspace location string is allowed for all queries, but we've seen %s and %s", lastWsLocString, wsLocString));
        }
        HashMap components2VHList = new HashMap(queries.size());
        HashMap<JzRepoVersionHistory, IVersionableHandle> jzvh2ivh = new HashMap<JzRepoVersionHistory, IVersionableHandle>(queries.size());
        for (JzRepoVersionHistory vH : us) {
            Object key = vH.getJzRepoComponent(feedback);
            if (!components2VHList.containsKey(key)) {
                components2VHList.put(key, new ArrayList());
            }
            IVersionableHandle versionableHandle = (IVersionableHandle)vH.getItemHandle(feedback);
            ((List)components2VHList.get(key)).add(versionableHandle);
            jzvh2ivh.put(vH, versionableHandle);
        }
        HashMap<IVersionableHandle, JzRepoControllableResource> ivh2cr = new HashMap<IVersionableHandle, JzRepoControllableResource>(queries.size());
        for (JzRepoComponent jzRepoComponent : components2VHList.keySet()) {
            IConfiguration config = jzWS.lookupConfiguration(jzRepoComponent.location(), feedback);
            if (config == null) continue;
            List versionableHandles = (List)components2VHList.get((Object)jzRepoComponent);
            ListIterator versionableHandlesIterator = versionableHandles.listIterator();
            try {
                List ancestorReports = config.locateAncestors(versionableHandles, JzProvider.getMonitor(feedback, 100));
                JzLocation bcfLoc = jzWS.computeBcfLoc(config.component());
                for (IAncestorReport ancestorReport : ancestorReports) {
                    List heritage = ancestorReport.getNameItemPairs();
                    IVersionableHandle versionableHandle = (IVersionableHandle)versionableHandlesIterator.next();
                    if (heritage.size() > 0) {
                        JzRepoControllableResource result = JzRepoControllableResource.createFromVersionable(provider, JzRepoVersionHistory.createCompoundLocation(bcfLoc, heritage), versionableHandle);
                        ivh2cr.put(versionableHandle, result);
                        continue;
                    }
                    ivh2cr.put(versionableHandle, null);
                }
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException(e);
            }
        }
        ArrayList<JzRepoControllableResource> results = new ArrayList<JzRepoControllableResource>(queries.size());
        for (ControllableResource query : queries) {
            VersionHistory vh = query.getVersionHistory();
            Location vhLoc = vh.getPathnameLocation();
            JzRepoVersionHistory jzvh = (JzRepoVersionHistory)((Object)vhloc2Jzvh.get(vhLoc));
            IVersionableHandle ivh = (IVersionableHandle)jzvh2ivh.get((Object)jzvh);
            JzRepoControllableResource jzcr = (JzRepoControllableResource)((Object)ivh2cr.get(ivh));
            results.add(jzcr);
        }
        return results;
    }

    @Override
    protected IItemReference createReferenceToItem(ILinkManager linkManager, SrvcFeedback feedback) throws WvcmException {
        JzRepoComponent comp = this.getJzRepoComponent(feedback);
        String compLocString = comp.location().string();
        return linkManager.referenceFactory().createReferenceToItem(this.getItemHandle(feedback), null, compLocString);
    }

    public static List<JzRepoVersionHistory> getClonesOfTargets(JzProvider provider, List<String> cloneStrings, SrvcFeedback feedback) throws WvcmException {
        int count = cloneStrings.size();
        if (count == 0) {
            return Collections.emptyList();
        }
        ArrayList<JzRepoVersionHistory> results = new ArrayList<JzRepoVersionHistory>(count);
        ILinkManager linkManager = JzRepoVersionHistory.getLinkManager(provider);
        HashMap<String, IURIReference> s2u = new HashMap<String, IURIReference>();
        for (String value : cloneStrings) {
            s2u.put(value, JzRepoVersionHistory.createReferenceToUri(linkManager, JzRepoVersionHistory.createUriFromValue(value)));
        }
        ArrayList<IURIReference> refs = new ArrayList<IURIReference>(s2u.values());
        Map<IURIReference, IItemReference> clonesByRef = JzRepoVersionHistory.getClonesOfTargets(provider, feedback, refs);
        for (String value : cloneStrings) {
            IURIReference uriRef = (IURIReference)s2u.get(value);
            IItemReference cloneItemRef = clonesByRef.get(uriRef);
            IVersionableHandle vH = cloneItemRef == null ? null : (IVersionableHandle)cloneItemRef.getReferencedItem();
            JzLocation compLoc = null;
            if (vH != null) {
                String compLocString = cloneItemRef.getExtraInfo();
                JzRepoComponent comp = null;
                if (compLocString != null) {
                    compLoc = new JzLocation(compLocString);
                    comp = JzRepoComponent.lookup(provider, compLoc, feedback);
                } else {
                    comp = JzRepoVersionHistory.lookupJzRepoComponent(provider, vH, feedback);
                    if (comp != null) {
                        compLoc = comp.location();
                    }
                }
                if (comp == null) {
                    throw new IllegalStateException(NLS.bind((String)Messages.JzRepoVersionHistory_ERROR_VH_HAS_NO_COMPONENT, (Object)JzRepoVersionHistory.getCurrentStateDisplayName((IItemHandle)vH), (Object[])new Object[0]));
                }
            }
            JzRepoVersionHistory result = vH == null ? null : JzRepoVersionHistory.create(provider, compLoc, vH);
            results.add(result);
        }
        return results;
    }

    private Forest<JzRepoVersion> getVersionForest(SrvcFeedback f) throws WvcmException {
        JzProvider p = this.provider();
        IChangeSetSearchCriteria criteria = IChangeSetSearchCriteria.FACTORY.newInstance();
        IVersionableHandle myHandle = (IVersionableHandle)this.getItemHandle(f);
        criteria.setItem(myHandle);
        criteria.setSearchIntermediatesForItem(false);
        ITeamRepository repo = p.getRepo();
        try {
            int resultCount;
            IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            ArrayList allItems = new ArrayList();
            do {
                List queryResults = manager.findChangeSets(criteria, 512, JzProvider.getMonitor(f, 10));
                List items = repo.itemManager().fetchCompleteItems(queryResults, 0, JzProvider.getMonitor(f, 20));
                allItems.addAll(items);
                resultCount = queryResults.size();
                IChangeSet oldestItemRetrieved = (IChangeSet)items.get(resultCount - 1);
                criteria.setModifiedBefore(new Timestamp(oldestItemRetrieved.getLastChangeDate().getTime()));
            } while (resultCount >= 512);
            Forest<JzRepoVersion> forest = new Forest<JzRepoVersion>(allItems.size());
            for (IChangeSet cs : allItems) {
                List changes = cs.changes();
                for (IChange change : changes) {
                    IVersionableHandle version;
                    IVersionableHandle changedItem = change.item();
                    if (!ItemUtil.equivItemRef((IItemHandle)myHandle, (IItemHandle)changedItem) || (version = change.afterState()) == null) continue;
                    this.recordVersion(forest, cs, change, f);
                }
            }
            return forest;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
    }

    void recordVersion(Forest<JzRepoVersion> forest, IChangeSet cs, IChange change, SrvcFeedback f) throws WvcmException {
        IVersionableHandle version = change.afterState();
        IVersionableHandle predVersion = change.beforeState();
        JzRepoVersion versionProxy = this.getProxy(version, forest, f);
        JzRepoChangeSet csProxy = JzRepoChangeSet.create(this.provider(), (IChangeSetHandle)cs, f);
        versionProxy.setActivityValue(csProxy);
        Iterator mergesIter = change.mergeStates().iterator();
        if (predVersion == null || !version.getStateId().equals((Object)predVersion.getStateId())) {
            JzRepoVersion predVersionProxy = this.getProxy(predVersion, forest, f);
            forest.addLinkage(predVersionProxy, versionProxy, cs.getComment(), false);
            if (predVersion == null) {
                versionProxy.setPredecessorListValue(new ArrayList<JzRepoVersion>());
            } else {
                versionProxy.addPredecessorValue(predVersionProxy, false);
            }
        }
        while (mergesIter.hasNext()) {
            IVersionableHandle pred = (IVersionableHandle)mergesIter.next();
            JzRepoVersion predVersionProxy = this.getProxy(pred, forest, f);
            forest.addLinkage(predVersionProxy, versionProxy, cs.getComment(), true);
            if (pred == null) {
                versionProxy.setPredecessorListValue(new ArrayList<JzRepoVersion>());
                continue;
            }
            versionProxy.addPredecessorValue(predVersionProxy, true);
        }
    }

    public JzRepoVersion getProxy(IVersionableHandle versionHandle, Forest<JzRepoVersion> forest, SrvcFeedback f) throws WvcmException {
        if (versionHandle == null) {
            return null;
        }
        JzRepoComponent comp = this.getJzRepoComponent(f);
        JzRepoVersion result = this.createAppropriateVersionProxy(comp.location(), versionHandle, f);
        TreeNode<JzRepoVersion> node = forest.get(result);
        if (node != null) {
            result = (JzRepoVersion)((Object)node.item);
        }
        return result;
    }

    protected JzRepoVersion createAppropriateVersionProxy(JzLocation compLoc, IVersionableHandle version, SrvcFeedback f) throws WvcmException {
        JzLocation versionLoc = compLoc.createVersionLocation(JzRepoVersionHistory.getItemStateDisplayName(version));
        JzRepoVersion result = JzRepoVersion.createAppropriateProxy(this.provider(), versionLoc, (IItemHandle)version, f);
        return result;
    }

    private List<JzRepoVersion> getAllVersions(SrvcFeedback f) throws WvcmException {
        Forest<JzRepoVersion> forest = this.getVersionForest(f);
        List<JzRepoVersion> results = forest.items();
        return results;
    }
}

