/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.xml;

import com.urbancode.air.plugin_command.properties.PluginCommandProperty;
import com.urbancode.air.plugin_command.properties.SelectValue;
import com.urbancode.air.plugin_command.xml.PropertyHolder;
import com.urbancode.commons.xml.DOMUtils;
import com.urbancode.commons.xml.marshall.MarshallingContext;
import com.urbancode.commons.xml.marshall.MarshallingEngine;
import com.urbancode.commons.xml.marshall.MarshallingRuntimeException;
import com.urbancode.commons.xml.marshall.XmlMarshallerBase;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class PropertyXmlMarshaller
extends XmlMarshallerBase {
    public static final String PROPERTY_ELEMENT = "property";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String REQUIRED_ATTRIBUTE = "required";
    public static final String LABEL_ATTRIBUTE = "label";
    public static final String VALUE_ELEMENT = "value";
    private static final Logger logger = Logger.getLogger(PropertyXmlMarshaller.class);

    public PropertyXmlMarshaller() {
        super(PROPERTY_ELEMENT);
    }

    public void unmarshall(Element element, MarshallingContext context) throws MarshallingRuntimeException {
        logger.trace((Object)("Unmarshalling '" + element.getNodeName() + "'."));
        PropertyHolder propertyHolder = (PropertyHolder)context.get();
        if (propertyHolder == null) {
            throw new NullPointerException("No PropertyHolder existed on MarshallingContext.");
        }
        String name = DOMUtils.getAttribute((Element)element, (String)NAME_ATTRIBUTE);
        boolean required = Boolean.valueOf(DOMUtils.getAttribute((Element)element, (String)REQUIRED_ATTRIBUTE));
        LinkedList<SelectValue> allowedValues = new LinkedList<SelectValue>();
        List valueElements = DOMUtils.getChildElementList((Element)element, (String)VALUE_ELEMENT);
        if (valueElements != null) {
            for (Element valueElement : valueElements) {
                String valueLabel = DOMUtils.getAttribute((Element)valueElement, (String)LABEL_ATTRIBUTE);
                String valueValue = DOMUtils.getChildText((Element)valueElement);
                allowedValues.add(new SelectValue(valueLabel, valueValue));
            }
        }
        PluginCommandProperty property = new PluginCommandProperty(name, required, allowedValues);
        context.push((Object)property);
        MarshallingEngine engine = context.getEngine();
        for (Element childElement : DOMUtils.getChildElementList((Element)element)) {
            XmlMarshallerBase unmarshaler = engine.getMarshaller(childElement);
            if (unmarshaler == null) continue;
            unmarshaler.unmarshall(childElement, context);
        }
        context.pop();
        propertyHolder.addPluginProp(property);
    }
}

