/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common.treedifferencer;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.common.treedifferencer.ITree;
import com.ibm.team.foundation.common.treedifferencer.XMLTree;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class XMLTreeParser {
    private static final Set<String> VOID_ELEMENTS = new HashSet<String>(Arrays.asList("area", "base", "br", "col", "embed", "hr", "img", "input", "keygen", "link", "menuitem", "meta", "param", "source", "track", "wbr"));

    public XMLTree parse(XMLString text) {
        XMLTree result = new XMLTree(null);
        try {
            this.process(result, new StringReader(text.getXMLText()), new StringBuilder());
            result.setContent(text);
        }
        catch (IOException iOException) {}
        return result;
    }

    private void process(XMLTree tree, StringReader reader, StringBuilder contentBuilder) throws IOException {
        int c;
        reader.mark(1);
        while ((c = reader.read()) != -1) {
            if (c == 60) {
                c = reader.read();
                if (c == 47) {
                    contentBuilder.append('<');
                    contentBuilder.append('/');
                    XMLTree node = new XMLTree(null);
                    this.tagName(reader, node, contentBuilder);
                    this.committedRead(reader, contentBuilder);
                    if (node.getTag().equals(tree.getTag())) {
                        break;
                    }
                } else {
                    reader.reset();
                    tree.getChildren().add(this.processTag(reader, tree, contentBuilder));
                }
            } else {
                reader.reset();
                tree.getChildren().add(this.processText(reader, tree, contentBuilder));
            }
            reader.mark(1);
        }
    }

    private int committedRead(StringReader reader, StringBuilder contentBuilder) throws IOException {
        int c = reader.read();
        contentBuilder.append((char)c);
        return c;
    }

    private XMLTree processTag(StringReader reader, XMLTree parent, StringBuilder contentBuilder) throws IOException {
        XMLTree node = new XMLTree(parent);
        int mark = contentBuilder.length();
        int c = this.committedRead(reader, contentBuilder);
        assert (c != 60);
        this.tagName(reader, node, contentBuilder);
        this.attributes(reader, node, contentBuilder);
        c = this.committedRead(reader, contentBuilder);
        assert (c == 62);
        if (!VOID_ELEMENTS.contains(node.getTag().toLowerCase()) && !node.isSelfClosing()) {
            this.process(node, reader, contentBuilder);
        }
        node.setContent(XMLString.createFromXMLText(contentBuilder.substring(mark)));
        return node;
    }

    private void tagName(StringReader reader, XMLTree tree, StringBuilder contentBuilder) throws IOException {
        StringBuilder builder = new StringBuilder();
        reader.mark(1);
        int c = reader.read();
        while (c != 62 && !Character.isWhitespace((char)c) && c != -1) {
            builder.append((char)c);
            contentBuilder.append((char)c);
            reader.mark(1);
            c = reader.read();
        }
        reader.reset();
        this.markSelfClosing(tree, builder);
        tree.setTag(builder.toString().trim());
    }

    private void attributes(StringReader reader, XMLTree tree, StringBuilder contentBuilder) throws IOException {
        reader.mark(1);
        StringBuilder builder = new StringBuilder();
        int c = reader.read();
        while (c != 62 && c != -1) {
            builder.append((char)c);
            contentBuilder.append((char)c);
            reader.mark(1);
            c = reader.read();
        }
        reader.reset();
        this.markSelfClosing(tree, builder);
        tree.setAttributes(builder.toString().trim());
    }

    private void markSelfClosing(XMLTree tree, StringBuilder builder) {
        if (builder.length() > 0 && builder.charAt(builder.length() - 1) == '/') {
            builder.deleteCharAt(builder.length() - 1);
            tree.setSelfClosing(true);
        }
    }

    private ITree processText(StringReader reader, XMLTree parent, StringBuilder contentBuilder) throws IOException {
        reader.mark(1);
        StringBuilder builder = new StringBuilder();
        int c = reader.read();
        while (c != -1) {
            if (c == 60) {
                reader.reset();
                break;
            }
            builder.append((char)c);
            contentBuilder.append((char)c);
            reader.mark(1);
            c = reader.read();
        }
        XMLTree result = new XMLTree(parent);
        return result.setContent(XMLString.createFromXMLText(builder.toString()));
    }
}

