/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.repository.rcp.dbhm;

import com.ibm.team.internal.repository.rcp.dbhm.BTreeHeap;
import com.ibm.team.internal.repository.rcp.dbhm.DBHMException;
import com.ibm.team.internal.repository.rcp.dbhm.HeapADT;
import com.ibm.team.internal.repository.rcp.dbhm.TemporaryBTreeHeap;
import com.ibm.team.internal.repository.rcp.streams.UnsynchronizedBufferedInputStream;
import com.ibm.team.internal.repository.rcp.streams.UnsynchronizedBufferedOutputStream;
import com.ibm.team.internal.repository.rcp.streams.UnsynchronizedByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class DiskBackedHashMap<K, V>
extends AbstractMap<K, V> {
    protected static final long MAX_CAPACITY = 0xFFFFFFFFL;
    protected static final int DEFAULT_FORMAT_VERSION = 1;
    protected static final long TABLE_CELL_SIZE = 30L;
    protected static final long NEXT_ENTRY_OFFSET = 21L;
    protected static final long ENTRY_VALUE_OFFSET = 12L;
    protected static final int FORMAT_VERSION = 1;
    protected static final int ENTRY_KEY_HEAPADT_FLAG = 1;
    protected static final int ENTRY_VALUE_HEAPADT_FLAG = 2;
    protected static final int KEY_FLAG = 1;
    protected static final int HEAPADT_FLAG = 2;
    protected EntrySet entrySet;
    protected Values values;
    protected KeySet keySet;
    protected long tablePtr;
    protected long size;
    protected long capacity;
    protected long nextResize;
    protected double loadFactor;
    protected long numHeapADTs;
    protected volatile int vTime;
    protected BTreeHeap heap;

    public DiskBackedHashMap(long initialCapacity, double loadFactor) {
        try {
            this.loadFactor = loadFactor;
            this.capacity = initialCapacity;
            this.init();
        }
        catch (IOException e) {
            throw new DBHMException(e);
        }
    }

    public DiskBackedHashMap(long initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public DiskBackedHashMap() {
        this(17L, 0.75);
    }

    public DiskBackedHashMap(Map<? extends K, ? extends V> t) {
        this(Math.max(t.size() * 2 + 1, 17));
        this.putAll(t);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public int size() {
        return (int)this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0L;
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            return this.getEntry((Object)key).entry != null;
        }
        catch (IOException e) {
            throw new DBHMException(e);
        }
    }

    @Override
    public V get(Object key) {
        Entry entry;
        block4: {
            entry = this.getEntry((Object)key).entry;
            if (entry != null) break block4;
            return null;
        }
        try {
            return entry.getValue();
        }
        catch (IOException e) {
            throw new DBHMException(e);
        }
        catch (IllegalArgumentException e) {
            throw new DBHMException(e);
        }
    }

    @Override
    public V put(K key, V value) {
        try {
            this.resizeIfNeeded(this.size + 1L);
            ++this.vTime;
            EntryResult current = this.getEntry(key);
            Entry currentEntry = current.entry;
            if (currentEntry != null) {
                return currentEntry.setValue(value);
            }
            this.putNew(key, value, current.predecessor);
        }
        catch (IOException e) {
            throw new DBHMException(e);
        }
        return null;
    }

    protected Entry putNew(K key, V value, Entry predecessor) throws IOException {
        long keyOffset = this.writeObject(key, 1);
        if (key instanceof HeapADT) {
            ((HeapADT)key).add();
            ++this.numHeapADTs;
        }
        long valueOffset = this.writeObject(value, 0);
        if (value instanceof HeapADT) {
            ((HeapADT)value).add();
            ++this.numHeapADTs;
        }
        long hashCode = this.hashCode(key);
        boolean isKeyHeapADT = key instanceof HeapADT;
        boolean isValueHeapADT = value instanceof HeapADT;
        Entry newEntry = predecessor == null ? this.createTableEntry(hashCode, keyOffset, isKeyHeapADT, valueOffset, isValueHeapADT) : this.createLinkedEntry(hashCode, keyOffset, isKeyHeapADT, valueOffset, isValueHeapADT, predecessor);
        ++this.size;
        return newEntry;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        try {
            this.resizeIfNeeded(this.size + (long)t.size());
            super.putAll(t);
        }
        catch (IOException e) {
            throw new DBHMException(e);
        }
    }

    @Override
    public V remove(Object key) {
        Entry entry;
        block3: {
            try {
                entry = this.getEntry((Object)key).entry;
                if (entry != null) break block3;
            }
            catch (IOException e) {
                throw new DBHMException(e);
            }
            return null;
        }
        Object oldValue = entry.getValue();
        this.removeEntry(entry);
        ++this.vTime;
        return oldValue;
    }

    @Override
    public void clear() {
        try {
            if (this.size != 0L) {
                ++this.vTime;
                if (this.numHeapADTs == 0L) {
                    this.init();
                } else {
                    Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
                    while (i.hasNext()) {
                        i.next();
                        i.remove();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new DBHMException(e);
        }
    }

    protected void initHeap() throws IOException {
        if (this.heap == null) {
            this.heap = this.newBTreeHeap();
        } else {
            this.heap.clear();
        }
    }

    protected BTreeHeap newBTreeHeap() throws IOException {
        return new TemporaryBTreeHeap();
    }

    protected void initTablePtr() throws IOException {
        this.size = 0L;
        this.numHeapADTs = 0L;
        this.tablePtr = this.heap.allocate(30L * this.capacity);
        this.initTable(this.tablePtr, this.capacity);
    }

    protected void init() throws IOException {
        this.nextResize = (long)((double)this.capacity * this.loadFactor);
        this.initHeap();
        this.initTablePtr();
    }

    protected void removeEntry(Entry entry) throws IOException {
        if (entry.keyIsHeapADT) {
            ((HeapADT)entry.getKey()).delete();
            --this.numHeapADTs;
        }
        if (entry.valueIsHeapADT) {
            ((HeapADT)entry.getValue()).delete();
            --this.numHeapADTs;
        }
        if (entry.prevEntryOffset == -1L) {
            this.removeTableEntry(entry);
        } else {
            this.removeLinkedEntry(entry);
        }
    }

    protected Entry createTableEntry(long hashCode, long keyOffset, boolean isKeyHeapADT, long valueOffset, boolean isValueHeapADT) throws IOException {
        long offset = this.tablePtr + hashCode % this.capacity * 30L;
        return this.createNewEntry(offset + 1L, (int)hashCode, keyOffset, isKeyHeapADT, valueOffset, isValueHeapADT, -1L, -1L);
    }

    protected Entry createLinkedEntry(long hashCode, long keyOffset, boolean isKeyHeapADT, long valueOffset, boolean isValueHeapADT, Entry predecessor) throws IOException {
        long newEntryOffset = this.heap.allocate(29L);
        predecessor.setNextEntryOffset(newEntryOffset);
        return this.createNewEntry(newEntryOffset, (int)hashCode, keyOffset, isKeyHeapADT, valueOffset, isValueHeapADT, -1L, predecessor.offset);
    }

    protected Entry addEntryToTable(long tablePtr, long capacity, long hashCode, long keyOffset, boolean isKeyHeapADT, long valueOffset, boolean isValueHeapADT) throws IOException {
        Entry newEntry;
        long offset = tablePtr + hashCode % capacity * 30L;
        Entry currentEntry = this.getTableEntry(offset, tablePtr);
        if (currentEntry == null) {
            newEntry = this.createNewEntry(offset + 1L, (int)hashCode, keyOffset, isKeyHeapADT, valueOffset, isValueHeapADT, -1L, -1L);
        } else {
            long entryOffset = this.heap.allocate(29L);
            long nextEntryOffset = currentEntry.nextEntryOffset;
            currentEntry.setNextEntryOffset(entryOffset);
            Entry nextEntry = this.getCachedEntry(nextEntryOffset);
            if (nextEntry != null) {
                nextEntry.setPrevEntryOffset(entryOffset);
            }
            newEntry = this.createNewEntry(entryOffset, (int)hashCode, keyOffset, isKeyHeapADT, valueOffset, isValueHeapADT, nextEntryOffset, currentEntry.offset);
        }
        return newEntry;
    }

    protected void writeNextEntryOffset(long entryOffset, long nextEntryOffset) throws IOException {
        DataOutputStream dataOut = new DataOutputStream(this.heap.getOutputStream(entryOffset + 21L));
        dataOut.writeLong(nextEntryOffset);
        dataOut.flush();
    }

    protected void writeEntry(Entry entry) throws IOException {
        long writeOffset = entry.offset;
        if (entry.prevEntryOffset == -1L) {
            --writeOffset;
        }
        DataOutputStream dataOut = new DataOutputStream(new UnsynchronizedBufferedOutputStream(this.heap.getOutputStream(writeOffset)));
        if (entry.prevEntryOffset == -1L) {
            dataOut.writeBoolean(false);
        }
        dataOut.writeInt(entry.hashCode);
        dataOut.writeLong(entry.keyOffset);
        dataOut.writeLong(entry.valueOffset);
        int flags = 0;
        if (entry.keyIsHeapADT) {
            flags = 1;
        }
        if (entry.valueIsHeapADT) {
            flags |= 2;
        }
        dataOut.writeByte(flags);
        dataOut.writeLong(entry.nextEntryOffset);
        dataOut.flush();
    }

    protected Object readObject(long offset, int flags) throws IOException, ClassNotFoundException {
        return this.readObject(new UnsynchronizedBufferedInputStream(this.heap.getInputStream(offset)), flags);
    }

    protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
        Object o = new ObjectInputStream(in).readObject();
        if ((flags & 2) != 0) {
            o = ((HeapADT)o).init(this.heap);
        }
        return o;
    }

    protected long writeObject(Object o, int flags) throws IOException {
        UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(out);
        objOut.writeObject(o);
        objOut.flush();
        long offset = this.heap.allocate(out.size());
        out.writeTo(this.heap.getOutputStream(offset));
        return offset;
    }

    protected void freeObject(long offset, int flags) throws IOException {
        this.heap.free(offset);
    }

    protected void resizeIfNeeded(long expectedNewSize) throws IOException {
        if (expectedNewSize < this.nextResize) {
            return;
        }
        long newCapacity = this.capacity;
        while ((long)((double)newCapacity * this.loadFactor) <= expectedNewSize) {
            newCapacity = newCapacity * 2L + 1L;
        }
        if (newCapacity >= 0xFFFFFFFFL) {
            newCapacity = 0xFFFFFFFFL;
            this.nextResize = Long.MAX_VALUE;
        } else {
            this.nextResize = (long)((double)newCapacity * this.loadFactor);
        }
        long newTable = this.heap.allocate(30L * newCapacity);
        this.initTable(newTable, newCapacity);
        Entry prevEntry = null;
        for (Entry entry : this.entrySet()) {
            if (prevEntry != null) {
                boolean isTableEntry = prevEntry.prevEntryOffset == -1L;
                long origOffset = prevEntry.offset;
                this.addEntryToTable(newTable, newCapacity, (long)prevEntry.hashCode & 0xFFFFFFFFL, prevEntry.keyOffset, prevEntry.keyIsHeapADT, prevEntry.valueOffset, prevEntry.valueIsHeapADT);
                if (!isTableEntry) {
                    this.heap.free(origOffset);
                }
            }
            prevEntry = entry;
        }
        if (prevEntry != null) {
            boolean isTableEntry = prevEntry.prevEntryOffset == -1L;
            long l = prevEntry.offset;
            this.addEntryToTable(newTable, newCapacity, (long)prevEntry.hashCode & 0xFFFFFFFFL, prevEntry.keyOffset, prevEntry.keyIsHeapADT, prevEntry.valueOffset, prevEntry.valueIsHeapADT);
            if (!isTableEntry) {
                this.heap.free(l);
            }
        }
        this.heap.free(this.tablePtr);
        this.tablePtr = newTable;
        this.capacity = newCapacity;
    }

    protected void initTable(long offset, long capacity) throws IOException {
        DataOutputStream dataOut = new DataOutputStream(new UnsynchronizedBufferedOutputStream(this.heap.getOutputStream(offset)));
        long i = 0L;
        while (i < capacity) {
            dataOut.writeBoolean(true);
            dataOut.writeInt(0);
            dataOut.writeLong(-1L);
            dataOut.writeLong(-1L);
            dataOut.writeByte(0);
            dataOut.writeLong(-1L);
            ++i;
        }
        dataOut.flush();
    }

    protected EntryResult getEntry(Object key) throws IOException {
        long longHashCode = this.hashCode(key);
        long offset = this.tablePtr + longHashCode % this.capacity * 30L;
        int intHashCode = (int)longHashCode;
        boolean isHeapADT = key instanceof HeapADT;
        Entry predecessor = null;
        Entry entry = this.getTableEntry(offset, this.tablePtr);
        while (entry != null) {
            if (intHashCode == entry.hashCode && isHeapADT == entry.keyIsHeapADT && this.equal(key, entry.getKey())) {
                return new EntryResult(predecessor, entry);
            }
            predecessor = entry;
            entry = this.getEntry(entry.nextEntryOffset, entry.offset);
        }
        return new EntryResult(predecessor, null);
    }

    protected Entry getCachedEntry(long offset) {
        return null;
    }

    protected Entry getTableEntry(long offset, long tableOffset) throws IOException {
        DataInputStream dataIn = new DataInputStream(new UnsynchronizedBufferedInputStream(this.heap.getInputStream(offset)));
        if (dataIn.readBoolean()) {
            return null;
        }
        int hashCode = dataIn.readInt();
        long keyOffset = dataIn.readLong();
        long valueOffset = dataIn.readLong();
        byte flags = dataIn.readByte();
        boolean isKeyHeapADT = (flags & 1) != 0;
        boolean isValueHeapADT = (flags & 2) != 0;
        long nextEntryOffset = dataIn.readLong();
        return this.createEntry(offset + 1L, hashCode, keyOffset, isKeyHeapADT, valueOffset, isValueHeapADT, nextEntryOffset, -1L);
    }

    protected Entry getEntry(long offset, long prevEntryOffset) throws IOException {
        if (offset == -1L) {
            return null;
        }
        DataInputStream dataIn = new DataInputStream(new UnsynchronizedBufferedInputStream(this.heap.getInputStream(offset)));
        int hashCode = dataIn.readInt();
        long keyOffset = dataIn.readLong();
        long valueOffset = dataIn.readLong();
        byte flags = dataIn.readByte();
        boolean isKeyHeapADT = (flags & 1) != 0;
        boolean isValueHeapADT = (flags & 2) != 0;
        long nextEntryOffset = dataIn.readLong();
        return this.createEntry(offset, hashCode, keyOffset, isKeyHeapADT, valueOffset, isValueHeapADT, nextEntryOffset, prevEntryOffset);
    }

    protected long hashCode(Object o) {
        if (o == null) {
            return 3314609711L;
        }
        return (long)o.hashCode() & 0xFFFFFFFFL;
    }

    protected boolean equal(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    protected void removeTableEntry(Entry entry) throws IOException {
        if (entry.nextEntryOffset == -1L) {
            DataOutputStream dataOut = new DataOutputStream(this.heap.getOutputStream(entry.offset - 1L));
            dataOut.writeBoolean(true);
            dataOut.flush();
        } else {
            Entry nextNextEntry;
            Entry nextEntry = this.getEntry(entry.nextEntryOffset, entry.offset);
            nextEntry.setPrevEntryOffset(entry.prevEntryOffset);
            nextEntry.setOffset(entry.offset);
            if (nextEntry.nextEntryOffset != -1L && (nextNextEntry = this.getCachedEntry(nextEntry.nextEntryOffset)) != null) {
                nextNextEntry.setPrevEntryOffset(entry.offset);
            }
            this.heap.free(entry.nextEntryOffset);
        }
        this.freeObject(entry.keyOffset, 1);
        this.freeObject(entry.valueOffset, 0);
        --this.size;
    }

    protected void removeLinkedEntry(Entry entry) throws IOException {
        Entry cached = this.getCachedEntry(entry.prevEntryOffset);
        if (cached != null) {
            cached.setNextEntryOffset(entry.nextEntryOffset);
        } else {
            this.writeNextEntryOffset(entry.prevEntryOffset, entry.nextEntryOffset);
        }
        if (entry.nextEntryOffset != -1L && (cached = this.getCachedEntry(entry.nextEntryOffset)) != null) {
            cached.setPrevEntryOffset(entry.prevEntryOffset);
        }
        this.heap.free(entry.offset);
        this.freeObject(entry.keyOffset, 1);
        this.freeObject(entry.valueOffset, 0);
        --this.size;
    }

    protected Entry createEntry(long offset, int hashCode, long keyOffset, boolean isKeyHeapADT, long valueOffset, boolean isValueHeapADT, long nextEntryOffset, long prevEntryOffset) {
        return new Entry(offset, hashCode, keyOffset, isKeyHeapADT, valueOffset, isValueHeapADT, nextEntryOffset, prevEntryOffset);
    }

    protected Entry createNewEntry(long offset, int hashCode, long keyOffset, boolean isKeyHeapADT, long valueOffset, boolean isValueHeapADT, long nextEntryOffset, long prevEntryOffset) throws IOException {
        Entry entry = this.createEntry(offset, hashCode, keyOffset, isKeyHeapADT, valueOffset, isValueHeapADT, nextEntryOffset, prevEntryOffset);
        this.writeEntry(entry);
        return entry;
    }

    protected EntryIterator newEntryIterator() {
        return new EntryIterator();
    }

    protected class Entry
    implements Map.Entry<K, V> {
        protected long offset;
        protected int hashCode;
        protected long keyOffset;
        protected long valueOffset;
        protected long nextEntryOffset;
        protected long prevEntryOffset;
        protected boolean keyIsHeapADT;
        protected boolean valueIsHeapADT;

        public Entry(long offset, int hashCode, long keyOffset, boolean keyIsHeapADT, long valueOffset, boolean valueIsHeapADT, long nextEntryOffset, long prevEntryOffset) {
            if (offset == nextEntryOffset && offset != -1L) {
                throw new IllegalArgumentException();
            }
            this.offset = offset;
            this.hashCode = hashCode;
            this.keyOffset = keyOffset;
            this.keyIsHeapADT = keyIsHeapADT;
            this.valueOffset = valueOffset;
            this.valueIsHeapADT = valueIsHeapADT;
            this.nextEntryOffset = nextEntryOffset;
            this.prevEntryOffset = prevEntryOffset;
        }

        @Override
        public V getValue() {
            try {
                Object o = DiskBackedHashMap.this.readObject(this.valueOffset, this.valueIsHeapADT ? 2 : 0);
                return o;
            }
            catch (IOException e) {
                throw new DBHMException(e);
            }
            catch (ClassNotFoundException e) {
                throw new DBHMException(e);
            }
        }

        @Override
        public K getKey() {
            try {
                Object o = DiskBackedHashMap.this.readObject(this.keyOffset, this.keyIsHeapADT ? 3 : 1);
                return o;
            }
            catch (IOException e) {
                throw new DBHMException(e);
            }
            catch (ClassNotFoundException e) {
                throw new DBHMException(e);
            }
        }

        @Override
        public V setValue(V value) {
            try {
                return this.setValue(value, true);
            }
            catch (IOException e) {
                throw new DBHMException(e);
            }
        }

        protected V setValue(V value, boolean notifyADT) throws IOException {
            Object previousValue = this.getValue();
            if (notifyADT && this.valueIsHeapADT && previousValue != value) {
                ((HeapADT)previousValue).delete();
                --DiskBackedHashMap.this.numHeapADTs;
            }
            DiskBackedHashMap.this.freeObject(this.valueOffset, 0);
            this.valueOffset = DiskBackedHashMap.this.writeObject(value, 0);
            OutputStream out = DiskBackedHashMap.this.heap.getOutputStream(this.offset + 12L);
            UnsynchronizedByteArrayOutputStream bOut = new UnsynchronizedByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(bOut);
            dataOut.writeLong(this.valueOffset);
            int flags = 0;
            if (this.keyIsHeapADT) {
                flags = 1;
            }
            if (value instanceof HeapADT) {
                this.valueIsHeapADT = true;
                if (notifyADT && previousValue != value) {
                    ((HeapADT)value).add();
                    ++DiskBackedHashMap.this.numHeapADTs;
                }
                flags = (byte)(flags | 2);
            } else {
                this.valueIsHeapADT = false;
            }
            dataOut.writeByte(flags);
            dataOut.flush();
            bOut.writeTo(out);
            return previousValue;
        }

        @Override
        public boolean equals(Object obj) {
            Map.Entry other;
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            if (obj instanceof Entry && ((Entry)(other = (Entry)obj)).sameMap(DiskBackedHashMap.this)) {
                return ((Entry)other).keyOffset == this.keyOffset;
            }
            other = (Map.Entry)obj;
            return DiskBackedHashMap.this.equal(this.getKey(), other.getKey()) && DiskBackedHashMap.this.equal(this.getValue(), other.getValue());
        }

        protected boolean sameMap(DiskBackedHashMap<?, ?> other) {
            return DiskBackedHashMap.this == other;
        }

        protected void setNextEntryOffset(long nextEntryOffset) throws IOException {
            this.nextEntryOffset = nextEntryOffset;
            DiskBackedHashMap.this.writeNextEntryOffset(this.offset, nextEntryOffset);
        }

        protected void setPrevEntryOffset(long prevEntryOffset) {
            this.prevEntryOffset = prevEntryOffset;
        }

        protected void setOffset(long offset) throws IOException {
            this.offset = offset;
            DiskBackedHashMap.this.writeEntry(this);
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }

    protected class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        protected long entriesSeen = 0L;
        protected long tableEntry = -1L;
        protected Entry currentEntry;
        private boolean removed = true;
        DataInputStream dataIn;
        private int expectedVTime;

        public EntryIterator() {
            this.dataIn = this.getTableInputStream(DiskBackedHashMap.this.tablePtr);
            this.expectedVTime = DiskBackedHashMap.this.vTime;
        }

        protected DataInputStream getTableInputStream(long offset) {
            return new DataInputStream(new UnsynchronizedBufferedInputStream(DiskBackedHashMap.this.heap.getInputStream(offset)));
        }

        @Override
        public boolean hasNext() {
            return this.entriesSeen < DiskBackedHashMap.this.size;
        }

        @Override
        public Entry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (DiskBackedHashMap.this.vTime != this.expectedVTime) {
                throw new ConcurrentModificationException();
            }
            try {
                if (this.currentEntry == null || this.currentEntry.nextEntryOffset == -1L) {
                    this.findNextTableEntry();
                } else {
                    this.findNextEntry();
                }
            }
            catch (IOException e) {
                throw new DBHMException(e);
            }
            this.removed = false;
            return this.currentEntry;
        }

        protected void findNextTableEntry() throws IOException {
            ++this.tableEntry;
            if (this.tableEntry >= DiskBackedHashMap.this.capacity) {
                throw new IllegalStateException();
            }
            long offset = DiskBackedHashMap.this.tablePtr + this.tableEntry * 30L;
            Entry entry = null;
            while (this.tableEntry < DiskBackedHashMap.this.capacity) {
                entry = DiskBackedHashMap.this.getCachedEntry(offset + 1L);
                if (entry != null || !this.dataIn.readBoolean()) break;
                offset += 30L;
                if ((long)this.dataIn.skipBytes(29) != 29L) {
                    this.dataIn = this.getTableInputStream(offset);
                }
                ++this.tableEntry;
            }
            if (this.tableEntry >= DiskBackedHashMap.this.capacity) {
                throw new IllegalStateException();
            }
            if (entry == null) {
                int hashCode = this.dataIn.readInt();
                long keyOffset = this.dataIn.readLong();
                long valueOffset = this.dataIn.readLong();
                byte flags = this.dataIn.readByte();
                boolean isKeyHeapADT = (flags & 1) != 0;
                boolean isValueHeapADT = (flags & 2) != 0;
                long nextEntryOffset = this.dataIn.readLong();
                entry = DiskBackedHashMap.this.createEntry(offset + 1L, hashCode, keyOffset, isKeyHeapADT, valueOffset, isValueHeapADT, nextEntryOffset, -1L);
            } else if ((long)this.dataIn.skipBytes(30) != 30L) {
                this.dataIn = this.getTableInputStream(offset + 30L);
            }
            this.currentEntry = entry;
            ++this.entriesSeen;
        }

        protected void findNextEntry() throws IOException {
            this.currentEntry = DiskBackedHashMap.this.getEntry(this.currentEntry.nextEntryOffset, this.currentEntry.offset);
            ++this.entriesSeen;
        }

        @Override
        public void remove() {
            if (this.removed) {
                throw new IllegalStateException();
            }
            if (DiskBackedHashMap.this.vTime != this.expectedVTime) {
                throw new ConcurrentModificationException();
            }
            try {
                DiskBackedHashMap.this.removeEntry(this.currentEntry);
                if (this.currentEntry.prevEntryOffset == -1L) {
                    this.dataIn = this.getTableInputStream(DiskBackedHashMap.this.tablePtr + this.tableEntry * 30L);
                    --this.tableEntry;
                    this.currentEntry = null;
                } else {
                    this.currentEntry.offset = this.currentEntry.prevEntryOffset;
                }
            }
            catch (IOException e) {
                throw new DBHMException(e);
            }
            --this.entriesSeen;
            this.removed = true;
            this.expectedVTime = DiskBackedHashMap.this.vTime;
        }
    }

    protected class EntryResult {
        protected Entry entry;
        protected Entry predecessor;

        public EntryResult(Entry predecessor, Entry entry) {
            this.predecessor = predecessor;
            this.entry = entry;
        }
    }

    protected class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        protected EntrySet() {
        }

        @Override
        public int size() {
            return (int)DiskBackedHashMap.this.size;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return DiskBackedHashMap.this.newEntryIterator();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean modified = false;
            Iterator<?> i = c.iterator();
            while (i.hasNext()) {
                modified |= this.remove(i.next());
            }
            return modified;
        }

        @Override
        public boolean isEmpty() {
            return DiskBackedHashMap.this.size == 0L;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            try {
                Map.Entry e1 = (Map.Entry)o;
                Entry e2 = DiskBackedHashMap.this.getEntry(e1.getKey()).entry;
                return e2 != null && DiskBackedHashMap.this.equal(e1.getValue(), e2.getValue());
            }
            catch (IOException e) {
                throw new DBHMException(e);
            }
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            try {
                Map.Entry e1 = (Map.Entry)o;
                Entry e2 = DiskBackedHashMap.this.getEntry(e1.getKey()).entry;
                if (e2 != null && DiskBackedHashMap.this.equal(e1.getValue(), e2.getValue())) {
                    DiskBackedHashMap.this.removeEntry(e2);
                    ++DiskBackedHashMap.this.vTime;
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                throw new DBHMException(e);
            }
        }

        @Override
        public void clear() {
            DiskBackedHashMap.this.clear();
        }
    }

    protected class KeyIterator
    implements Iterator<K> {
        protected EntryIterator it;

        protected KeyIterator() {
            this.it = DiskBackedHashMap.this.newEntryIterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public K next() {
            return this.it.next().getKey();
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }

    protected class KeySet
    extends AbstractSet<K> {
        protected KeySet() {
        }

        @Override
        public int size() {
            return (int)DiskBackedHashMap.this.size;
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean modified = false;
            Iterator<?> i = c.iterator();
            while (i.hasNext()) {
                modified |= this.remove(i.next());
            }
            return modified;
        }

        @Override
        public boolean isEmpty() {
            return DiskBackedHashMap.this.size == 0L;
        }

        @Override
        public boolean contains(Object o) {
            return DiskBackedHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            Entry entry;
            block3: {
                try {
                    entry = DiskBackedHashMap.this.getEntry((Object)o).entry;
                    if (entry != null) break block3;
                    return false;
                }
                catch (IOException e) {
                    throw new DBHMException(e);
                }
            }
            DiskBackedHashMap.this.removeEntry(entry);
            ++DiskBackedHashMap.this.vTime;
            return true;
        }

        @Override
        public void clear() {
            DiskBackedHashMap.this.clear();
        }
    }

    protected class ValueIterator
    implements Iterator<V> {
        protected EntryIterator it;

        protected ValueIterator() {
            this.it = DiskBackedHashMap.this.newEntryIterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public V next() {
            return this.it.next().getValue();
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }

    protected class Values
    extends AbstractCollection<V> {
        protected Values() {
        }

        @Override
        public int size() {
            return (int)DiskBackedHashMap.this.size;
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public boolean isEmpty() {
            return DiskBackedHashMap.this.size == 0L;
        }

        @Override
        public boolean contains(Object o) {
            return DiskBackedHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            DiskBackedHashMap.this.clear();
        }
    }
}

