/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.google.gson.JsonObject;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.response.Response;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.Release;
import com.urbancode.release.rest.models.Role;
import com.urbancode.release.rest.models.internal.Deployment;
import com.urbancode.release.rest.models.internal.DeploymentExecution;
import com.urbancode.release.rest.models.internal.InternalClients;
import com.urbancode.release.rest.models.internal.Phase;
import com.urbancode.release.rest.models.internal.SegmentPlan;
import com.urbancode.release.rest.models.internal.SuggestedTask;
import com.urbancode.release.rest.models.internal.Task;
import com.urbancode.release.rest.models.internal.TaskPlan;

public class DeploymentPlan
extends Deployment<DeploymentPlan> {
    public static final DeploymentPlan DEFAULT_PLAN = (DeploymentPlan)new DeploymentPlan().id("00000000-0000-0000-0000-000000000436");
    public Release release;
    @JsonReadOnly
    public Boolean hasEdit;
    @JsonReadOnly
    public Long lastRefresh;
    @JsonReadOnly
    public SegmentPlan[] segments;
    @JsonReadOnly
    public DeploymentExecution[] executions;
    @JsonReadOnly
    public SuggestedTask[] suggestedTasks;

    public DeploymentPlan() {
        this.path = "/deploymentPlans/";
    }

    public DeploymentPlan release(Release release) {
        this.release = release;
        return this;
    }

    public DeploymentPlan copy(Release release, Phase phase, String name) {
        JsonObject json = new JsonObject();
        json.addProperty("copyId", this.id == null ? "" : this.id);
        json.addProperty("name", name == null ? this.name : name);
        json.addProperty("release", release == null ? this.release.id : release.id);
        if (phase != null) {
            json.addProperty("phase", phase.id);
        }
        String newId = ((Response)this.query.apply(RestAssured.given()).body(json.toString()).expect().statusCode(201).post(this.writePath(), new Object[0])).then().extract().header("Location");
        newId = newId.substring(newId.lastIndexOf(47) + 1);
        return (DeploymentPlan)((DeploymentPlan)new DeploymentPlan().id(newId)).get();
    }

    public static DeploymentPlan createSimpleDeploymentPlan(String name, Release release, int numOfSegments, int tasksPerSegment) {
        DeploymentPlan result = (DeploymentPlan)InternalClients.deploymentPlan().release(release).name(name);
        result.save();
        for (int i = 0; i < numOfSegments; ++i) {
            SegmentPlan seg = (SegmentPlan)((SegmentPlan)((SegmentPlan)InternalClients.segmentPlan().name("Segment " + i)).executionPattern("PARALLEL")).deploymentPlan(result).save();
            for (int j = 0; j < tasksPerSegment; ++j) {
                TaskPlan task = (TaskPlan)((TaskPlan)((TaskPlan)((TaskPlan)((TaskPlan)((TaskPlan)InternalClients.taskPlan().name("task " + j)).taskType(Task.TaskType.ManualTask)).taskPattern(Task.ExecutionPattern.ALWAYS)).executorRoleOrGroup(Role.ADMIN)).updateVersion(false)).save();
                seg.addTask(task);
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }
}

