/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.interop;

import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.WvcmException;

public class UcmImporterMetadataMap {
    final List<StreamEntry> streams = new ArrayList<StreamEntry>();
    final Map<String, ComponentEntry> componentsByResId = new HashMap<String, ComponentEntry>();
    final List<ActivityEntry> activities = new ArrayList<ActivityEntry>();

    public static void addField(JSONObject o, FieldTags tag, Entry e) {
        o.put((Object)tag.printedAs(), (Object)e.toJSON());
    }

    public static void addField(JSONObject o, FieldTags tag, String s) {
        o.put((Object)tag.printedAs(), (Object)s);
    }

    public static void addField(JSONObject o, FieldTags tag, JSONObject value) {
        o.put((Object)tag.printedAs(), (Object)value);
    }

    public static void addField(JSONObject o, FieldTags tag, JSONArray a) {
        o.put((Object)tag.printedAs(), (Object)a);
    }

    public static void addField(JSONObject o, FieldTags tag, Collection<? extends Entry> entries) {
        JSONArray fieldValues = new JSONArray(entries.size());
        for (Entry entry : entries) {
            fieldValues.add((Object)entry.toJSON());
        }
        o.put((Object)tag.printedAs(), (Object)fieldValues);
    }

    public static void addStringCollectionField(JSONObject o, FieldTags tag, Collection<String> values) {
        JSONArray fieldValues = new JSONArray(values.size());
        for (String v : values) {
            fieldValues.add((Object)v);
        }
        o.put((Object)tag.printedAs(), (Object)fieldValues);
    }

    public void addStream(StreamEntry s, Collection<ComponentEntry> componentEntries) {
        this.streams.add(s);
        for (ComponentEntry componentEntry : componentEntries) {
            this.componentsByResId.put(componentEntry.resId, componentEntry);
        }
    }

    public void addActivities(List<ActivityEntry> moreActivities) {
        if (moreActivities != null) {
            this.activities.addAll(moreActivities);
        }
    }

    public JSONObject toJSON() throws WvcmException {
        JSONObject result = new JSONObject();
        UcmImporterMetadataMap.addField(result, FieldTags.COMPONENTS, this.componentsByResId.values());
        UcmImporterMetadataMap.addField(result, FieldTags.ACTIVITIES, this.activities);
        UcmImporterMetadataMap.addField(result, FieldTags.STREAMS, this.streams);
        return result;
    }

    public static class ActivityEntry
    extends Entry {
        ActivityEntry(String resId, String name) {
            super(EntryKinds.ACTIVITY, resId, name);
        }

        @Override
        protected void addFields(JSONObject o) {
        }
    }

    public static class BaselineEntry
    extends TimelineEntry {
        BaselineEntry(String resId, String name, String streamResId, String componentResId) {
            super(EntryKinds.BASELINE, resId, name, streamResId, componentResId);
        }
    }

    public static class ChangeSetEntry
    extends TimelineEntry {
        final ActivityEntry activityEntry;
        final List<String> versionResIds;

        ChangeSetEntry(String name, ActivityEntry activityEntry, String streamResId, String componentResId, List<String> versionResIds) {
            super(EntryKinds.CHANGESET, activityEntry.resId, name, streamResId, componentResId);
            this.activityEntry = activityEntry;
            this.versionResIds = versionResIds == null ? null : new ArrayList<String>(versionResIds);
        }

        @Override
        protected void addFields(JSONObject o) {
            super.addFields(o);
            UcmImporterMetadataMap.addField(o, FieldTags.ACTIVITY, this.activityEntry);
            UcmImporterMetadataMap.addStringCollectionField(o, FieldTags.VERSIONS, this.versionResIds);
        }
    }

    public static class ComponentEntry
    extends Entry {
        ComponentEntry(String resId, String name) {
            super(EntryKinds.COMPONENT, resId, name);
        }

        @Override
        protected void addFields(JSONObject o) {
        }
    }

    public static class ConfigurationEntry
    extends Entry {
        final ComponentEntry componentEntry;
        final BaselineEntry initialBaselineEntry;
        final List<TimelineEntry> timelineEntries;

        ConfigurationEntry(String descriptiveName, ComponentEntry componentEntry, BaselineEntry initialBaselineEntry, String bcfVhResId, List<TimelineEntry> timelineEntries) {
            super(EntryKinds.CONFIGURATION, bcfVhResId, descriptiveName);
            this.componentEntry = componentEntry;
            this.initialBaselineEntry = initialBaselineEntry;
            this.timelineEntries = timelineEntries == null ? null : new ArrayList<TimelineEntry>(timelineEntries);
        }

        @Override
        protected void addFields(JSONObject o) {
            UcmImporterMetadataMap.addField(o, FieldTags.COMPONENT, this.componentEntry);
            UcmImporterMetadataMap.addField(o, FieldTags.BASELINE, this.initialBaselineEntry);
            UcmImporterMetadataMap.addField(o, FieldTags.TIMELINE, this.timelineEntries);
        }
    }

    public static abstract class Entry {
        final EntryKinds myKind;
        final String resId;
        final String name;

        Entry(EntryKinds kind, String resId, String name) {
            this.myKind = kind;
            this.resId = resId;
            this.name = name;
        }

        public final String getResourceIdentifier() {
            return this.resId;
        }

        protected abstract void addFields(JSONObject var1);

        public JSONObject toJSON() {
            JSONObject result = new JSONObject();
            UcmImporterMetadataMap.addField(result, FieldTags.KIND, this.myKind.displayName());
            if (this.resId != null) {
                UcmImporterMetadataMap.addField(result, FieldTags.RES_ID, this.resId);
            }
            if (this.name != null) {
                UcmImporterMetadataMap.addField(result, FieldTags.DISPLAY_NAME, this.name);
            }
            this.addFields(result);
            return result;
        }
    }

    public static enum EntryKinds {
        STREAM("stream"),
        COMPONENT("component"),
        CONFIGURATION("configuration"),
        INITIAL_TIMELINE_ENTRY("initialTimelineEntry"),
        BASELINE("baseline"),
        ACTIVITY("activity"),
        CHANGESET("changeset");

        private static EnumSet<EntryKinds> allKinds;
        private static Map<String, EntryKinds> byName;
        private final String printedAs;

        static {
            allKinds = EnumSet.allOf(EntryKinds.class);
            byName = new HashMap<String, EntryKinds>(allKinds.size());
            for (EntryKinds kind : allKinds) {
                byName.put(kind.displayName(), kind);
            }
        }

        static EntryKinds lookupByName(String name) {
            return byName.get(name);
        }

        private EntryKinds(String printAs) {
            this.printedAs = printAs;
        }

        public String displayName() {
            return this.printedAs;
        }
    }

    public static enum FieldTags {
        RES_ID("resourceId"),
        DISPLAY_NAME("displayName"),
        KIND("kind"),
        STREAMS("streams"),
        STREAM("stream"),
        COMPONENTS("components"),
        ACTIVITIES("activities"),
        CONFIGURATIONS("configurations"),
        COMPONENT("component"),
        TIMELINE("timeline"),
        BASELINE("baseline"),
        ACTIVITY("activity"),
        CHANGESET("changeset"),
        VERSIONS("versions");

        private final String printedAs;
        static final EnumSet<FieldTags> tagsEnumSet;
        static final Map<String, FieldTags> tagsByName;

        static {
            tagsEnumSet = EnumSet.allOf(FieldTags.class);
            tagsByName = new HashMap<String, FieldTags>(tagsEnumSet.size());
            for (FieldTags t : tagsEnumSet) {
                tagsByName.put(t.printedAs(), t);
            }
        }

        private FieldTags(String printAs) {
            this.printedAs = printAs;
        }

        public String printedAs() {
            return this.printedAs;
        }

        static FieldTags lookupByName(String name) {
            return tagsByName.get(name);
        }
    }

    public static class InitialEntry
    extends TimelineEntry {
        private final BaselineEntry baselineEntry;

        InitialEntry(String bcfResId, String componentName, BaselineEntry baselineEntry) {
            super(EntryKinds.INITIAL_TIMELINE_ENTRY, bcfResId, componentName, baselineEntry.streamResId, baselineEntry.streamResId);
            this.baselineEntry = baselineEntry;
        }

        @Override
        protected void addFields(JSONObject o) {
            super.addFields(o);
            UcmImporterMetadataMap.addField(o, FieldTags.BASELINE, this.baselineEntry);
        }
    }

    public static class StreamEntry
    extends Entry {
        final List<ConfigurationEntry> configurations;

        StreamEntry(String resId, String name, List<ConfigurationEntry> configurations) {
            super(EntryKinds.STREAM, resId, name);
            this.configurations = configurations != null ? new ArrayList<ConfigurationEntry>(configurations) : new ArrayList();
        }

        @Override
        protected void addFields(JSONObject o) {
            UcmImporterMetadataMap.addField(o, FieldTags.CONFIGURATIONS, this.configurations);
        }
    }

    public static abstract class TimelineEntry
    extends Entry {
        final String streamResId;
        final String componentResId;

        TimelineEntry(EntryKinds kind, String resId, String name, String streamResId, String componentResId) {
            super(kind, resId, name);
            this.streamResId = streamResId;
            this.componentResId = componentResId;
        }

        @Override
        protected void addFields(JSONObject o) {
            UcmImporterMetadataMap.addField(o, FieldTags.STREAM, this.streamResId);
            UcmImporterMetadataMap.addField(o, FieldTags.COMPONENT, this.componentResId);
        }
    }
}

