/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.provider.jena;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import org.eclipse.lyo.oslc4j.core.model.FilteredResource;
import org.eclipse.lyo.oslc4j.core.model.OslcMediaType;
import org.eclipse.lyo.oslc4j.core.model.ResponseInfo;
import org.eclipse.lyo.oslc4j.core.model.ResponseInfoArray;
import org.eclipse.lyo.oslc4j.core.model.ResponseInfoCollection;
import org.eclipse.lyo.oslc4j.provider.jena.AbstractOslcRdfXmlProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/rdf+xml", "application/xml", "text/xml"})
@Consumes(value={"application/rdf+xml", "application/xml", "text/xml"})
public final class OslcRdfXmlProvider
extends AbstractOslcRdfXmlProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    @Override
    public long getSize(Object object, Class<?> type, Type genericType, Annotation[] annotation, MediaType mediaType) {
        return -1L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Class actualType;
        if (FilteredResource.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (actualTypeArguments.length != 1) {
                return false;
            }
            if (actualTypeArguments[0] instanceof Class) {
                actualType = (Class)actualTypeArguments[0];
                return OslcRdfXmlProvider.isWriteable(actualType, annotations, mediaType, OslcMediaType.APPLICATION_RDF_XML_TYPE, OslcMediaType.APPLICATION_XML_TYPE, OslcMediaType.TEXT_XML_TYPE);
            } else if (actualTypeArguments[0] instanceof ParameterizedType) {
                parameterizedType = (ParameterizedType)actualTypeArguments[0];
                if ((actualTypeArguments = parameterizedType.getActualTypeArguments()).length != 1 || !(actualTypeArguments[0] instanceof Class)) {
                    return false;
                }
                actualType = (Class)actualTypeArguments[0];
                return OslcRdfXmlProvider.isWriteable(actualType, annotations, mediaType, OslcMediaType.APPLICATION_RDF_XML_TYPE, OslcMediaType.APPLICATION_XML_TYPE, OslcMediaType.TEXT_XML_TYPE);
            } else {
                if (!(actualTypeArguments[0] instanceof GenericArrayType)) return false;
                GenericArrayType genericArrayType = (GenericArrayType)actualTypeArguments[0];
                Type componentType = genericArrayType.getGenericComponentType();
                if (!(componentType instanceof Class)) {
                    return false;
                }
                actualType = (Class)componentType;
            }
            return OslcRdfXmlProvider.isWriteable(actualType, annotations, mediaType, OslcMediaType.APPLICATION_RDF_XML_TYPE, OslcMediaType.APPLICATION_XML_TYPE, OslcMediaType.TEXT_XML_TYPE);
        } else {
            actualType = type;
        }
        return OslcRdfXmlProvider.isWriteable(actualType, annotations, mediaType, OslcMediaType.APPLICATION_RDF_XML_TYPE, OslcMediaType.APPLICATION_XML_TYPE, OslcMediaType.TEXT_XML_TYPE);
    }

    @Override
    public void writeTo(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> map, OutputStream outputStream) throws IOException, WebApplicationException {
        Object[] objects;
        Map<String, Object> properties = null;
        String descriptionURI = null;
        String responseInfoURI = null;
        String nextPageURI = null;
        Integer totalCount = null;
        if (object instanceof FilteredResource) {
            FilteredResource filteredResource = (FilteredResource)object;
            properties = filteredResource.properties();
            if (filteredResource instanceof ResponseInfo) {
                responseInfoURI = descriptionURI = OSLC4JUtils.resolveURI(this.httpServletRequest, true);
                String queryString = this.httpServletRequest.getQueryString();
                if (queryString != null && OslcRdfXmlProvider.isOslcQuery(queryString)) {
                    responseInfoURI = responseInfoURI + "?" + queryString;
                }
                if (filteredResource instanceof ResponseInfoArray) {
                    objects = ((ResponseInfoArray)filteredResource).array();
                } else {
                    Collection<Object> collection = ((ResponseInfoCollection)filteredResource).collection();
                    objects = collection.toArray(new Object[collection.size()]);
                }
                nextPageURI = ((ResponseInfo)filteredResource).nextPage();
                totalCount = ((ResponseInfo)filteredResource).totalCount();
            } else {
                Object nestedObject = filteredResource.resource();
                objects = nestedObject instanceof Object[] ? (Object[])nestedObject : (nestedObject instanceof Collection ? ((Collection)nestedObject).toArray() : new Object[]{object});
            }
        } else {
            objects = new Object[]{object};
        }
        this.writeTo(objects, mediaType, map, outputStream, properties, descriptionURI, responseInfoURI, nextPageURI, totalCount);
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return OslcRdfXmlProvider.isReadable(type, mediaType, OslcMediaType.APPLICATION_RDF_XML_TYPE, OslcMediaType.APPLICATION_XML_TYPE, OslcMediaType.TEXT_XML_TYPE);
    }

    @Override
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> map, InputStream inputStream) throws IOException, WebApplicationException {
        Object[] objects = this.readFrom(type, mediaType, map, inputStream);
        if (objects != null && objects.length > 0) {
            return objects[0];
        }
        return null;
    }
}

