/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ComponentLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalCFALock;
import com.ibm.team.scm.client.internal.IConfigurationDescriptor;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class CopyFileAreaConfigurationLockRequest
extends CopyFileAreaLockRequest {
    private final Collection<? extends IConfigurationDescriptor> configurationsToLock;
    private final boolean expandToIncludeEntireCopyFileArea;
    private final ILocation cfaPath;

    public CopyFileAreaConfigurationLockRequest(ILocation cfaPath, Collection<? extends IConfigurationDescriptor> configurationsToLock, boolean expandToIncludeEntireCopyFileArea) {
        this.cfaPath = cfaPath;
        this.configurationsToLock = configurationsToLock;
        this.expandToIncludeEntireCopyFileArea = expandToIncludeEntireCopyFileArea;
    }

    @Override
    public void addLocks(Set<? super AbstractLock> rules, IProgressMonitor monitor) throws FileSystemException {
        if (!this.expandToIncludeEntireCopyFileArea && this.configurationsToLock.isEmpty()) {
            return;
        }
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaPath);
        if (cfa == null) {
            cfa = CopyFileAreaManager.instance.createCopyFileArea(this.cfaPath, monitor);
        }
        if (this.expandToIncludeEntireCopyFileArea) {
            rules.add(new GlobalCFALock(cfa.getRoot()));
        } else {
            for (IConfigurationDescriptor iConfigurationDescriptor : this.configurationsToLock) {
                rules.add(new ComponentLock(cfa.getRoot(), iConfigurationDescriptor.getConnectionHandle(), iConfigurationDescriptor.getComponentHandle()));
            }
        }
    }

    @Override
    public boolean validateLocks(IProgressMonitor monitor) throws FileSystemException {
        if (!this.expandToIncludeEntireCopyFileArea && this.configurationsToLock.isEmpty()) {
            return true;
        }
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaPath);
        if (cfa == null) {
            return false;
        }
        if (this.expandToIncludeEntireCopyFileArea) {
            return CopyFileAreaManager.instance.batchingLock.isLocked(new GlobalCFALock(cfa.getRoot()));
        }
        for (IConfigurationDescriptor iConfigurationDescriptor : this.configurationsToLock) {
            if (CopyFileAreaManager.instance.batchingLock.isLocked(new ComponentLock(cfa.getRoot(), iConfigurationDescriptor.getConnectionHandle(), iConfigurationDescriptor.getComponentHandle()))) continue;
            return false;
        }
        return true;
    }
}

