/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalMetadataValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.metadata.validator.MetaDatasCollector;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.BTreeContentValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.BTreeValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.ChangedInfosMapValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.DiskBackedHashMapEntriesValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.DiskBackedHashMapValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.HeapValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.InverseItemInfoMapValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.InverseSharingDescriptorsMapValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.ItemInfoMapValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.LoadedComponentsMapValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.MetaMetaMapValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.SharingDescriptorsMapValidator;
import com.ibm.team.filesystem.client.internal.core.SharingMetadataFactory;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.operations.IMetadataValidateOperation;
import com.ibm.team.internal.repository.rcp.util.RAFWrapper;
import com.ibm.team.scm.common.LocaleUtil;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class ValidateMetadataOperation
extends FileSystemOperation
implements IMetadataValidateOperation {
    private static final String DEFAULT_VALIDATOR_KEY = "<DEFAULT>";
    private static final String CHANGEDINFOS_VALIDATOR_KEY = ".changedinfos.dat";
    private ILocation cfaRoot;
    private ILocation metadataPath;
    private GlobalMetadataValidator globalMetadataValidator;
    private static final String SCM_FLAG_IS_COMPLETE = ".isComplete";
    private IStatus status;
    private boolean reportDump;
    private PrintWriter writer;

    public ValidateMetadataOperation(ILocation cfaRoot, ILocation metadataPath) {
        super(null);
        this.cfaRoot = cfaRoot;
        this.metadataPath = metadataPath;
    }

    @Override
    public void execute(IProgressMonitor monitor) throws FileSystemException {
        if (this.writer == null) {
            throw new IllegalStateException("Missing writer");
        }
        ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaRoot);
        ISharingMetadata metadata = null;
        if (cfa != null && cfa instanceof CopyFileArea) {
            metadata = ((CopyFileArea)cfa).internalGetMetadata();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock rule = GlobalLock.INSTANCE;
        try {
            try {
                rule = CopyFileAreaStore.beginBatching(rule, null);
                if (metadata != null) {
                    metadata.close();
                }
                try {
                    this.status = this.validateMetadata(this.metadataPath, (IProgressMonitor)progress.newChild(100));
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                throw new OperationCanceledException();
            }
        }
        finally {
            if (rule != null) {
                CopyFileAreaStore.endBatching(rule, null);
            }
        }
        progress.done();
    }

    /*
     * Unable to fully structure code
     */
    private IStatus validateMetadata(ILocation metadataPath, IProgressMonitor monitor) throws IOException {
        block168: {
            block162: {
                block163: {
                    block164: {
                        block165: {
                            block166: {
                                block167: {
                                    this.globalMetadataValidator = this.reportDump != false ? new MetaDatasCollector(this.writer) : new GlobalMetadataValidator();
                                    rootFile = (File)metadataPath.getAdapter(File.class);
                                    toVisit = new ArrayList<File>();
                                    values = new ArrayList<Double>();
                                    progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1024);
                                    worked = 0.0;
                                    value = 1024.0;
                                    iWorked = 0;
                                    toVisit.add(rootFile);
                                    values.add(value);
                                    ms = new MultiStatus("com.ibm.team.filesystem.client", 0, "Metadata errors", null);
                                    f1 = new File(rootFile, "zzz-asdf");
                                    f2 = new File(rootFile, "zzz-Asdf");
                                    caseSensitive = f1.equals(f2) == false;
                                    hv = null;
                                    btc = null;
                                    btv = null;
                                    validators = new HashMap<String, DiskBackedHashMapEntriesValidator>();
                                    try {
                                        hv = new HeapValidator();
                                        btc = new BTreeContentValidator(hv);
                                        btv = new BTreeValidator(hv, btc);
                                        validators.put(".components", new LoadedComponentsMapValidator(rootFile, hv, this.globalMetadataValidator));
                                        validators.put(".changedinfos.dat", new ChangedInfosMapValidator(rootFile, hv, this.globalMetadataValidator));
                                        validators.put(".descriptors.dat", new SharingDescriptorsMapValidator(rootFile, caseSensitive, hv, this.globalMetadataValidator));
                                        validators.put(".inversedescriptors.dat", new InverseSharingDescriptorsMapValidator(rootFile, caseSensitive, hv, this.globalMetadataValidator));
                                        validators.put(".iteminfo.dat", new ItemInfoMapValidator(rootFile, caseSensitive, hv, this.globalMetadataValidator));
                                        validators.put(".inverseiteminfo.dat", new InverseItemInfoMapValidator(rootFile, hv, this.globalMetadataValidator));
                                        validators.put(".metameta", new MetaMetaMapValidator(rootFile, hv, this.globalMetadataValidator));
                                        validators.put("<DEFAULT>", new DiskBackedHashMapEntriesValidator(hv, this.globalMetadataValidator));
                                        this.globalMetadataValidator.beginValidation(caseSensitive);
                                        do {
                                            next = (File)toVisit.remove(toVisit.size() - 1);
                                            value = (Double)values.remove(toVisit.size());
                                            if (next.isFile()) {
                                                resultS = ValidateMetadataOperation.validateFile(next, rootFile, caseSensitive, hv, btv, validators, this.globalMetadataValidator);
                                                if (resultS.length() != 0) {
                                                    status = FileSystemStatusUtil.getStatusFor(4, resultS);
                                                    this.writer.append("The following errors were found in " + next + "\n");
                                                    this.writer.append(resultS);
                                                    this.writer.append("\n");
                                                    ms.add((IStatus)new MultiStatus(status.getPlugin(), status.getCode(), new IStatus[]{status}, "The following errors were found in " + next, null));
                                                }
                                                if ((tWorked = (int)(worked += value)) > iWorked) {
                                                    progress.worked(tWorked - iWorked);
                                                    iWorked = tWorked;
                                                }
                                            } else {
                                                children = next.listFiles();
                                                if (children != null && children.length != 0) {
                                                    toVisit.addAll(Arrays.asList(children));
                                                    value /= (double)children.length;
                                                    i = children.length;
                                                    while (i != 0) {
                                                        values.add(value);
                                                        --i;
                                                    }
                                                } else {
                                                    tWorked = (int)(worked += value);
                                                    if (tWorked > iWorked) {
                                                        progress.worked(tWorked - iWorked);
                                                        iWorked = tWorked;
                                                    }
                                                }
                                            }
                                            if (!progress.isCanceled()) continue;
                                            throw new OperationCanceledException();
                                        } while (!toVisit.isEmpty());
                                        b = new StringBuilder();
                                        this.globalMetadataValidator.endValidation(b);
                                        if (b.length() != 0) {
                                            this.dumpErrorsInFile(b);
                                            status = FileSystemStatusUtil.getStatusFor(4, b.toString());
                                            ms.add((IStatus)new MultiStatus(status.getPlugin(), status.getCode(), new IStatus[]{status}, "The following global errors were found", null));
                                        }
                                    }
                                    finally {
                                        try {
                                            this.globalMetadataValidator.cleanup();
                                            break block162;
                                        }
                                        catch (Throwable var22_22) {
                                            if (hv == null) break block163;
                                            try {
                                                hv.cleanUp();
                                                break block164;
                                            }
                                            catch (Throwable var23_25) {
                                                if (btc == null) break block165;
                                                try {
                                                    btc.cleanUp();
                                                    break block166;
                                                }
                                                catch (Throwable var24_31) {
                                                    if (btv == null) break block167;
                                                    try {
                                                        btv.cleanUp();
                                                    }
                                                    finally {
                                                        var27_68 = validators.values().iterator();
                                                        if (true) ** GOTO lbl117
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    {
                                    }
                                    do {
                                        validator = (DiskBackedHashMapEntriesValidator)var27_68.next();
                                        try {
                                            validator.cleanUp();
                                        }
                                        catch (Throwable v0) {}
lbl117:
                                        // 3 sources

                                    } while (var27_68.hasNext());
                                }
                                throw var24_31;
                            }
                            if (btv != null) {
                                try {
                                    btv.cleanUp();
                                }
                                finally {
                                    ** for (validator : validators.values())
                                }
lbl-1000:
                                // 1 sources

                                {
                                    try {
                                        validator.cleanUp();
                                    }
                                    catch (Throwable v1) {}
                                    continue;
                                }
                            }
                        }
                        throw var23_25;
                    }
                    if (btc != null) {
                        try {
                            btc.cleanUp();
                        }
                        finally {
                            if (btv == null) break block163;
                            try {
                                btv.cleanUp();
                            }
                            finally {
                                ** for (validator : validators.values())
                            }
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                validator.cleanUp();
                            }
                            catch (Throwable v2) {}
                            continue;
                        }
                    }
                }
                throw var22_22;
            }
            if (hv != null) {
                block169: {
                    block170: {
                        try {
                            hv.cleanUp();
                        }
                        finally {
                            if (btc == null) break block168;
                            try {
                                btc.cleanUp();
                                break block169;
                            }
                            catch (Throwable var24_34) {
                                if (btv == null) break block170;
                                try {
                                    btv.cleanUp();
                                }
                                finally {
                                    ** for (validator : validators.values())
                                }
                            }
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                validator.cleanUp();
                            }
                            catch (Throwable v3) {}
                            continue;
                        }
                    }
                    throw var24_34;
                }
                if (btv != null) {
                    try {
                        btv.cleanUp();
                    }
                    finally {
                        ** for (validator : validators.values())
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            validator.cleanUp();
                        }
                        catch (Throwable v4) {}
                        continue;
                    }
                }
            }
        }
        this.writer.flush();
        this.writer.close();
        if (ms.isOK()) {
            return Status.OK_STATUS;
        }
        return ms;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String validateFile(File f, File root, boolean isCaseSensitive, HeapValidator hv, BTreeValidator btv, Map<String, DiskBackedHashMapEntriesValidator> validators, GlobalMetadataValidator gv) throws IOException {
        block35: {
            block34: {
                block33: {
                    buf = new StringBuilder();
                    ev = null;
                    raf = new RAFWrapper(f, "r");
                    try {
                        hv.beginValidation(f, raf, buf);
                        btv.beginValidation(raf);
                        name = f.getName();
                        if (isCaseSensitive) {
                            corruptName = ".isCorrupt";
                            completeName = ".isComplete";
                        } else {
                            name = LocaleUtil.localeSafeNormalization((String)name);
                            corruptName = ".isCorrupt".toLowerCase();
                            completeName = ".isComplete".toLowerCase();
                        }
                        if (name.equals(".jazzlock") && root.equals(parent = f.getParentFile())) {
                            btv.endValidation();
                            break block33;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Exception e) {
                        bytes = new ByteArrayOutputStream();
                        printWriter = new PrintWriter(bytes);
                        e.printStackTrace(printWriter);
                        printWriter.close();
                        buf.append("/n");
                        buf.append(new String(bytes.toByteArray()));
                        try {
                            hv.endValidation(ev != null && ev != validators.get("<DEFAULT>"));
                            return buf.toString();
                        }
                        finally {
                            raf.getFile().close();
                        }
                    }
                    catch (Throwable var15_21) {
                        try {
                            hv.endValidation(ev != null && ev != validators.get("<DEFAULT>"));
                            throw var15_21;
                        }
                        finally {
                            raf.getFile().close();
                        }
                    }
                }
                try {
                    hv.endValidation(ev != null && ev != validators.get("<DEFAULT>"));
                    return "";
                }
                finally {
                    raf.getFile().close();
                }
lbl-1000:
                // 1 sources

                {
                    if (!name.equals(corruptName) && (!name.startsWith(".") || !name.endsWith(completeName)) || (parent = f.getParentFile()) == null || !parent.getName().equals(".flags") || !root.equals(parent = parent.getParentFile())) break block34;
                    if (!gv.addFlag(f.getName())) {
                        buf.append("Unrecognized file into the .flags folder. You might want to update the GlobalMetadataValidator to be aware of that new file.");
                    }
                    btv.endValidation();
                }
                try {
                    hv.endValidation(ev != null && ev != validators.get("<DEFAULT>"));
                    return "";
                }
                finally {
                    raf.getFile().close();
                }
            }
            ** try [egrp 8[TRYBLOCK] [4 : 326->445)] { 
lbl64:
            // 1 sources

            ev = validators.get(name);
            if (ev == null) {
                if (name.startsWith(".changedinfos") && name.endsWith(".dat")) {
                    ev = validators.get(".changedinfos.dat");
                    break block35;
                } else {
                    buf.append("Unknown map: " + f + "\nAn entry validator should be written to check the keys and values of this metadata file.");
                    ev = validators.get("<DEFAULT>");
                }
            }
            break block35;
lbl74:
            // 1 sources

            finally {
                btv.endValidation();
            }
        }
        new DiskBackedHashMapValidator(hv, ev, raf).cleanUp();
        try {
            hv.endValidation(ev != null && ev != validators.get("<DEFAULT>"));
            return buf.toString();
        }
        finally {
            raf.getFile().close();
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: <root of metadata> <file path for log>");
            return;
        }
        PrintWriter writer = null;
        try {
            try {
                writer = new PrintWriter(new BufferedWriter(new FileWriter(new File(args[1]))));
                PathLocation root = new PathLocation(args[0]);
                ValidateMetadataOperation operation = new ValidateMetadataOperation(root, SharingMetadataFactory.getMetadataRoot(root));
                operation.setWriter(writer);
                try {
                    operation.execute((IProgressMonitor)new NullProgressMonitor());
                }
                catch (FileSystemException e) {
                    e.printStackTrace();
                }
                writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                if (writer != null) {
                    writer.close();
                }
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void dumpErrorsInFile(StringBuilder b) {
        this.writer.write(String.valueOf(b));
        this.writer.flush();
    }

    @Override
    public IStatus getStatus() {
        return this.status;
    }

    @Override
    public void setDump(boolean value) {
        this.reportDump = value;
    }

    @Override
    public void setWriter(PrintWriter writer) {
        this.writer = writer;
    }
}

