/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load.loadRules.builders;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILoadFilter;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.load.loadRules.LoadRequest;
import com.ibm.team.filesystem.client.internal.load.loadRules.LoadRule2;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.ILoadRuleBuilder;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.ItemLoadBuilder;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.LoadFilterBuilder;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.ParentLoadBuilder;
import com.ibm.team.filesystem.client.internal.load.loadRules.builders.RuleBuilder;
import com.ibm.team.filesystem.client.operations.ILoadRule2;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.xml.sax.Attributes;

public class LoadRuleBuilder
implements ILoadRuleBuilder {
    private int eclipseOption = 0;
    private ILoadFilter filter;
    private LoadRule2 loadRule;
    private List<RuleBuilder> requests = new ArrayList<RuleBuilder>();
    private Integer ruleVersion;
    private boolean allowsNestedShares;

    public LoadRuleBuilder(boolean allowsNestedShares) {
        this.allowsNestedShares = allowsNestedShares;
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws FileSystemException {
    }

    @Override
    public void endElement(String eName) throws FileSystemException {
        if (!eName.equals("sourceControlLoadRule")) {
            throw new FileSystemException(NLS.bind((String)Messages.LoadRuleBuilder_3, (Object)eName, (Object[])new Object[0]));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ILoadRuleBuilder startElement(String eName, Attributes attrs) throws TeamRepositoryException {
        ILoadRuleBuilder builder = this;
        if (eName.equals("excludeFilter")) {
            builder = new LoadFilterBuilder(this);
            builder.startElement(eName, attrs);
            return builder;
        } else if (eName.equals("parentLoadRule")) {
            builder = new ParentLoadBuilder();
            this.requests.add((ParentLoadBuilder)builder);
            builder.startElement(eName, attrs);
            return builder;
        } else if (eName.equals("itemLoadRule")) {
            builder = new ItemLoadBuilder();
            this.requests.add((ItemLoadBuilder)builder);
            builder.startElement(eName, attrs);
            return builder;
        } else {
            if (!eName.equals("sourceControlLoadRule")) throw new FileSystemException(NLS.bind((String)Messages.LoadRuleBuilder_4, (Object)eName, (Object[])new Object[0]));
            int i = 0;
            while (i < attrs.getLength()) {
                String attrName = attrs.getQName(i);
                String value = attrs.getValue(i);
                if ("eclipseProjectOptions".equals(attrName)) {
                    if ("create".equals(value)) {
                        this.eclipseOption = 1;
                    } else {
                        if (!"import".equals(value)) throw new FileSystemException(NLS.bind((String)Messages.LoadRuleBuilder_2, (Object)value, (Object[])new Object[0]));
                        this.eclipseOption = 2;
                    }
                } else if ("version".equals(attrName)) {
                    this.ruleVersion = Integer.valueOf(value);
                    if (this.ruleVersion != 1) {
                        throw new FileSystemException(NLS.bind((String)Messages.LoadRuleBuilder_5, (Object)this.ruleVersion, (Object[])new Object[0]));
                    }
                } else if (!attrName.startsWith("xml")) {
                    throw new FileSystemException(NLS.bind((String)Messages.LoadRuleBuilder_6, (Object)attrName, (Object[])new Object[]{value}));
                }
                ++i;
            }
        }
        return builder;
    }

    public ILoadRule2 getLoadRule(IConnection connection, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        this.loadRule = new LoadRule2(connection, this.filter, this.eclipseOption, this.allowsNestedShares);
        HashMap<String, IComponent> componentNames = new HashMap<String, IComponent>();
        HashMap<UUID, IComponentHandle> componentHandles = new HashMap<UUID, IComponentHandle>();
        for (RuleBuilder rule : this.requests) {
            if (rule.getComponentName() != null) {
                componentNames.put(rule.getComponentName(), null);
            }
            if (rule.getComponentHandle() == null) continue;
            componentHandles.put(rule.getComponentHandle().getItemId(), rule.getComponentHandle());
        }
        if (!componentNames.isEmpty()) {
            if (connection instanceof IBaselineConnection) {
                IComponentHandle c = ((IBaselineConnection)connection).getComponent();
                componentHandles.put(c.getItemId(), c);
            } else {
                for (IComponentHandle c : ((IWorkspaceConnection)connection).getComponents()) {
                    componentHandles.put(c.getItemId(), c);
                }
            }
        }
        ArrayList toFetch = new ArrayList(componentHandles.size());
        toFetch.addAll(componentHandles.values());
        List fetched = connection.teamRepository().itemManager().fetchCompleteItems(toFetch, 0, (IProgressMonitor)monitor.newChild(1));
        HashMap<UUID, IComponent> components = new HashMap<UUID, IComponent>();
        for (IComponent component : fetched) {
            if (component == null) continue;
            components.put(component.getItemId(), component);
            componentNames.put(component.getName(), component);
        }
        for (RuleBuilder rule : this.requests) {
            IComponent component = null;
            if (rule.getComponentName() != null) {
                IComponentHandle handle = (IComponentHandle)componentNames.get(rule.getComponentName());
                if (handle == null) {
                    throw new FileSystemException(NLS.bind((String)Messages.LoadRuleBuilder_7, (Object)rule.getComponentName(), (Object[])new Object[]{rule.getErrorInfo()}));
                }
                component = (IComponent)components.get(handle.getItemId());
                if (component == null) {
                    throw new FileSystemException(NLS.bind((String)Messages.LoadRuleBuilder_7, (Object)rule.getComponentName(), (Object[])new Object[]{rule.getErrorInfo()}));
                }
            }
            if (rule.getComponentHandle() != null) {
                IComponentHandle ruleComponentHandle = rule.getComponentHandle();
                component = (IComponent)components.get(ruleComponentHandle.getItemId());
                if (component == null) {
                    throw new FileSystemException(NLS.bind((String)Messages.LoadRuleBuilder_8, (Object)ruleComponentHandle.getItemId().getUuidValue(), (Object[])new Object[]{rule.getErrorInfo()}));
                }
                if (connection instanceof IBaselineConnection) {
                    IComponentHandle c = ((IBaselineConnection)connection).getComponent();
                    if (!rule.getComponentHandle().sameItemId((IItemHandle)c)) {
                        throw new FileSystemException(NLS.bind((String)Messages.LoadRuleBuilder_8, (Object)ruleComponentHandle.getItemId().getUuidValue(), (Object[])new Object[]{rule.getErrorInfo()}));
                    }
                } else {
                    boolean found = false;
                    for (IComponentHandle c : ((IWorkspaceConnection)connection).getComponents()) {
                        if (!rule.getComponentHandle().sameItemId((IItemHandle)c)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        throw new FileSystemException(NLS.bind((String)Messages.LoadRuleBuilder_8, (Object)ruleComponentHandle.getItemId().getUuidValue(), (Object[])new Object[]{rule.getErrorInfo()}));
                    }
                }
            }
            rule.setComponentName(component.getName());
            LoadRequest request = rule.getRequest(connection, component);
            this.loadRule.addLoadRequest(request);
        }
        return this.loadRule;
    }

    public void setLoadFilter(ILoadFilter filter) {
        this.filter = filter;
    }

    public void addLoadRequest(RuleBuilder rule) {
        this.requests.add(rule);
    }
}

