/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.ChangeExtendedPropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IChangeExtendedPropertiesOperation;
import com.ibm.team.filesystem.client.operations.IChangeExtendedPropertiesRequest;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IItemCustomAttributes;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IVersionableHandle;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class ChangeExtendedPropertiesOperation
extends FileSystemOperation
implements IChangeExtendedPropertiesOperation {
    private ChangeExtendedPropertiesDilemmaHandler dilemmaHandler;
    private HashMap<IRelativeLocation, ChangeExtendedPropertiesRequest> changeProperties;
    private final int MAX_CUSTOM_ATTRIBUTE_NAME_LENGTH = 256;
    private boolean refreshBeforeRun = false;

    public ChangeExtendedPropertiesOperation(ChangeExtendedPropertiesDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? ChangeExtendedPropertiesDilemmaHandler.getDefault() : dilemmaHandler);
        this.dilemmaHandler = dilemmaHandler == null ? ChangeExtendedPropertiesDilemmaHandler.getDefault() : dilemmaHandler;
        this.changeProperties = new HashMap();
    }

    @Override
    public void setProperties(IShareable shareable, Map<String, Object> properties, Set<String> removals) {
        if (shareable == null) {
            throw new IllegalArgumentException();
        }
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        IRelativeLocation path = shareable.getLocalPath();
        ChangeExtendedPropertiesRequest existingRequest = this.changeProperties.get(path);
        if (existingRequest == null) {
            this.changeProperties.put(path, new ChangeExtendedPropertiesRequest((Shareable)shareable, properties, removals));
        } else {
            existingRequest.setPropertyUpdates(properties, removals);
        }
    }

    public Map<String, IStatus> validateProperties(Map<String, Object> updatedProperties) {
        HashMap<String, IStatus> invalidProperties = new HashMap<String, IStatus>();
        for (Map.Entry<String, Object> entry : updatedProperties.entrySet()) {
            Object propertyValue;
            String propertyName = entry.getKey();
            IStatus status = this.validateProperty(propertyName, propertyValue = entry.getValue());
            if (status.isOK()) continue;
            invalidProperties.put(propertyName, status);
        }
        return invalidProperties;
    }

    public IStatus validateProperty(String propertyName, Object propertyValue) {
        IStatus status = this.validatePropertyName(propertyName);
        if (!status.isOK()) {
            return status;
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus validatePropertyName(String propertyName) {
        if (propertyName == null) {
            return new Status(4, "com.ibm.team.filesystem.client", Messages.ChangePropertiesOperation_2);
        }
        if (propertyName.length() > 256) {
            return new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.ChangePropertiesOperation_7, (Object)propertyName, (Object[])new Object[]{256}));
        }
        if (propertyName.length() == 0) {
            return new Status(4, "com.ibm.team.filesystem.client", Messages.ChangePropertiesOperation_8);
        }
        return Status.OK_STATUS;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.changeProperties.isEmpty()) {
            return;
        }
        ISchedulingRule rule = this.makeSchedulingRule((IProgressMonitor)progress.newChild(10));
        final List<IShareable> allShareables = this.getAffectedShareables();
        IRunnableWithProgress workspaceOp = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 + 8 * ChangeExtendedPropertiesOperation.this.changeProperties.size()));
                try {
                    if (ChangeExtendedPropertiesOperation.this.getRefreshBeforeRun()) {
                        int shareableSize = allShareables.size();
                        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)(shareableSize * 2));
                        monitor.setTaskName(Messages.ChangeHistoryChangeSetsOperation_REFRESHING_FILESYSTEM);
                        List<IShareable> shareables = ChangeSetRefreshUtils.rationalizeRefreshTree(allShareables);
                        for (IShareable shareable : shareables) {
                            ((Shareable)shareable).getFileStorage().refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)subProgress.newChild(1));
                        }
                        LocalChangeManager.getInstance().refreshChanges(shareables, (IProgressMonitor)subProgress.newChild(shareableSize));
                    }
                }
                catch (FileSystemException e) {
                    throw new InvocationTargetException((Throwable)((Object)e));
                }
                ICopyFileAreaManager.ICopyFileAreaLockRequestFactory factory = ICopyFileAreaManager.instance.lockRequestFactory();
                ICopyFileAreaLockRequest lockToObtain = factory.getLockRequest(allShareables);
                try {
                    ICopyFileAreasLock copyFileAreaRule = ICopyFileAreaManager.instance.lock(Collections.singleton(lockToObtain), (IProgressMonitor)subMonitor.newChild(1));
                    try {
                        try {
                            ChangeExtendedPropertiesOperation.this.updateProperties((IProgressMonitor)subMonitor.newChild(8 * ChangeExtendedPropertiesOperation.this.changeProperties.size()));
                        }
                        catch (TeamRepositoryException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        copyFileAreaRule.release((IProgressMonitor)subMonitor.newChild(1));
                    }
                }
                catch (FileSystemException e) {
                    throw new InvocationTargetException((Throwable)((Object)e));
                }
            }
        };
        this.runWithinFileSystemLock(workspaceOp, "Change Properties", rule, (IProgressMonitor)progress.newChild(90));
    }

    private List<IShareable> getAffectedShareables() {
        ArrayList<IShareable> shareables = new ArrayList<IShareable>();
        for (ChangeExtendedPropertiesRequest request : this.changeProperties.values()) {
            shareables.add(request.shareable);
        }
        return shareables;
    }

    private ISchedulingRule makeSchedulingRule(IProgressMonitor monitor) throws FileSystemException {
        List<IShareable> affected = this.getAffectedShareables();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)affected.size());
        HashSet<IShareable> shares = new HashSet<IShareable>();
        for (IShareable shareable : affected) {
            IShare share = shareable.getShare((IProgressMonitor)progress.newChild(1));
            if (share == null) continue;
            shares.add(share.getShareable());
        }
        return SharingManager.getInstance().makeSchedulingRuleForIDE(shares);
    }

    private void updateProperties(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.changeProperties.size() * 2 + 12));
        ArrayList<ChangeExtendedPropertiesRequest> invalidProperties = new ArrayList<ChangeExtendedPropertiesRequest>();
        for (ChangeExtendedPropertiesRequest request : this.changeProperties.values()) {
            this.checkCancelled((IProgressMonitor)progress);
            this.convert(request, invalidProperties, (IProgressMonitor)progress.newChild(1));
        }
        if (!invalidProperties.isEmpty()) {
            int result = this.dilemmaHandler.invalidProperties(invalidProperties, (IProgressMonitor)progress.newChild(1));
            if (result == 0) {
                for (ChangeExtendedPropertiesRequest request : invalidProperties) {
                    Map<String, IStatus> invalid = request.getInvalidProperties();
                    for (String propertyName : invalid.keySet()) {
                        request.propertyUpdates.remove(propertyName);
                    }
                    this.changeUserProperties(request, null, null, (IProgressMonitor)progress.newChild(1));
                }
            } else if (result != 1) {
                this.collectStatus(this.createInvalidPropertiesErrorStatus(invalidProperties));
                this.reportErrorsAsException(this.getErrors());
            } else {
                throw new OperationCanceledException();
            }
        }
    }

    private IStatus createInvalidPropertiesErrorStatus(ArrayList<ChangeExtendedPropertiesRequest> invalidProperties) {
        IStatus[] reportedBadProperties = new IStatus[invalidProperties.size()];
        int i = 0;
        for (ChangeExtendedPropertiesRequest request : invalidProperties) {
            reportedBadProperties[i] = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ChangePropertiesOperation_0, (Object)request.getShareableToChange().getLocalPath(), (Object[])new Object[0]));
            ++i;
        }
        return new MultiStatus("com.ibm.team.filesystem.client", 0, reportedBadProperties, Messages.ChangePropertiesOperation_1, null);
    }

    private void convert(ChangeExtendedPropertiesRequest request, ArrayList<ChangeExtendedPropertiesRequest> invalidProperties, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)22);
        try {
            ResourceType type = request.getShareableToChange().getResourceType((IProgressMonitor)progress.newChild(1));
            if (type == null) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_11, (Object)request.getShareableToChange().getFullPath().toString(), (Object[])new Object[0]), null));
                return;
            }
            IShare share = request.getShareableToChange().getShare((IProgressMonitor)progress.newChild(1));
            if (share == null) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_9, (Object)request.getShareableToChange().getFullPath().toString(), (Object[])new Object[0]), null));
                return;
            }
            ICopyFileArea copyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(request.shareable.getSandbox().getRoot());
            FileItemInfo oldInfo = copyFileArea.getItemInfo(request.shareable.getLocalPath());
            if (oldInfo == null) {
                String msg = NLS.bind((String)Messages.ChangeFilePropertiesOperation_1, (Object)request.getShareableToChange().getLocalPath().toString(), (Object[])new Object[0]);
                this.collectStatus(FileSystemStatusUtil.getStatusFor(4, msg, (Throwable)((Object)new FileSystemException(msg))));
                return;
            }
            progress.setTaskName(NLS.bind((String)Messages.ChangeFilePropertiesOperation_0, (Object)request.shareable.getLocalPath().toString(), (Object[])new Object[0]));
            if (request.isChangePropertiesRequest()) {
                this.changeUserProperties(request, invalidProperties, copyFileArea, (IProgressMonitor)progress.newChild(10));
            }
        }
        catch (FileSystemException e) {
            IStatus status = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_8, (Object)request.shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)((Object)e));
            this.collectStatus(status);
        }
    }

    private void changeUserProperties(ChangeExtendedPropertiesRequest request, ArrayList<ChangeExtendedPropertiesRequest> invalidProperties, ICopyFileArea copyFileArea, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IShare share = request.getShareableToChange().getShare((IProgressMonitor)monitor.newChild(1));
        if (copyFileArea == null) {
            copyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(request.shareable.getSandbox().getRoot());
            FileItemInfo oldInfo = copyFileArea.getItemInfo(request.shareable.getLocalPath());
            if (oldInfo == null) {
                String msg = NLS.bind((String)Messages.ChangeFilePropertiesOperation_1, (Object)request.getShareableToChange().getLocalPath().toString(), (Object[])new Object[0]);
                this.collectStatus(FileSystemStatusUtil.getStatusFor(4, msg, (Throwable)((Object)new FileSystemException(msg))));
                return;
            }
            if (share == null) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_9, (Object)request.getShareableToChange().getFullPath().toString(), (Object[])new Object[0]), null));
                return;
            }
        }
        if (!request.getInvalidProperties().isEmpty()) {
            if (invalidProperties != null) {
                invalidProperties.add(request);
            } else {
                this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ChangePropertiesOperation_0, (Object)request.getShareableToChange().getLocalPath(), (Object[])new Object[0])));
            }
        } else {
            ITeamRepository repo;
            assert (share != null);
            ISharingDescriptor descriptor = share.getSharingDescriptor();
            IVersionableHandle versionable = request.getShareableToChange().getVersionable((IProgressMonitor)monitor.newChild(15));
            if (versionable != null && (repo = RepositoryUtils.getTeamRepositoryById(descriptor.getRepositoryId())) != null) {
                IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                IVersionableHandle[] state = new IVersionableHandle[]{versionable};
                IItemCustomAttributes[] allAttrs = wm.getCustomAttributes(state, (IProgressMonitor)monitor.newChild(5));
                IItemCustomAttributes currentAttrs = allAttrs[0];
                if (request.propertyUpdates.size() > 0) {
                    currentAttrs.setAttributes(request.propertyUpdates);
                }
                if (request.removals.size() > 0) {
                    currentAttrs.removeAttributes(request.removals);
                }
                currentAttrs.saveCustomAttributes((IProgressMonitor)monitor.newChild(5));
            }
            request.propertyUpdates = null;
        }
    }

    @Override
    public void setRefreshBeforeRun(boolean newValue) {
        this.refreshBeforeRun = newValue;
    }

    @Override
    public boolean getRefreshBeforeRun() {
        return this.refreshBeforeRun;
    }

    private class ChangeExtendedPropertiesRequest
    implements IChangeExtendedPropertiesRequest {
        private final Shareable shareable;
        private Map<String, Object> propertyUpdates;
        private Set<String> removals;

        public ChangeExtendedPropertiesRequest(Shareable shareable, Map<String, Object> properties, Set<String> removals) {
            this.shareable = shareable;
            this.propertyUpdates = new HashMap<String, Object>(properties);
            this.removals = new HashSet<String>(removals);
        }

        @Override
        public IShareable getShareableToChange() {
            return this.shareable;
        }

        @Override
        public boolean isChangePropertiesRequest() {
            return this.propertyUpdates != null;
        }

        @Override
        public Map<String, IStatus> getInvalidProperties() {
            if (this.propertyUpdates == null || this.propertyUpdates.isEmpty()) {
                return Collections.EMPTY_MAP;
            }
            return ChangeExtendedPropertiesOperation.this.validateProperties(this.propertyUpdates);
        }

        public void setPropertyUpdates(Map<String, Object> properties, Set<String> removals) {
            this.propertyUpdates = new HashMap<String, Object>(properties);
            this.removals = new HashSet<String>(removals);
        }
    }
}

