/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.AbstractCurrentPortOperation;
import com.ibm.team.filesystem.client.internal.operations.UpdateCurrentPortOperation;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.IProcessAcceptQueueOperation;
import com.ibm.team.filesystem.client.operations.ProcessAcceptQueueDilemmaHandler;
import com.ibm.team.filesystem.common.IContentChangeDetail;
import com.ibm.team.filesystem.common.IEncodingChangeDetail;
import com.ibm.team.filesystem.common.ILineDelimiterChangeDetail;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ProcessPendingPortsOperation
extends AbstractCurrentPortOperation
implements IProcessAcceptQueueOperation {
    private int flags;

    public ProcessPendingPortsOperation(ProcessAcceptQueueDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? ProcessAcceptQueueDilemmaHandler.getDefault() : dilemmaHandler);
    }

    @Override
    protected String getOperationLabel() {
        return Messages.ProcessPendingPortsOperation_0;
    }

    @Override
    protected void doExecute(HashSet<ConfigurationFacade> configurationsToLock, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        if (configurationsToLock.size() > 0) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(configurationsToLock.size() * 3));
            for (ConfigurationFacade configurationFacade : configurationsToLock) {
                IWorkspaceConnection wc = (IWorkspaceConnection)configurationFacade.getCachedConnection();
                IComponentHandle componentHandle = configurationFacade.getComponentHandle();
                IUpdateReport report = wc.processAcceptQueue(componentHandle, this.getFlags(), (IProgressMonitor)progress.newChild(1));
                UpdateOperation updateOperation = new UpdateOperation(this.getConnection(), Collections.singletonList(report), 3, this.getUpdateDilemmaHandler(), null);
                this.disableVerifyInSync(updateOperation);
                updateOperation.run((IProgressMonitor)progress.newChild(1));
                boolean resolveContentChanges = (this.getFlags() & 1) != 0;
                if (!(resolveContentChanges |= (this.getFlags() & 2) != 0)) continue;
                UpdateCurrentPortOperation updateOp = (UpdateCurrentPortOperation)IOperationFactory.instance.getUpdateCurrentPortOperation(this.getProcessPendingPortDilemmaHandler().getUpdateCurrentPatchDilemmaHander());
                updateOp.setContext(this.getConnection(), this.getComponent());
                boolean hasChanges = updateOp.autoResolveChanges(IContentChangeDetail.class, true);
                if (!hasChanges) continue;
                updateOp.run((IProgressMonitor)progress.newChild(1));
                updateOp = (UpdateCurrentPortOperation)IOperationFactory.instance.getUpdateCurrentPortOperation(this.getProcessPendingPortDilemmaHandler().getUpdateCurrentPatchDilemmaHander());
                updateOp.setContext(this.getConnection(), this.getComponent());
                boolean hasMoreChanges = updateOp.autoResolveChanges(IEncodingChangeDetail.class, true);
                if (!(hasMoreChanges |= updateOp.autoResolveChanges(ILineDelimiterChangeDetail.class, true))) continue;
                updateOp.run((IProgressMonitor)progress.newChild(1));
            }
        }
    }

    @Override
    public void processAcceptQueue(IWorkspaceConnection connection, IComponentHandle componentHandle) {
        this.setContext(connection, componentHandle);
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public void setFlags(int flags) {
        this.flags = flags;
    }

    protected ProcessAcceptQueueDilemmaHandler getProcessPendingPortDilemmaHandler() {
        return (ProcessAcceptQueueDilemmaHandler)this.getDilemmaHandler();
    }
}

