/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest.util;

import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.rest.util.BackupUtil;
import com.ibm.team.filesystem.client.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxUpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.BackupInShedDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.SandboxUpdateDilemmaDTO;
import java.util.Collection;
import java.util.List;

public class SandboxUpdateDilemmaUtil {
    private ParmsSandboxUpdateDilemmaHandler sandboxUpdateDilemmaHandler;
    private SandboxUpdateDilemmaDTO sandboxUpdateDilemma;
    private BackupDilemmaHandler backupDilemmaHandler;
    private List<String> deletedContentLocations;
    private List<BackupInShedDTO> backupInShed;

    public SandboxUpdateDilemmaUtil(ParmsSandboxUpdateDilemmaHandler sandboxUpdateDilemmaHandler, SandboxUpdateDilemmaDTO sandboxUpdateDilemma) {
        this.sandboxUpdateDilemmaHandler = sandboxUpdateDilemmaHandler;
        this.sandboxUpdateDilemma = sandboxUpdateDilemma;
    }

    public SandboxUpdateDilemmaUtil(ParmsSandboxUpdateDilemmaHandler sandboxUpdateDilemmaHandler, List<BackupInShedDTO> backupInShed, List<String> deletedContentLocations) {
        this.sandboxUpdateDilemmaHandler = sandboxUpdateDilemmaHandler;
        this.backupInShed = backupInShed;
        this.deletedContentLocations = deletedContentLocations;
    }

    public BackupDilemmaHandler getBackupDilemmaHandler() {
        if (this.backupDilemmaHandler == null) {
            this.backupDilemmaHandler = this.sandboxUpdateDilemma != null ? BackupUtil.getBackupDilemmaHandler(this.sandboxUpdateDilemmaHandler == null ? null : this.sandboxUpdateDilemmaHandler.backupDilemmaHandler, this.sandboxUpdateDilemma == null ? null : this.sandboxUpdateDilemma.getBackedUpToShed()) : BackupUtil.getBackupDilemmaHandler(this.sandboxUpdateDilemmaHandler == null ? null : this.sandboxUpdateDilemmaHandler.backupDilemmaHandler, this.backupInShed);
        }
        return this.backupDilemmaHandler;
    }

    public int deletedContent(Collection<IShareable> contentDeleted) {
        if (this.sandboxUpdateDilemma != null) {
            for (IShareable shareable : contentDeleted) {
                this.sandboxUpdateDilemma.getDeletedContentShareables().add(CoreUtil.translateShareable(shareable));
            }
        } else if (this.deletedContentLocations != null) {
            for (IShareable shareable : contentDeleted) {
                this.deletedContentLocations.add(shareable.getFullPath().toOSString());
            }
        }
        if (this.sandboxUpdateDilemmaHandler == null || this.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler == null) {
            return 0;
        }
        return CoreUtil.getDilemmaInstruction(this.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler.deletedContentDirection, 0);
    }

    public int deletedContentLocation(Collection<ILocation> contentDeleted) {
        if (this.deletedContentLocations != null) {
            for (ILocation location : contentDeleted) {
                this.deletedContentLocations.add(location.toOSString());
            }
        }
        if (this.sandboxUpdateDilemmaHandler == null || this.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler == null) {
            return 0;
        }
        return CoreUtil.getDilemmaInstruction(this.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler.deletedContentDirection, 0);
    }
}

