/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_def.http;

import com.urbancode.air.i18n.TranslatableException;
import com.urbancode.air.property.prop_def.PropDefAllowedValue;
import com.urbancode.air.property.prop_def.http.HttpPropInfo;
import com.urbancode.air.property.prop_def.http.HttpRequestCallable;
import com.urbancode.air.property.prop_def.parser.JsonParser;
import com.urbancode.air.property.prop_def.parser.XmlParser;
import com.urbancode.commons.util.logging.LogUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpPropInfoHelper {
    static final Logger log = Logger.getLogger(HttpPropInfoHelper.class);
    private static ExecutorService executor = Executors.newCachedThreadPool();
    private Cache cache = CacheManager.getInstance().getCache("httpPropCache");

    public List<PropDefAllowedValue> getAllowedValues(HttpPropInfo info) {
        String rawData;
        List<PropDefAllowedValue> result = new ArrayList<PropDefAllowedValue>();
        try {
            rawData = this.getRawData(info);
        }
        catch (TimeoutException e) {
            throw new TranslatableException("Timed out while retrieving property data.", new Object[0]);
        }
        catch (Exception e) {
            throw new TranslatableException("An error occured while retrieving property data.", (Throwable)e, new Object[0]);
        }
        try {
            if (info.getFormat() == HttpPropInfo.HttpDataFormat.JSON) {
                result = JsonParser.parseJson(rawData, info);
            } else if (info.getFormat() == HttpPropInfo.HttpDataFormat.XML) {
                result = XmlParser.parseXml(rawData, info);
            }
        }
        catch (Exception e) {
            LogUtil.logTrace((Logger)log, (Object)"Retreiving properties from HTTP service failed", (Throwable)e);
        }
        return result;
    }

    String getRawData(HttpPropInfo info) throws Exception {
        String result = this.attemptRestoreFromCache(info);
        if (result == null) {
            HttpRequestCallable request = new HttpRequestCallable(info);
            Future<String> future = executor.submit(request);
            try {
                result = future.get(1L, TimeUnit.MINUTES);
            }
            catch (TimeoutException e) {
                future.cancel(true);
                throw e;
            }
            this.cache(info, result);
        }
        return result;
    }

    private String attemptRestoreFromCache(HttpPropInfo info) {
        Element element;
        String result = null;
        if (this.cache != null && (element = this.cache.get((Serializable)((Object)info.getCacheKey()))) != null) {
            result = (String)((Object)element.getValue());
        }
        return result;
    }

    private void cache(HttpPropInfo info, String data) {
        if (this.cache != null) {
            this.cache.put(new Element((Serializable)((Object)info.getCacheKey()), (Serializable)((Object)data)));
        }
    }
}

