/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_sheet;

import com.urbancode.air.property.persistence.AbstractPropertyFactory;
import com.urbancode.air.property.prop_sheet.PropSheet;
import com.urbancode.air.property.prop_sheet.PropSheetFactory;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import com.urbancode.air.property.prop_sheet_group.PropSheetGroup;
import com.urbancode.air.vc.Handle;
import com.urbancode.air.vc.Persistent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropSheetFactoryImpl
extends AbstractPropertyFactory<PropSheet>
implements PropSheetFactory {
    @Override
    public PropSheet createPropSheet(PropSheetGroup group, String name) {
        return this.createDBPropSheet(group, name, null, null, null);
    }

    @Override
    public PropSheet createPropSheet(PropSheetGroup group, PropSheet template, Map<String, String> properties) {
        return this.createDBPropSheet(group, null, template, null, properties);
    }

    @Override
    public PropSheet createPropSheet(PropSheetGroup group, PropSheetDef propSheetDef, Map<String, String> properties) {
        return this.createDBPropSheet(group, null, null, propSheetDef, properties);
    }

    @Override
    public PropSheet createVersionedPropSheet(String path, PropSheetGroup group, String name) {
        return this.createVersionedPropSheet(path, group, name, null, null, null);
    }

    @Override
    public PropSheet createVersionedPropSheet(String path, PropSheetGroup group, PropSheet template, Map<String, String> properties) {
        return this.createVersionedPropSheet(path, group, null, template, null, properties);
    }

    @Override
    public PropSheet createVersionedPropSheet(String path, PropSheetGroup group, PropSheetDef propSheetDef, Map<String, String> properties) {
        return this.createVersionedPropSheet(path, group, null, null, propSheetDef, properties);
    }

    private PropSheet createDBPropSheet(PropSheetGroup group, String name, PropSheet template, PropSheetDef propSheetDef, Map<String, String> properties) {
        PropSheet result = this.createGenericPropSheet(null, group, name, template, propSheetDef, properties);
        this.getDBSession().save((Object)result);
        return result;
    }

    private PropSheet createVersionedPropSheet(String path, PropSheetGroup group, String name, PropSheet template, PropSheetDef propSheetDef, Map<String, String> properties) {
        if (group != null && group.isVersioned()) {
            path = group.getPersistenceData().getPath() + "/propSheets/{id}";
        }
        PropSheet result = this.createGenericPropSheet(path, group, name, template, propSheetDef, properties);
        this.getVCSession().saveOrUpdate((Persistent)result);
        return result;
    }

    private PropSheet createGenericPropSheet(String path, PropSheetGroup group, String name, PropSheet template, PropSheetDef propSheetDef, Map<String, String> properties) {
        PropSheet result = new PropSheet();
        if (path != null) {
            path = path.replace("{id}", result.getId().toString());
            result.getPersistenceData().setPath(path);
        }
        if (group != null) {
            group.addPropSheet(result);
        }
        if (template != null) {
            result.setTemplate(template);
        } else if (propSheetDef != null) {
            result.setPropSheetDef(propSheetDef);
            result.setDefaultPropertiesFromPropSheetDef();
        } else if (name != null) {
            result.setName(name);
        }
        if (properties != null) {
            result.setPropValues(properties);
        }
        return result;
    }

    @Override
    public PropSheet getPropSheetForId(UUID id) {
        PropSheet result = null;
        try {
            result = (PropSheet)((Object)this.getEntityForId(PropSheet.class, id, "PropSheet"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public PropSheet getPropSheetForHandle(Handle handle) {
        return (PropSheet)((Object)this.restore(handle));
    }

    @Override
    public List<PropSheet> getPropSheetsForPropSheetDef(PropSheetDef propSheetDef) {
        Criteria criteria = this.getDBSession().createCriteria(PropSheet.class);
        criteria.add((Criterion)Restrictions.eq((String)"propSheetDef", (Object)((Object)propSheetDef)));
        return criteria.list();
    }

    @Override
    public List<PropSheet> getPropSheetsForTemplate(PropSheet templatePropSheet) {
        Criteria criteria = this.getDBSession().createCriteria(PropSheet.class);
        Handle handle = new Handle((Persistent)templatePropSheet);
        criteria.add((Criterion)Restrictions.eq((String)"templateHandleString", (Object)handle.toString()));
        return criteria.list();
    }

    @Override
    public List<PropSheet> getPropSheetsForPaths(List<String> paths, boolean skipVersionCount) {
        return this.restoreLatestWithPaths(paths, skipVersionCount);
    }

    @Override
    public List<PropSheet> getPropSheetsForHandles(List<Handle> handles) {
        return this.restoreWithHandles(handles, true);
    }

    @Override
    public Map<Handle, PropSheet> restoreWithHandlesIntoMap(Collection<Handle> handles) {
        return this.restoreWithHandlesIntoMap(handles, true);
    }

    @Override
    public void deletePropSheet(PropSheet propSheet) {
        if (propSheet.isVersioned()) {
            propSheet.getPersistenceData().setDeleted(true);
        } else {
            this.getDBSession().delete((Object)propSheet);
        }
    }
}

