/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProcessContainerHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.internal.model.ConfigurationItem;
import com.ibm.team.workitem.common.internal.util.AuditablesHelper;
import com.ibm.team.workitem.common.internal.util.CacheHelper;
import com.ibm.team.workitem.common.internal.util.Utils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class ConfigurationItemManager<T extends ConfigurationItem>
extends CacheHelper {
    private final IAuditableCommon fAuditableCommon;
    private final Map<UUID, Map<String, T>> fIdentifierCache = new ConcurrentHashMap<UUID, Map<String, T>>(8, 0.9f, 1);
    private final Map<UUID, List<T>> fListCache = new ConcurrentHashMap<UUID, List<T>>(8, 0.9f, 1);

    public ConfigurationItemManager(IAuditableCommon auditableCommon) {
        super(auditableCommon);
        this.fAuditableCommon = auditableCommon;
    }

    public List<T> findConfigurationItems(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, monitor);
        List<T> cache = this.findCachedConfigurationItems(projectArea);
        return cache != null ? cache : Collections.emptyList();
    }

    public List<T> findCachedConfigurationItems(IProjectAreaHandle projectArea) {
        if (AuditablesHelper.ENFORCE_PROJECT_AREA_NOT_NULL) {
            Assert.isTrue((projectArea != null ? 1 : 0) != 0);
        }
        if (projectArea == null) {
            return Collections.emptyList();
        }
        List<T> configurationItems = this.fListCache.get(projectArea.getItemId());
        if (configurationItems == null) {
            return null;
        }
        return new ArrayList<T>(configurationItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T findConfigurationItem(IProjectAreaHandle projectArea, String identifier, IProgressMonitor monitor) throws TeamRepositoryException {
        Object object = this.getUpdateLock(projectArea);
        synchronized (object) {
            this.checkCache(projectArea, monitor);
            return this.findCachedConfigurationItem(projectArea, identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T findCachedConfigurationItem(IProjectAreaHandle projectArea, String identifier) {
        Object object = this.getUpdateLock(projectArea);
        synchronized (object) {
            Map<String, T> configurationItems;
            block7: {
                block6: {
                    if (AuditablesHelper.ENFORCE_PROJECT_AREA_NOT_NULL) {
                        Assert.isTrue((projectArea != null ? 1 : 0) != 0);
                    }
                    if (projectArea != null) break block6;
                    return null;
                }
                configurationItems = this.fIdentifierCache.get(projectArea.getItemId());
                if (configurationItems != null) break block7;
                return null;
            }
            return (T)((ConfigurationItem)configurationItems.get(identifier));
        }
    }

    @Override
    protected void doFlushCache(IProjectAreaHandle projectArea) {
        this.fIdentifierCache.remove(projectArea.getItemId());
        this.fListCache.remove(projectArea.getItemId());
    }

    @Override
    protected void updateCache(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        this.readConfigurationItems(projectAreaHandle, monitor);
    }

    protected void readConfigurationItems(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<String, ConfigurationItem> configurationItemsMap = new HashMap<String, ConfigurationItem>();
        ArrayList<ConfigurationItem> configurationItemsList = new ArrayList<ConfigurationItem>();
        IProcessConfigurationData processConfiguration = this.resolveProcessConfiguration(projectArea, monitor);
        if (processConfiguration != null) {
            this.readConfigurationItems(configurationItemsMap, configurationItemsList, projectArea, processConfiguration, monitor);
        }
        for (ConfigurationItem configurationItem : this.readStaticConfigurationItems(projectArea, monitor)) {
            if (configurationItemsMap.containsKey(configurationItem.getIdentifier())) continue;
            configurationItemsMap.put(configurationItem.getIdentifier(), configurationItem);
            configurationItemsList.add(configurationItem);
        }
        this.fIdentifierCache.put(projectArea.getItemId(), configurationItemsMap);
        this.fListCache.put(projectArea.getItemId(), configurationItemsList);
    }

    protected IProcessConfigurationData resolveProcessConfiguration(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableCommonProcess process = this.fAuditableCommon.getProcess((IProcessAreaHandle)projectArea, monitor);
        return process.findProcessConfiguration(this.getConfigurationDataPoint(), monitor);
    }

    private void readConfigurationItems(Map<String, T> configurationItemsMap, List<T> configurationItemsList, IProjectAreaHandle projectArea, IProcessConfigurationData processConfiguration, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessConfigurationElement[] iProcessConfigurationElementArray = processConfiguration.getElements();
        int n = iProcessConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessConfigurationElement configurationElement = iProcessConfigurationElementArray[n2];
            String groupElement = this.getGroupElement();
            if (groupElement != null && groupElement.equals(configurationElement.getName())) {
                IProcessConfigurationElement[] iProcessConfigurationElementArray2 = configurationElement.getChildren();
                int n3 = iProcessConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProcessConfigurationElement childElement = iProcessConfigurationElementArray2[n4];
                    if (this.getElement().equals(childElement.getName())) {
                        this.readConfigurationItem(configurationItemsMap, configurationItemsList, projectArea, childElement, monitor);
                    }
                    ++n4;
                }
            } else if (this.getElement().equals(configurationElement.getName())) {
                this.readConfigurationItem(configurationItemsMap, configurationItemsList, projectArea, configurationElement, monitor);
            }
            ++n2;
        }
    }

    private void readConfigurationItem(Map<String, T> configurationItemsMap, List<T> configurationItemsList, IProjectAreaHandle projectArea, IProcessConfigurationElement childElement, IProgressMonitor monitor) throws TeamRepositoryException {
        T configurationItem = this.readElement(projectArea, childElement, configurationItemsList.size(), monitor);
        if (configurationItem != null) {
            configurationItemsMap.put(((ConfigurationItem)configurationItem).getIdentifier(), configurationItem);
            configurationItemsList.add(configurationItem);
        }
    }

    protected URL createResourceURL(IProjectAreaHandle projectArea, String icon, IProgressMonitor monitor) {
        return Utils.createResourceURL(this.getAuditableCommon(), (IProcessContainerHandle)projectArea, icon, monitor);
    }

    @Override
    protected IAuditableCommon getAuditableCommon() {
        return this.fAuditableCommon;
    }

    protected List<T> readStaticConfigurationItems(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return Collections.emptyList();
    }

    protected abstract String getConfigurationDataPoint();

    protected abstract String getGroupElement();

    protected abstract String getElement();

    protected abstract T readElement(IProjectAreaHandle var1, IProcessConfigurationElement var2, int var3, IProgressMonitor var4) throws TeamRepositoryException;
}

