/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.RepositoryPackage;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.QueryIterator;
import com.ibm.team.workitem.common.internal.Messages;
import com.ibm.team.workitem.common.internal.model.ModelPackage;
import com.ibm.team.workitem.common.internal.util.CategoriesManager;
import com.ibm.team.workitem.common.internal.util.CategoryTreeNode;
import com.ibm.team.workitem.common.internal.util.EMFHelper;
import com.ibm.team.workitem.common.internal.util.WorkItemQueries;
import com.ibm.team.workitem.common.internal.workflow.WorkflowManager;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.CategoryId;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IDeliverable;
import com.ibm.team.workitem.common.model.IDeliverableHandle;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IResolution;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class CopyToProjectOperation {
    private static final Set<String> SKIP_ATTRIBUTES = new HashSet<String>(Arrays.asList(IWorkItem.ID_PROPERTY, IWorkItem.PROJECT_AREA_PROPERTY, IWorkItem.TYPE_PROPERTY, IWorkItem.STATE_PROPERTY, IWorkItem.RESOLUTION_PROPERTY, IWorkItem.WORKFLOW_SURROGATE_PROPERTY, IWorkItem.MODIFIED_PROPERTY, IWorkItem.MODIFIED_BY_PROPERTY, IWorkItem.CUSTOM_ATTRIBUTES_PROPERTY, IItem.CONTEXT_ID_PROPERTY, IWorkItem.CREATION_DATE_PROPERTY));
    private static final Set<String> COPY_HELPER_TYPES = new HashSet<String>(Arrays.asList("comments", "approvalDescriptors", "approvals", "stateTransitions"));
    private static final Set<String> COPY_ITEM_TYPES = new HashSet<String>(Arrays.asList("contributor", "subscriptions", "tags", "uuid"));
    protected static final List<EStructuralFeature> EXCLUDE_ON_MOVE = new ArrayList<EStructuralFeature>();
    private final IProjectAreaHandle fTargetArea;
    private final boolean fCommitChanges;
    private final boolean fMove;
    private final boolean fResolveSource;
    private final boolean fMoveAttachments;
    private final boolean fCopyAttachments;
    private final String fName;
    private final Set<UUID> fWorkItemsToCopy = new HashSet<UUID>();
    private final List<CopyProblem> fCopyProblems = new ArrayList<CopyProblem>();
    private final List<IWorkItem> fCopies = new ArrayList<IWorkItem>();

    static {
        EXCLUDE_ON_MOVE.add((EStructuralFeature)ModelPackage.eINSTANCE.getWorkItem_Id());
        EXCLUDE_ON_MOVE.addAll((Collection<EStructuralFeature>)RepositoryPackage.eINSTANCE.getAuditable().getEAllStructuralFeatures());
        for (String property : IWorkItem.CUSTOM_ATTRIBUTE_PROPERTIES) {
            EXCLUDE_ON_MOVE.remove(RepositoryPackage.eINSTANCE.getAuditable().getEStructuralFeature(property));
        }
        EXCLUDE_ON_MOVE.remove(RepositoryPackage.eINSTANCE.getItem_ContextId());
        EXCLUDE_ON_MOVE.add((EStructuralFeature)ModelPackage.eINSTANCE.getWorkItem_CreationDate());
    }

    public CopyToProjectOperation(String name, IProjectAreaHandle targetArea, boolean commitChanges, boolean move, boolean resolveSource, boolean moveAttachments, boolean copyAttachments) {
        this.fTargetArea = targetArea;
        this.fCommitChanges = commitChanges;
        this.fMove = move;
        this.fResolveSource = resolveSource;
        this.fMoveAttachments = moveAttachments;
        this.fCopyAttachments = copyAttachments;
        this.fName = name;
    }

    /*
     * WARNING - void declaration
     */
    public void run(List<? extends IWorkItem> sourceWorkItems, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        for (IWorkItem iWorkItem : sourceWorkItems) {
            this.fWorkItemsToCopy.add(iWorkItem.getItemId());
        }
        for (IWorkItem iWorkItem : sourceWorkItems) {
            void var4_9;
            if (iWorkItem == null) continue;
            if (!iWorkItem.isComplete()) {
                IWorkItem iWorkItem2 = workItemCommon.getAuditableCommon().resolveAuditable(iWorkItem, IWorkItem.FULL_PROFILE, monitor);
            }
            this.execute((IWorkItem)var4_9, workItemCommon, (IProgressMonitor)(monitor != null ? new SubProgressMonitor(monitor, 1) : null));
        }
    }

    public String getName() {
        return this.fName;
    }

    protected abstract void commit(IWorkItem var1, IWorkItem var2, IWorkItemCommon var3, IProgressMonitor var4) throws TeamRepositoryException;

    protected abstract IWorkItem createNewWorkItem(IWorkItemType var1, IWorkItemCommon var2, IProgressMonitor var3) throws TeamRepositoryException;

    protected abstract IWorkItemReferences getWorkItemReferences(IWorkItem var1, IWorkItemCommon var2, IProgressMonitor var3) throws TeamRepositoryException;

    protected void execute(IWorkItem sourceWorkItem, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        if (sourceWorkItem.getProjectArea().sameItemId((IItemHandle)this.fTargetArea)) {
            this.fCopyProblems.add(new CopyProblem(Messages.getString("CopyToProjectOperation.MOVE_COPY_TO_SAME_PA_NOT_SUPPORTED")));
            return;
        }
        String sourceTypeIdentifier = sourceWorkItem.getWorkItemType();
        IWorkItemType type = workItemCommon.findWorkItemType(this.fTargetArea, sourceTypeIdentifier, monitor);
        if (type == null) {
            IWorkItemType sourceType = workItemCommon.findWorkItemType(sourceWorkItem.getProjectArea(), sourceTypeIdentifier, monitor);
            IAttribute targetAttribute = workItemCommon.findAttribute(this.fTargetArea, IWorkItem.TYPE_PROPERTY, monitor);
            this.fCopyProblems.add(new CopyProblem(NLS.bind((String)Messages.getString("CopyToProjectOperation.VALUE_NOTFOUND_FOR_ATTRIBUTE"), (Object)targetAttribute.getDisplayName(), (Object[])new Object[]{sourceType != null ? sourceType.getDisplayName() : sourceTypeIdentifier})));
            List<IWorkItemType> workItemTypes = workItemCommon.findWorkItemTypes(this.fTargetArea, monitor);
            Assert.isTrue((!workItemTypes.isEmpty() ? 1 : 0) != 0);
            type = workItemTypes.get(0);
        }
        IWorkItem targetWorkItem = this.createNewWorkItem(type, workItemCommon, monitor);
        this.copyWorkFlow(sourceWorkItem, targetWorkItem, workItemCommon, monitor);
        if (!sourceWorkItem.getContextId().equals((Object)sourceWorkItem.getProjectArea().getItemId())) {
            targetWorkItem.setContextId(sourceWorkItem.getContextId());
        }
        List<IAttribute> sourceAttributes = this.resolveAttributes(sourceWorkItem, workItemCommon, monitor);
        List<IAttribute> targetAttributes = workItemCommon.findAttributes(this.fTargetArea, monitor);
        for (IAttribute sourceAttribute : sourceAttributes) {
            if (SKIP_ATTRIBUTES.contains(sourceAttribute.getIdentifier())) continue;
            String attributeType = sourceAttribute.getAttributeType();
            if (!this.isSupportedType(attributeType)) {
                this.fCopyProblems.add(new CopyProblem(NLS.bind((String)Messages.getString("CopyToProjectOperation.ATTRIBUTE_TYPE_NOT_SUPPORTED"), (Object)sourceAttribute.getDisplayName(), (Object[])new Object[0])));
                continue;
            }
            IAttribute targetAttribute = this.findTargetAttribute(targetAttributes, sourceAttribute);
            if (targetAttribute == null) {
                this.fCopyProblems.add(new CopyProblem(NLS.bind((String)Messages.getString("CopyToProjectOperation.ATTRIBUTE_NOT_FOUND"), (Object)sourceAttribute.getDisplayName(), (Object[])new Object[0])));
                continue;
            }
            if ("category".equals(attributeType)) {
                this.copyCategory(sourceWorkItem, sourceAttribute, targetWorkItem, targetAttribute, workItemCommon, monitor);
                continue;
            }
            if ("interval".equals(attributeType)) {
                this.copyIteration(sourceWorkItem, sourceAttribute, targetWorkItem, targetAttribute, workItemCommon, monitor);
                continue;
            }
            if ("deliverable".equals(attributeType)) {
                this.copyDeliverable(sourceWorkItem, sourceAttribute, targetWorkItem, targetAttribute, workItemCommon, monitor);
                continue;
            }
            if (AttributeTypes.isEnumerationAttributeType(attributeType)) {
                this.copyEnumerationAttribute(sourceWorkItem, sourceAttribute, targetWorkItem, targetAttribute, workItemCommon, monitor);
                continue;
            }
            if (AttributeTypes.isEnumerationListAttributeType(attributeType)) {
                this.copyEnumerationListAttribute(sourceWorkItem, sourceAttribute, targetWorkItem, targetAttribute, workItemCommon, monitor);
                continue;
            }
            if (COPY_HELPER_TYPES.contains(attributeType)) {
                this.copyHelperAttribute(sourceWorkItem, sourceAttribute, targetWorkItem, targetAttribute);
                continue;
            }
            if (AttributeTypes.isPrimitiveAttributeType(attributeType) || COPY_ITEM_TYPES.contains(attributeType)) {
                this.copySimpleAttribute(sourceWorkItem, sourceAttribute, targetWorkItem, targetAttribute);
                continue;
            }
            if (sourceAttribute.isBuiltIn() || !AttributeTypes.isItemAttributeType(attributeType) && !AttributeTypes.isItemListAttributeType(attributeType)) continue;
            this.copySimpleAttribute(sourceWorkItem, sourceAttribute, targetWorkItem, targetAttribute);
        }
        this.copyReferences(workItemCommon, this.getWorkItemReferences(sourceWorkItem, workItemCommon, monitor), this.getWorkItemReferences(targetWorkItem, workItemCommon, monitor), monitor);
        if (this.fMoveAttachments) {
            this.handleAttachments(sourceWorkItem, targetWorkItem, workItemCommon, monitor);
        }
        if (!this.fMove) {
            this.dropVotes(monitor, targetWorkItem, workItemCommon);
        }
        if (this.fCommitChanges) {
            this.commit(sourceWorkItem, targetWorkItem, workItemCommon, monitor);
        }
    }

    private void dropVotes(IProgressMonitor monitor, IWorkItem workItem, IWorkItemCommon wiCommon) throws TeamRepositoryException {
        IAttribute votersListAttr = wiCommon.findAttribute(workItem.getProjectArea(), "com.ibm.team.workitem.attribute.voting.upvoters", monitor);
        IAttribute votesCountAttr = wiCommon.findAttribute(workItem.getProjectArea(), "com.ibm.team.workitem.attribute.voting.score", monitor);
        if (votersListAttr != null && workItem.hasAttribute(votersListAttr)) {
            Collection voterList = (Collection)workItem.getValue(votersListAttr);
            if (voterList != null && !voterList.isEmpty()) {
                this.fCopyProblems.add(new CopyProblem(Messages.getString("CopyToProjectOperation.CLEARING_VOTERS_LIST")));
            }
            workItem.setValue(votersListAttr, Collections.EMPTY_LIST);
        }
        if (votesCountAttr != null && workItem.hasAttribute(votesCountAttr)) {
            workItem.setValue(votesCountAttr, 0);
        }
    }

    private boolean isSupportedType(String attributeType) {
        if ("category".equals(attributeType) || "interval".equals(attributeType)) {
            return true;
        }
        if (AttributeTypes.isEnumerationAttributeType(attributeType) || AttributeTypes.isPrimitiveAttributeType(attributeType)) {
            return true;
        }
        if (COPY_HELPER_TYPES.contains(attributeType) || COPY_ITEM_TYPES.contains(attributeType)) {
            return true;
        }
        if (AttributeTypes.isItemAttributeType(attributeType) || AttributeTypes.isItemListAttributeType(attributeType)) {
            return true;
        }
        return AttributeTypes.isEnumerationListAttributeType(attributeType);
    }

    private List<IAttribute> resolveAttributes(IWorkItem sourceWorkItem, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IAttributeHandle> handles = new ArrayList<IAttributeHandle>();
        handles.addAll(workItemCommon.findBuiltInAttributes(sourceWorkItem.getProjectArea(), monitor));
        handles.addAll(sourceWorkItem.getCustomAttributes());
        return workItemCommon.getAuditableCommon().resolveAuditablesPermissionAware(handles, IAttribute.FULL_PROFILE, monitor);
    }

    private IAttribute findTargetAttribute(List<IAttribute> targetAttributes, IAttribute sourceAttribute) {
        for (IAttribute current : targetAttributes) {
            if (!current.getIdentifier().equals(sourceAttribute.getIdentifier()) || !current.getAttributeType().equals(sourceAttribute.getAttributeType())) continue;
            return current;
        }
        return null;
    }

    protected void copyWorkFlow(IWorkItem sourceWorkItem, IWorkItem targetWorkItem, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        boolean resolutionExists;
        WorkflowManager workflowManager = (WorkflowManager)workItemCommon.getWorkflowManager();
        IWorkItemType targetType = workItemCommon.findWorkItemType(targetWorkItem.getProjectArea(), targetWorkItem.getWorkItemType(), monitor);
        String workflowId = targetType != null ? workflowManager.getWorkflowIdForCategory(targetWorkItem.getProjectArea(), targetType.getCategory(), false, monitor) : null;
        IWorkflowInfo targetInfo = workflowId != null ? workflowManager.getWorkflowInfo(targetWorkItem.getProjectArea(), workflowId, false, monitor) : null;
        IWorkflowInfo sourceInfo = workItemCommon.findWorkflowInfo(sourceWorkItem, monitor);
        if (targetInfo != null && !sourceInfo.getIdentifier().equals(targetInfo.getIdentifier())) {
            this.fCopyProblems.add(new CopyProblem(NLS.bind((String)Messages.getString("CopyToProjectOperation.WORKFLOW_DIFFERS"), (Object)targetInfo.getName(), (Object[])new Object[]{sourceInfo.getName()})));
            return;
        }
        Identifier<IState> state = sourceWorkItem.getState2();
        Identifier<IResolution> resolution = sourceWorkItem.getResolution2();
        boolean stateExists = state == null || targetInfo != null && Arrays.asList(targetInfo.getAllStateIds()).contains(state);
        boolean bl = resolutionExists = resolution == null || "0".equals(resolution.getStringIdentifier()) || targetInfo != null && Arrays.asList(targetInfo.getAllResolutionIds()).contains(resolution);
        if (!(stateExists && resolutionExists || sourceWorkItem.getId() == -1)) {
            String sta = "";
            String res = "";
            String act = "";
            if (!stateExists) {
                String stateName = null;
                if (sourceInfo != null) {
                    stateName = sourceInfo.getStateName(state);
                }
                if (stateName == null) {
                    stateName = state != null ? state.getStringIdentifier() : Messages.getString("CopyToProjectOperation.STATE_NONE");
                }
                sta = NLS.bind((String)Messages.getString("CopyToProjectOperation.STATE_NOT_FOUND"), (Object)Messages.getString("CopyToProjectOperation.STATE"), (Object[])new Object[]{stateName});
            }
            if (!resolutionExists) {
                String resolutionName = null;
                if (sourceInfo != null) {
                    resolutionName = sourceInfo.getResolutionName(resolution);
                }
                if (resolutionName == null) {
                    resolutionName = resolution != null ? resolution.getStringIdentifier() : Messages.getString("CopyToProjectOperation.RESOLUTION_NONE");
                }
                res = NLS.bind((String)Messages.getString("CopyToProjectOperation.RESOLUTION_NOT_FOUND"), (Object)Messages.getString("CopyToProjectOperation.RESOLUTION"), (Object[])new Object[]{resolutionName});
            }
            String message = String.valueOf(Messages.getString("CopyToProjectOperation.WORKFLOW_DOES_NOT_MATCH")) + sta + res + act;
            this.fCopyProblems.add(new CopyProblem(message));
        } else {
            targetWorkItem.setState2(state);
            targetWorkItem.setResolution2(resolution);
        }
    }

    private void copyCategory(IWorkItem sourceWorkItem, IAttribute sourceAttribute, IWorkItem targetWorkItem, IAttribute targetAttribute, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        ICategoryHandle sourceValue = (ICategoryHandle)sourceWorkItem.getValue(sourceAttribute);
        ICategoryHandle targetValue = this.findTargetCategory(targetWorkItem.getProjectArea(), sourceWorkItem, sourceValue, workItemCommon, monitor);
        if (targetValue != null) {
            this.setValue(targetWorkItem, targetAttribute, targetValue);
        } else {
            String name = workItemCommon.resolveHierarchicalName(sourceValue, monitor);
            this.fCopyProblems.add(new CopyProblem(NLS.bind((String)Messages.getString("CopyToProjectOperation.VALUE_NOTFOUND_FOR_ATTRIBUTE"), (Object)targetAttribute.getDisplayName(), (Object[])new Object[]{name})));
        }
    }

    private ICategoryHandle findTargetCategory(IProjectAreaHandle targetProjectArea, IWorkItem sourceWorkItem, ICategoryHandle sourceCategoryHandle, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<String> namePath = new ArrayList<String>();
        ICategory sourceCategory = workItemCommon.getAuditableCommon().resolveAuditable(sourceCategoryHandle, ICategory.SMALL_PROFILE, monitor);
        while (sourceCategory != null && sourceCategory.getParentId2() != null) {
            namePath.add(0, sourceCategory.getName());
            sourceCategory = this.findParentCategory(sourceCategory, workItemCommon, monitor);
        }
        CategoriesManager manager = CategoriesManager.createInstance(workItemCommon.getAuditableCommon(), false, targetProjectArea, monitor);
        CategoryTreeNode node = manager.getRoot();
        for (String name : namePath) {
            boolean found = false;
            for (CategoryTreeNode child : node.getChildren()) {
                if (!child.getName().equals(name)) continue;
                node = child;
                found = true;
                break;
            }
            if (found) continue;
            this.fCopyProblems.add(new CopyProblem(NLS.bind((String)Messages.getString("CopyToProjectOperation.CATEGORY_WILL_BE_MAPPED"), (Object)workItemCommon.resolveHierarchicalName(sourceCategoryHandle, monitor), (Object[])new Object[]{workItemCommon.resolveHierarchicalName(node.getCategory(), monitor)})));
            break;
        }
        return node != null ? node.getCategory() : null;
    }

    private ICategory findParentCategory(ICategory category, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        CategoryId parentId = category.getParentId2();
        if (parentId == null) {
            return null;
        }
        List<ICategory> cached = workItemCommon.getAuditableCommon().findAllCachedAuditables(ICategory.SMALL_PROFILE);
        for (ICategory cache : cached) {
            if (!parentId.equals(cache.getCategoryId())) continue;
            return cache;
        }
        QueryIterator<ICategoryHandle> iter = WorkItemQueries.categoryByIdentifier(workItemCommon.getAuditableCommon(), category.getProjectArea(), parentId);
        try {
            if (!iter.hasNext(monitor)) {
                return null;
            }
            ICategory iCategory = workItemCommon.getAuditableCommon().resolveAuditable(iter.next(monitor), ICategory.SMALL_PROFILE, monitor);
            return iCategory;
        }
        finally {
            iter.close();
        }
    }

    private void copyDeliverable(IWorkItem sourceWorkItem, IAttribute sourceAttribute, IWorkItem targetWorkItem, IAttribute targetAttribute, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        IDeliverableHandle sourceValue = (IDeliverableHandle)sourceWorkItem.getValue(sourceAttribute);
        if (sourceValue != null) {
            IDeliverableHandle targetValue = this.findTargetDeliverable(targetWorkItem.getProjectArea(), sourceWorkItem, sourceValue, workItemCommon, monitor);
            if (targetValue != null) {
                this.setValue(targetWorkItem, targetAttribute, targetValue);
            } else {
                IDeliverable deliverable = workItemCommon.getAuditableCommon().resolveAuditable(sourceValue, IDeliverable.DEFAULT_PROFILE, monitor);
                this.fCopyProblems.add(new CopyProblem(NLS.bind((String)Messages.getString("CopyToProjectOperation.VALUE_NOTFOUND_FOR_ATTRIBUTE"), (Object)targetAttribute.getDisplayName(), (Object[])new Object[]{deliverable.getName()})));
            }
        } else {
            this.setValue(targetWorkItem, targetAttribute, null);
        }
    }

    private IDeliverableHandle findTargetDeliverable(IProjectAreaHandle targetProjectAreaHandle, IWorkItem sourceWorkItem, IDeliverableHandle sourceValue, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        IDeliverable sourceDeliverable = workItemCommon.getAuditableCommon().resolveAuditable(sourceValue, IDeliverable.DEFAULT_PROFILE, monitor);
        List<IDeliverable> candidates = workItemCommon.findDeliverablesByProjectArea(targetProjectAreaHandle, false, IDeliverable.DEFAULT_PROFILE, monitor);
        for (IDeliverable deliverable : candidates) {
            if (!sourceDeliverable.getName().equals(deliverable.getName())) continue;
            return (IDeliverableHandle)deliverable.getItemHandle();
        }
        return null;
    }

    private void copyIteration(IWorkItem sourceWorkItem, IAttribute sourceAttribute, IWorkItem targetWorkItem, IAttribute targetAttribute, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        IIterationHandle sourceValue = (IIterationHandle)sourceWorkItem.getValue(sourceAttribute);
        if (sourceValue != null) {
            IIterationHandle iteration = this.findTargetIteration(targetWorkItem.getProjectArea(), sourceValue, workItemCommon, monitor);
            if (iteration != null) {
                this.setValue(targetWorkItem, targetAttribute, iteration);
            } else {
                IIteration sourceIteration = workItemCommon.getAuditableCommon().resolveAuditable((IAuditableHandle)sourceValue, ItemProfile.ITERATION_DEFAULT, monitor);
                this.fCopyProblems.add(new CopyProblem(NLS.bind((String)Messages.getString("CopyToProjectOperation.VALUE_NOTFOUND_FOR_ATTRIBUTE"), (Object)targetAttribute.getDisplayName(), (Object[])new Object[]{sourceIteration.getLabel()})));
            }
        } else {
            this.setValue(targetWorkItem, targetAttribute, null);
        }
    }

    private IIterationHandle findTargetIteration(IProjectAreaHandle targetProjectAreaHandle, IIterationHandle sourceIterationHandle, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea targetProjectArea = workItemCommon.getAuditableCommon().resolveAuditable((IAuditableHandle)targetProjectAreaHandle, ItemProfile.PROJECT_AREA_DEFAULT, monitor);
        IIteration sourceIteration = workItemCommon.getAuditableCommon().resolveAuditable((IAuditableHandle)sourceIterationHandle, ItemProfile.ITERATION_DEFAULT, monitor);
        String lineLabel = workItemCommon.getAuditableCommon().resolveAuditable((IAuditableHandle)sourceIteration.getDevelopmentLine(), ItemProfile.DEVELOPMENT_LINE_DEFAULT, monitor).getId();
        IDevelopmentLine developmentLine = null;
        List<IDevelopmentLine> developmentLines = workItemCommon.getAuditableCommon().resolveAuditablesPermissionAware(Arrays.asList(targetProjectArea.getDevelopmentLines()), ItemProfile.DEVELOPMENT_LINE_DEFAULT, monitor);
        for (IDevelopmentLine current : developmentLines) {
            if (!current.getId().equals(lineLabel)) continue;
            developmentLine = current;
            break;
        }
        if (developmentLine == null) {
            return null;
        }
        ArrayList<String> labelPath = new ArrayList<String>();
        while (sourceIteration != null) {
            labelPath.add(0, sourceIteration.getId());
            IIteration iIteration = sourceIteration = sourceIteration.getParent() != null ? workItemCommon.getAuditableCommon().resolveAuditable((IAuditableHandle)sourceIteration.getParent(), ItemProfile.ITERATION_DEFAULT, monitor) : null;
        }
        IIteration next = null;
        List<IIteration> iterations = workItemCommon.getAuditableCommon().resolveAuditablesPermissionAware(Arrays.asList(developmentLine.getIterations()), ItemProfile.ITERATION_DEFAULT, monitor);
        for (String label : labelPath) {
            next = null;
            for (IIteration current : iterations) {
                if (!current.getId().equals(label)) continue;
                next = current;
                break;
            }
            if (next == null) break;
            iterations = workItemCommon.getAuditableCommon().resolveAuditablesPermissionAware(Arrays.asList(next.getChildren()), ItemProfile.ITERATION_DEFAULT, monitor);
        }
        return next != null ? (IIterationHandle)next.getItemHandle() : null;
    }

    private void copyEnumerationAttribute(IWorkItem sourceWorkItem, IAttribute sourceAttribute, IWorkItem targetWorkItem, IAttribute targetAttribute, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        Identifier value = (Identifier)sourceWorkItem.getValue(sourceAttribute);
        IEnumeration<? extends ILiteral> targetEnumeration = workItemCommon.resolveEnumeration(targetAttribute, monitor);
        if (value == null && targetEnumeration.getEnumerationLiterals(false).isEmpty() || value != null && targetEnumeration.findEnumerationLiteral(value, false) != null) {
            this.setValue(targetWorkItem, targetAttribute, value);
        } else if (value != null) {
            IEnumeration<? extends ILiteral> sourceEnumeration = workItemCommon.resolveEnumeration(sourceAttribute, monitor);
            ILiteral literal = sourceEnumeration.findEnumerationLiteral(value);
            String literalName = literal != null ? literal.getName() : value.getStringIdentifier();
            this.fCopyProblems.add(new CopyProblem(NLS.bind((String)Messages.getString("CopyToProjectOperation.VALUE_NOTFOUND_FOR_ATTRIBUTE"), (Object)targetAttribute.getDisplayName(), (Object[])new Object[]{literalName})));
        } else {
            this.fCopyProblems.add(new CopyProblem(NLS.bind((String)Messages.getString("CopyToProjectOperation.NONE_NOT_FOUND"), (Object)targetAttribute.getDisplayName(), (Object[])new Object[0])));
        }
    }

    private void copyEnumerationListAttribute(IWorkItem sourceWorkItem, IAttribute sourceAttribute, IWorkItem targetWorkItem, IAttribute targetAttribute, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        List sourceValues = (List)sourceWorkItem.getValue(sourceAttribute);
        ArrayList<Identifier> compatibleValues = new ArrayList<Identifier>();
        IEnumeration<? extends ILiteral> targetEnumeration = workItemCommon.resolveEnumeration(targetAttribute, monitor);
        for (Identifier sourceValue : sourceValues) {
            if (targetEnumeration.findEnumerationLiteral(sourceValue, true) != null) {
                compatibleValues.add(sourceValue);
                continue;
            }
            IEnumeration<? extends ILiteral> sourceEnumeration = workItemCommon.resolveEnumeration(sourceAttribute, monitor);
            ILiteral literal = sourceEnumeration.findEnumerationLiteral(sourceValue);
            String literalName = literal != null ? literal.getName() : sourceValue.getStringIdentifier();
            this.fCopyProblems.add(new CopyProblem(NLS.bind((String)Messages.getString("CopyToProjectOperation.VALUE_NOTFOUND_FOR_ATTRIBUTE"), (Object)targetAttribute.getDisplayName(), (Object[])new Object[]{literalName})));
        }
        this.setValue(targetWorkItem, targetAttribute, compatibleValues);
    }

    private void copyHelperAttribute(IWorkItem sourceWorkItem, IAttribute sourceAttribute, IWorkItem targetWorkItem, IAttribute targetAttribute) {
        Object sourceValue = sourceWorkItem.getValue(sourceAttribute);
        Object targetValue = sourceValue instanceof Collection ? EMFHelper.copy((Collection)sourceValue) : EMFHelper.copy(sourceValue);
        this.setValue(targetWorkItem, targetAttribute, targetValue);
    }

    private void copySimpleAttribute(IWorkItem sourceWorkItem, IAttribute sourceAttribute, IWorkItem targetWorkItem, IAttribute targetAttribute) {
        Object value = sourceWorkItem.getValue(sourceAttribute);
        this.setValue(targetWorkItem, targetAttribute, value);
    }

    private void setValue(IWorkItem workItem, IAttribute attribute, Object value) {
        if (!workItem.hasAttribute(attribute)) {
            workItem.addCustomAttribute(attribute);
        }
        workItem.setValue(attribute, value);
    }

    private void copyReferences(IWorkItemCommon workItemCommon, IWorkItemReferences sourceReferences, IWorkItemReferences targetReferences, IProgressMonitor monitor) throws TeamRepositoryException {
        for (IEndPointDescriptor endPoint : sourceReferences.getTypes()) {
            if (!(this.fMove || WorkItemLinkTypes.isUserWritable(endPoint) && !WorkItemLinkTypes.getOther(endPoint).isSingleValued())) {
                this.fCopyProblems.add(new CopyProblem(NLS.bind((String)Messages.getString("CopyToProjectOperation.LINKTYPE_NOT_SUPPORTED"), (Object)endPoint.getDisplayName(), (Object[])new Object[0])));
                continue;
            }
            boolean isScheduleDependency = "successor".equals(endPoint.getId()) || "predecessor".equals(endPoint.getId());
            for (IReference reference : sourceReferences.getReferences(endPoint)) {
                IItemHandle handle;
                IReference targetRef;
                if (isScheduleDependency && (targetRef = reference.getLink().getTargetRef()).isItemReference() && !this.fWorkItemsToCopy.contains((handle = (IItemHandle)reference.resolve()).getItemId())) {
                    IWorkItem wi = workItemCommon.getAuditableCommon().resolveAuditable((IWorkItemHandle)handle, IWorkItem.SMALL_PROFILE, monitor);
                    this.fCopyProblems.add(new CopyProblem(NLS.bind((String)Messages.getString("CopyToProjectOperation.DROPPING_SCHEDULE_DEPENDENCY"), (Object)wi.getHTMLSummary().getPlainText(), (Object[])new Object[0])));
                    if (!this.fMove || !this.fCommitChanges) continue;
                    sourceReferences.remove(reference);
                }
                targetReferences.add(endPoint, (IReference)EMFHelper.copy(reference));
            }
        }
    }

    protected abstract void handleAttachments(IWorkItem var1, IWorkItem var2, IWorkItemCommon var3, IProgressMonitor var4) throws TeamRepositoryException;

    public boolean isMove() {
        return this.fMove;
    }

    public boolean isCommitChanges() {
        return this.fCommitChanges;
    }

    protected boolean isResolveSource() {
        return this.fResolveSource;
    }

    protected boolean hasToCopyAttachments() {
        return this.fCopyAttachments;
    }

    public IProjectAreaHandle getTargetArea() {
        return this.fTargetArea;
    }

    protected void addCopy(IWorkItem copy) {
        this.fCopies.add(copy);
    }

    protected void addCopyProblem(CopyProblem problem) {
        this.fCopyProblems.add(problem);
    }

    public List<CopyProblem> getCopyProblems() {
        return Collections.unmodifiableList(this.fCopyProblems);
    }

    public List<IWorkItem> getCopies() {
        return Collections.unmodifiableList(this.fCopies);
    }

    public static class CopyProblem {
        private final String fSummary;

        public CopyProblem(String summary) {
            this.fSummary = summary;
        }

        public String getSummary() {
            return this.fSummary;
        }

        public String toString() {
            return this.fSummary;
        }
    }
}

