/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.runtime.IOperationAdvisor;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.ISaveParameter;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.Messages;
import com.ibm.team.workitem.common.internal.util.AttributesAdvisorHelper;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class ValidationAdvisor
implements IOperationAdvisor {
    public static final String ADVISOR_ID = "com.ibm.team.workitem.advisor.validation";

    public void run(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        ISaveParameter saveParameter;
        IAuditable auditable;
        Object data = operation.getOperationData();
        if (data instanceof ISaveParameter && (auditable = (saveParameter = (ISaveParameter)data).getNewState()) instanceof IWorkItem) {
            IAuditableCommon auditableCommon = saveParameter.getSaveOperationParameter().getAuditableCommon();
            IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
            IWorkItem workItem = (IWorkItem)auditable;
            TimeZone userTimeZone = saveParameter.getSaveOperationParameter().getUserTimeZone();
            this.checkWorkItem(workItem, workItemCommon, advisorConfiguration, collector, userTimeZone, saveParameter.getAdditionalSaveParameters(), monitor);
        }
    }

    private void checkWorkItem(IWorkItem workItem, IWorkItemCommon workItemCommon, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, TimeZone userTimeZone, Set<String> additionalSaveParameter, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableCommon auditableCommon = workItemCommon.getAuditableCommon();
        List<IAttribute> attributes = workItemCommon.findAttributes(workItem.getProjectArea(), monitor);
        for (IAttribute attribute : attributes) {
            IStatus status;
            if (!workItem.isAttributeSet(attribute) || this.shouldSkipAttributeValidation(additionalSaveParameter, attribute.getIdentifier()) || 4 != (status = attribute.validate(auditableCommon, workItem, monitor)).getSeverity()) continue;
            IAdvisorInfo info = collector.createProblemInfo(this.getSummary(attribute, status), this.getDescription(workItem, attribute, userTimeZone, status), ADVISOR_ID);
            info.setProblemObject((Object)workItem.getItemHandle());
            info.setData(AttributesAdvisorHelper.createData(workItem, attribute, ADVISOR_ID));
            collector.addInfo((IReportInfo)info);
        }
    }

    private String getDescription(IWorkItem workItem, IAttribute attribute, TimeZone userTimeZone, IStatus status) {
        return NLS.bind((String)Messages.getString("ValidationAdvisor.ERROR_DESCRIPTION"), (Object)attribute.getDisplayName(), (Object[])new Object[]{WorkItemTextUtilities.formatWorkItemId(workItem, userTimeZone), status.getMessage()});
    }

    private String getSummary(IAttribute attribute, IStatus status) {
        return NLS.bind((String)Messages.getString("ValidationAdvisor.ERROR_SUMMARY"), (Object)attribute.getDisplayName(), (Object[])new Object[]{status.getMessage()});
    }

    private boolean shouldSkipAttributeValidation(Set<String> additionalSaveParameter, String attributeId) {
        if (additionalSaveParameter != null && additionalSaveParameter.size() > 0) {
            return additionalSaveParameter.contains("com.ibm.team.workitem.common.internal.skipValidationAttributeName=" + attributeId);
        }
        return false;
    }
}

