/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.oslc.mappings;

import com.ibm.team.calm.foundation.common.CustomNamespaceContext;
import com.ibm.team.calm.foundation.common.Namespaces;
import com.ibm.team.calm.foundation.common.Property;
import com.ibm.team.calm.foundation.common.oslc.OSLCCoreIdentifiers;
import com.ibm.team.calm.foundation.common.oslc.Version;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

public abstract class AbstractVersionedDescriptor {
    private static final CustomNamespaceContext fgNsContext = Namespaces.createDefaultContext();
    private final Map<Version, Property> fProperties = new HashMap<Version, Property>();

    public String getPublicIdentifier() {
        Property property = this.getProperty(OSLCCoreIdentifiers.VERSION_DEFAULT);
        return property != null ? property.getName() : null;
    }

    public String getNamespace() {
        Property property = this.getProperty(OSLCCoreIdentifiers.VERSION_DEFAULT);
        return property != null ? property.getNamespaceURI() : null;
    }

    public Property getProperty(Version version) {
        return this.fProperties.get(version);
    }

    public boolean matchesVersion(Version oslcVersion) {
        return this.fProperties.containsKey(oslcVersion);
    }

    protected void addPublicIdentifier(Version version, String publicId, String namespaceURI) {
        Assert.isNotNull((Object)publicId);
        Assert.isNotNull((Object)namespaceURI);
        this.fProperties.put(version, new Property(namespaceURI, publicId));
    }

    protected void initFrom(AbstractVersionedDescriptor descriptor) {
        this.fProperties.putAll(descriptor.fProperties);
    }

    public String getReferenceName() {
        for (Version version : OSLCCoreIdentifiers.VERSIONS) {
            Property property = this.getProperty(version);
            if (property == null) continue;
            return fgNsContext.qualify(property);
        }
        throw new IllegalStateException();
    }
}

