/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.repository.common.IItemHandle;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ItemHandleAwareHashMap<K, V> {
    private static final ItemHandleAwareHashMap<Object, Object> EMPTY = new ItemHandleAwareHashMap(Collections.emptyMap());
    private Map<Object, V> fInternalMap;
    private Key fReusableKey = new Key();

    public static final <K, V> ItemHandleAwareHashMap<K, V> empty() {
        return EMPTY;
    }

    public ItemHandleAwareHashMap() {
        this(new HashMap());
    }

    private ItemHandleAwareHashMap(Map<Object, V> internalMap) {
        this.fInternalMap = internalMap;
    }

    public int size() {
        return this.fInternalMap.size();
    }

    public void clear() {
        this.fInternalMap.clear();
    }

    public boolean isEmpty() {
        return this.fInternalMap.isEmpty();
    }

    public boolean containsKey(Object key) {
        if (key instanceof IItemHandle) {
            this.fReusableKey.handle = (IItemHandle)key;
            return this.fInternalMap.containsKey(this.fReusableKey);
        }
        return this.fInternalMap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.fInternalMap.containsValue(value);
    }

    public Collection<V> values() {
        return this.fInternalMap.values();
    }

    public void putAll(Map<? extends K, ? extends V> t) {
        Set<Map.Entry<K, V>> entrySet = t.entrySet();
        for (Map.Entry<K, V> entry : entrySet) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Set<K> keySet() {
        HashSet<Object> result = new HashSet<Object>();
        for (Object element : this.fInternalMap.keySet()) {
            if (element instanceof Key) {
                Key key = (Key)element;
                result.add(key.handle);
                continue;
            }
            result.add(element);
        }
        return result;
    }

    public V get(Object key) {
        if (key instanceof IItemHandle) {
            this.fReusableKey.handle = (IItemHandle)key;
            return this.fInternalMap.get(this.fReusableKey);
        }
        return this.fInternalMap.get(key);
    }

    public V remove(Object key) {
        if (key instanceof IItemHandle) {
            this.fReusableKey.handle = (IItemHandle)key;
            return this.fInternalMap.remove(this.fReusableKey);
        }
        return this.fInternalMap.remove(key);
    }

    public V put(K key, V value) {
        if (key instanceof IItemHandle) {
            return this.fInternalMap.put(new Key((IItemHandle)key), value);
        }
        return this.fInternalMap.put(key, value);
    }

    private static class Key {
        public IItemHandle handle;

        public Key() {
        }

        public Key(IItemHandle handle) {
            this.handle = handle;
        }

        public int hashCode() {
            return this.handle.getItemId().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            return this.handle.sameItemId(((Key)obj).handle);
        }
    }
}

