/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.model;

import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class IterationMigration {
    public static final String NAME_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"name");
    public static final String START_DATE_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"startDate");
    public static final String END_DATE_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"endDate");
    private static final String ID_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"id");
    private static final String PARENT_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"parent");
    private static final String DEVELOPMENT_LINE_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"developmentLine");
    public static final ItemProfile<IIteration> DEFAULT_PROFILE = ItemProfile.ITERATION_DEFAULT;
    private static final String DEVELOPMENT_LINE_ITERATIONS_PROPERTY = ProcessCommon.getPropertyName(IDevelopmentLine.class, (String)"iterations");

    public static String getName(IIteration interval) {
        Assert.isTrue((boolean)interval.isPropertySet(NAME_PROPERTY));
        Assert.isTrue((boolean)interval.isPropertySet(ID_PROPERTY));
        return interval.getLabel();
    }

    public static IProjectAreaHandle getProjectArea(IAuditableCommon auditableCommon, IIteration interval, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isTrue((boolean)interval.isPropertySet(DEVELOPMENT_LINE_PROPERTY));
        IDevelopmentLine line = auditableCommon.resolveAuditable((IAuditableHandle)interval.getDevelopmentLine(), ItemProfile.DEVELOPMENT_LINE_DEFAULT, monitor);
        return line.getProjectArea();
    }

    public static boolean isParent(IIteration parent, IIteration child) {
        Assert.isTrue((boolean)child.isPropertySet(PARENT_PROPERTY));
        return parent.sameItemId((IItemHandle)child.getParent());
    }

    public static boolean isRoot(IIteration interval) {
        Assert.isTrue((boolean)interval.isPropertySet(PARENT_PROPERTY));
        return interval.getParent() == null;
    }

    public static String getDevelopmentLineId(IAuditableCommon auditableCommon, IIteration interval, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isTrue((boolean)interval.isPropertySet(DEVELOPMENT_LINE_PROPERTY));
        String idProperty = ProcessCommon.getPropertyName(IDevelopmentLine.class, (String)"id");
        IDevelopmentLine developmentLine = (IDevelopmentLine)auditableCommon.resolveAuditable((IAuditableHandle)interval.getDevelopmentLine(), ItemProfile.createProfile(IDevelopmentLine.ITEM_TYPE, idProperty), monitor);
        return developmentLine.getId();
    }

    public static IIteration[] getIterations(IAuditableCommon auditableCommon, IDevelopmentLine developmentLine, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isTrue((boolean)developmentLine.isPropertySet(DEVELOPMENT_LINE_ITERATIONS_PROPERTY));
        List<IIteration> list = auditableCommon.resolveAuditablesPermissionAware(Arrays.asList(developmentLine.getIterations()), ItemProfile.ITERATION_DEFAULT, monitor);
        return list.toArray(new IIteration[list.size()]);
    }
}

