/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTResource;
import com.ibm.rational.wvcm.ri.impl.FolderImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.WvcmException;

public class CTFolder
extends CTResource {
    CTFolder(Location location, CTProvider provider) {
        super(location, provider);
    }

    @Override
    public Class<?> get_proxyClass() {
        return FolderImpl.class;
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.provider().getCCaseLib();
        String dispName = this.location().getDisplayName();
        if (propertyName.equals((Object)Resource.DISPLAY_NAME)) {
            return dispName;
        }
        if (propertyName.equals(CTProvider.FULLY_QUALIFIED_DISPLAY_NAME)) {
            return cc.getExtendedName(null, dispName, feedback);
        }
        if (propertyName.equals((Object)Folder.CHILD_LIST)) {
            CTProvider p = this.provider();
            String FQName = cc.getExtendedName(null, dispName, feedback);
            List<CTLocation> locations = this.findUcmObjLocations(FQName, true, feedback);
            return p.getResources(locations, feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    public List<SrvcResource> doReadMemberList(Location location, boolean deep, SrvcFeedback feedback) throws WvcmException {
        return super.doReadMemberList(location, deep, feedback);
    }

    public static int findBigFolders(CCaseLib cc, CTLocation root, int threshold, List<CTLocation> roots, SrvcFeedback f) throws WvcmException {
        int mySize = 0;
        ArrayList<CTLocation> subDirs = new ArrayList<CTLocation>();
        int memberCount = CTFolder.computeSubDirs(cc, root, subDirs, f);
        TreeMap<Integer, ArrayList<CTLocation>> memberMap = new TreeMap<Integer, ArrayList<CTLocation>>();
        for (CTLocation subdir : subDirs) {
            int memberSize = CTFolder.findBigFolders(cc, subdir, threshold, roots, f);
            ArrayList<CTLocation> chain = (ArrayList<CTLocation>)memberMap.get(memberSize);
            if (chain == null) {
                chain = new ArrayList<CTLocation>();
                memberMap.put(memberSize, chain);
            }
            chain.add(subdir);
            mySize += memberSize;
        }
        mySize += memberCount;
        while (mySize >= threshold && !memberMap.isEmpty()) {
            Integer memberSize = (Integer)memberMap.lastKey();
            List folders = (List)memberMap.remove(memberSize);
            while (!folders.isEmpty() && mySize >= threshold) {
                CTLocation folder = (CTLocation)((Object)folders.remove(0));
                roots.add(folder);
                mySize -= 1 + memberSize;
            }
        }
        return mySize;
    }

    private static int computeSubDirs(CCaseLib cc, CTLocation root, List<CTLocation> subDirs, SrvcFeedback f) throws WvcmException {
        Map<String, String> entries = cc.getCCDirectory(root.getDisplayName(), f);
        int result = entries.size();
        for (String name : entries.keySet()) {
            String dumpMtype = entries.get(name);
            if ("2".equals(dumpMtype)) {
                subDirs.add((CTLocation)root.child(name));
                continue;
            }
            if (!"19".equals(dumpMtype)) continue;
            --result;
        }
        return result;
    }
}

