/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IPath;

public class Utils {
    public static NestedPair findNestedPaths(Collection<IPath> crPaths) {
        NestedPair result = null;
        int count = crPaths.size();
        if (count < 2) {
            return result;
        }
        List<IPath> possiblePrefixesSortedByLengthAscending = Utils.sortByLengthAscending(crPaths);
        int i = 0;
        i = 1;
        while (i < count) {
            List<IPath> possiblePrefixes;
            IPath path = possiblePrefixesSortedByLengthAscending.get(i);
            result = Utils.findStartsWith(path, possiblePrefixes = possiblePrefixesSortedByLengthAscending.subList(0, i));
            if (result != null) break;
            ++i;
        }
        return result;
    }

    public static List<IPath> sortByLengthAscending(Collection<IPath> strings) {
        ArrayList<IPath> myList = new ArrayList<IPath>(strings);
        Collections.sort(myList, new Comparator<IPath>(){

            @Override
            public int compare(IPath left, IPath right) {
                return left.toString().length() - right.toString().length();
            }
        });
        return myList;
    }

    public static NestedPair findStartsWith(IPath path, List<IPath> possiblePrefixesSortedByLengthAscending) {
        NestedPair result = null;
        for (IPath prefix : possiblePrefixesSortedByLengthAscending) {
            if (!prefix.isPrefixOf(path)) continue;
            result = new NestedPair();
            result.rootPath = prefix;
            result.nestedPath = path;
            break;
        }
        return result;
    }

    public static class NestedPair {
        public IPath rootPath;
        public IPath nestedPath;
    }
}

