/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.workitem.common.ISaveOperationParameter;
import com.ibm.team.workitem.common.ISaveParameter;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IAttachmentHandle;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class SaveParameter
implements ISaveParameter {
    private final ISaveOperationParameter fSaveOperationParameter;
    private final String fOperationId;
    private final IAuditable fNewState;
    private final IAuditable fOldState;
    private final IWorkItemReferences fNewReferences;
    private String fWorkflowAction;
    private final IProcessArea fNewProcessArea;
    private final IDevelopmentLine fNewDevelopmentLine;
    private final IProcessArea fOldProcessArea;
    private final IDevelopmentLine fOldDevelopmentLine;
    private final List<IAttachment> fAttachments;
    private final List<IAttachmentHandle> fDeletedAttachments;
    private final Set<String> fAdditionalSaveParameters;

    public SaveParameter(ISaveOperationParameter saveOperationParameter, String operationId, IAuditable newState, IWorkItemReferences newReferences, IAuditable oldState, String workflowAction, IProcessArea newProcessArea, IDevelopmentLine newDevelopmentLine, IProcessArea oldProcessArea, IDevelopmentLine oldDevelopmentLine, List<IAttachment> attachments, List<IAttachmentHandle> deletedAttachments, Set<String> additionalSaveParameters) {
        this.fSaveOperationParameter = saveOperationParameter;
        this.fOperationId = operationId;
        if (this.fSaveOperationParameter != null) {
            this.fSaveOperationParameter.getSaveParameters().add(this);
        }
        this.fNewState = newState;
        this.fNewReferences = newReferences;
        this.fOldState = oldState;
        this.fWorkflowAction = workflowAction;
        this.fNewProcessArea = newProcessArea;
        this.fNewDevelopmentLine = newDevelopmentLine;
        this.fOldProcessArea = oldProcessArea;
        this.fOldDevelopmentLine = oldDevelopmentLine;
        this.fAttachments = new ArrayList<IAttachment>(attachments);
        this.fDeletedAttachments = deletedAttachments;
        this.fAdditionalSaveParameters = additionalSaveParameters;
    }

    @Override
    public ISaveOperationParameter getSaveOperationParameter() {
        return this.fSaveOperationParameter;
    }

    @Override
    public String getOperationId() {
        return this.fOperationId;
    }

    @Override
    public IAuditable getNewState() {
        return this.fNewState;
    }

    @Override
    public IAuditable getOldState() {
        return this.fOldState;
    }

    @Override
    public boolean isCreation() {
        return this.fOldState == null;
    }

    @Override
    public IWorkItemReferences getNewReferences() {
        return this.fNewReferences;
    }

    @Override
    public String getWorkflowAction() {
        return this.fWorkflowAction;
    }

    @Override
    public void setWorkflowAction(String workflowAction) {
        this.fWorkflowAction = workflowAction;
    }

    @Override
    public IProcessArea getNewProcessArea() {
        return this.fNewProcessArea;
    }

    @Override
    public IDevelopmentLine getNewDevelopmentLine() {
        return this.fNewDevelopmentLine;
    }

    @Override
    public IProcessArea getOldProcessArea() {
        return this.fOldProcessArea;
    }

    @Override
    public IDevelopmentLine getOldDevelopmentLine() {
        return this.fOldDevelopmentLine;
    }

    public List<IAttachment> getAttachments() {
        return Collections.unmodifiableList(this.fAttachments);
    }

    @Override
    public List<IAttachmentHandle> getDeletedAttachments() {
        return this.fDeletedAttachments != null ? Collections.unmodifiableList(this.fDeletedAttachments) : Collections.emptyList();
    }

    @Override
    public Set<String> getAdditionalSaveParameters() {
        return this.fAdditionalSaveParameters;
    }
}

