/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.template;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.foundation.common.util.XMLMemento;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.workitem.common.internal.identifiers.IPublicAttribute;
import com.ibm.team.workitem.common.internal.model.WorkItemCommonPlugin;
import com.ibm.team.workitem.common.internal.template.WorkItemTemplateHandle;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.template.ITemplateAttributeIdentifiers;
import com.ibm.team.workitem.common.template.IWorkItemTemplate;
import com.ibm.team.workitem.common.template.IWorkItemTemplateHandle;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.runtime.CoreException;

public class WorkItemTemplate
extends WorkItemTemplateHandle
implements IWorkItemTemplate {
    private String fContent;

    public WorkItemTemplate(String id, IProjectAreaHandle projectArea) {
        super(id, projectArea);
    }

    public WorkItemTemplate(IWorkItemTemplateHandle handle) {
        super(handle);
    }

    @Override
    public void setId(String identifier) {
        if (this.hasContent()) {
            try {
                this.updateContent(ITemplateAttributeIdentifiers.IDENTIFIER, identifier);
                super.setId(identifier);
            }
            catch (IOException ex) {
                WorkItemCommonPlugin.log(ex.getMessage(), ex);
            }
            catch (CoreException ex) {
                WorkItemCommonPlugin.log(ex.getMessage(), (Exception)((Object)ex));
            }
        } else {
            super.setId(identifier);
        }
    }

    @Override
    public void setName(String name) {
        if (this.hasContent()) {
            try {
                this.updateContent(ITemplateAttributeIdentifiers.NAME, name);
                super.setName(name);
            }
            catch (IOException ex) {
                WorkItemCommonPlugin.log(ex.getMessage(), ex);
            }
            catch (CoreException ex) {
                WorkItemCommonPlugin.log(ex.getMessage(), (Exception)((Object)ex));
            }
        } else {
            super.setName(name);
        }
    }

    @Override
    public void setDescription(String description) {
        if (this.hasContent()) {
            try {
                this.updateContent(ITemplateAttributeIdentifiers.DESCRIPTION, description);
                super.setDescription(description);
            }
            catch (IOException ex) {
                WorkItemCommonPlugin.log(ex.getMessage(), ex);
            }
            catch (CoreException ex) {
                WorkItemCommonPlugin.log(ex.getMessage(), (Exception)((Object)ex));
            }
        } else {
            super.setDescription(description);
        }
    }

    @Override
    public void setOwner(IContributorHandle owner) {
        super.setOwner(owner);
    }

    public void setContent(String xml) {
        this.fContent = xml;
    }

    @Override
    public String getContent() {
        return this.fContent;
    }

    @Override
    public boolean hasContent() {
        return this.fContent != null;
    }

    private void updateContent(Identifier<IPublicAttribute> attributeID, String attributeValue) throws IOException, CoreException {
        if (attributeID == null || attributeValue == null || this.fContent == null) {
            return;
        }
        XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(this.fContent));
        IMemento[] children = memento.getChildren();
        if (children != null) {
            IMemento[] iMementoArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento cur = iMementoArray[n2];
                if (cur.getType().endsWith(attributeID.getStringIdentifier())) {
                    cur.putTextData(attributeValue);
                    break;
                }
                ++n2;
            }
        }
        this.setContent(memento.asXMLString());
    }
}

