/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.foundation.common.internal.text.HTML2TextReader;
import com.ibm.team.foundation.common.text.HTMLHandler;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.workitem.common.internal.util.ExtendedRichTextHandlers;
import com.ibm.team.workitem.common.internal.util.HTMLSanitizer;
import com.ibm.team.workitem.common.internal.util.ScanRules;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;

public class HTMLOutputHandler
extends HTMLHandler {
    protected static final String EMPTY_STRING = "";
    private static final String ENTITY_REF_NBSP = "&nbsp;";
    private static final Set<String> fPhrasingElements = new HashSet<String>();
    private static final String BOLD_TAG = "<b>";
    private static final String BOLD_END_TAG = "</b>";
    private static final String ITALIC_TAG = "<i>";
    private static final String ITALIC_END_TAG = "</i>";
    private static final String FOREGROUND_TAG = "<span style=\"color: #{1};\">";
    private static final String BACKGROUND_TAG = "<span style=\"background: #{1};\">";
    private static final String COLOR_END_TAG = "</span>";
    private static final String REFERENCE_TAG_LEFT = "<a href=\"";
    private static final String REFERENCE_TAG_RIGHT = "\">";
    private static final String REFERENCE_END_TAG = "</a>";
    private static final String BIDI_MARKER = " dir=";
    protected Scanner fScanner;
    protected StringBuffer fBuffer;
    private Stack<Style> fStyles = new Stack();
    private boolean fFiltered;
    private boolean fHasExtendedRichText = false;
    private boolean fAllowExtendedRichText = false;

    static {
        fPhrasingElements.add("a");
        fPhrasingElements.add("em");
        fPhrasingElements.add("strong");
        fPhrasingElements.add("s");
        fPhrasingElements.add("u");
        fPhrasingElements.add("b");
        fPhrasingElements.add("i");
        fPhrasingElements.add("strike");
        fPhrasingElements.add("span");
        fPhrasingElements.add("br");
        fPhrasingElements.add("del");
        fPhrasingElements.add("img");
        fPhrasingElements.add("del");
    }

    public HTMLOutputHandler(boolean canonical) {
        this(canonical, false);
    }

    public HTMLOutputHandler(boolean canonical, boolean allowExtendedRichText) {
        this(allowExtendedRichText, Arrays.asList(new ScanRules.LineDelimiterRule(canonical), new ScanRules.SpaceRule(), new ScanRules.EntityRule(allowExtendedRichText)));
    }

    public HTMLOutputHandler(boolean allowExtendedRichText, List<IScanRule> rules) {
        super(true);
        this.fScanner = new Scanner(rules);
        this.fAllowExtendedRichText = allowExtendedRichText;
    }

    public XMLString getHTML() {
        return XMLString.createFromXMLText((String)this.fBuffer.toString());
    }

    public XMLString getXHTML() {
        int nbspPos = this.fBuffer.indexOf(ENTITY_REF_NBSP);
        while (nbspPos != -1) {
            this.fBuffer.replace(nbspPos, nbspPos + ENTITY_REF_NBSP.length(), " ");
            nbspPos = this.fBuffer.indexOf(ENTITY_REF_NBSP);
        }
        return XMLString.createFromXMLText((String)this.fBuffer.toString());
    }

    public boolean hasExtendedRichText() {
        return this.fHasExtendedRichText;
    }

    public XMLString sanitizeHtml(XMLString html) {
        new HTMLSanitizer(new StringReader(html.getXMLText()), this).parse();
        return this.getHTML();
    }

    public void beginDocument() {
        this.fBuffer = new StringBuffer();
        this.fStyles = new Stack();
    }

    public void endDocument() {
        while (!this.fStyles.isEmpty()) {
            this.endStyle();
        }
    }

    public void text(CharSequence text) {
        this.fBuffer.append(this.fScanner.escape(text));
    }

    public void beginStyle(int[] foreground, int[] background, int fontStyle) {
        Style style = new Style(foreground, background, fontStyle);
        this.fStyles.push(style);
        if ((style.getFontStyle() & 1) != 0) {
            this.fBuffer.append(BOLD_TAG);
        }
        if ((style.getFontStyle() & 2) != 0) {
            this.fBuffer.append(ITALIC_TAG);
        }
        if (style.getForeground() != null) {
            this.fBuffer.append(FOREGROUND_TAG.replace("{1}", this.RGBToString(style.getForeground())));
        }
        if (style.getBackground() != null) {
            this.fBuffer.append(BACKGROUND_TAG.replace("{1}", this.RGBToString(style.getBackground())));
        }
    }

    public void endStyle() {
        if (this.fStyles.isEmpty()) {
            return;
        }
        Style style = this.fStyles.pop();
        if (style.getBackground() != null) {
            this.fBuffer.append(COLOR_END_TAG);
        }
        if (style.getForeground() != null) {
            this.fBuffer.append(COLOR_END_TAG);
        }
        if ((style.getFontStyle() & 2) != 0) {
            this.fBuffer.append(ITALIC_END_TAG);
        }
        if ((style.getFontStyle() & 1) != 0) {
            this.fBuffer.append(BOLD_END_TAG);
        }
    }

    public void beginReference(CharSequence reference) {
        String href = reference.toString().trim().toLowerCase(Locale.ROOT);
        if (href.startsWith("javascript:")) {
            this.fFiltered = true;
            return;
        }
        this.fFiltered = false;
        this.fBuffer.append(REFERENCE_TAG_LEFT).append(this.encode(reference.toString())).append(REFERENCE_TAG_RIGHT);
    }

    public void endReference() {
        if (this.fFiltered) {
            return;
        }
        this.fBuffer.append(REFERENCE_END_TAG);
    }

    public String substituteHtml(String html) {
        String tag;
        if (HTML2TextReader.tagName((String)html).equals("synthetic")) {
            this.writeElement(html.startsWith("/") ? "/synthetic" : "synthetic");
            return EMPTY_STRING;
        }
        if (this.fAllowExtendedRichText && ExtendedRichTextHandlers.isExtendedRichTextTag(tag = HTML2TextReader.tagName((String)html))) {
            this.fHasExtendedRichText = true;
            this.writeElement(html);
            return EMPTY_STRING;
        }
        return super.substituteHtml(html);
    }

    protected boolean isEndTag(String html) {
        return html.charAt(0) == '/';
    }

    private String encode(String reference) {
        return XMLString.createFromPlainText((String)reference).getXMLText();
    }

    private String RGBToString(int[] rgb) {
        return String.valueOf(this.toHexString(rgb[0], 2)) + this.toHexString(rgb[1], 2) + this.toHexString(rgb[2], 2);
    }

    /*
     * Unable to fully structure code
     */
    private String toHexString(int value, int digits) {
        s = Integer.toHexString(value);
        if (s.length() <= digits) ** GOTO lbl5
        throw new IllegalArgumentException();
lbl-1000:
        // 1 sources

        {
            s = "0" + s;
lbl5:
            // 2 sources

            ** while (s.length() < digits)
        }
lbl6:
        // 1 sources

        return s;
    }

    private void writeElement(CharSequence html) {
        this.fBuffer.append("<" + html + ">");
    }

    public static XMLString sanitize(XMLString string) {
        return HTMLOutputHandler.sanitize(string, false);
    }

    public static XMLString sanitize(XMLString string, boolean allowExtendedRichText) {
        HTMLOutputHandler handler = new HTMLOutputHandler(false, allowExtendedRichText);
        return handler.sanitizeHtml(string);
    }

    public static interface IScanRule {
        public String evaluate(Scanner var1);
    }

    public static class Scanner {
        protected static final int EOF = -1;
        private final List<IScanRule> fRules;
        private CharSequence fText;
        private int fOffset;

        public Scanner(List<IScanRule> rules) {
            this.fRules = rules;
        }

        public int read() {
            try {
                if (this.fOffset < this.fText.length()) {
                    char c = this.fText.charAt(this.fOffset);
                    return c;
                }
                return -1;
            }
            finally {
                ++this.fOffset;
            }
        }

        public char[] read(int numberOfChars) {
            if (this.fOffset + numberOfChars >= this.fText.length()) {
                return null;
            }
            char[] chars = new char[numberOfChars];
            int i = 0;
            while (i < numberOfChars) {
                chars[i] = (char)this.read();
                ++i;
            }
            return chars;
        }

        public void unread(int numberOfChars) {
            this.fOffset -= numberOfChars;
        }

        public void unread() {
            this.unread(1);
        }

        public String escape(CharSequence text) {
            this.fOffset = 0;
            this.fText = text;
            StringBuffer buffer = new StringBuffer();
            while (true) {
                String replacement;
                if ((replacement = this.replacement()) != null) {
                    buffer.append(replacement);
                    continue;
                }
                int ch = this.read();
                if (ch == -1) break;
                buffer.append((char)ch);
            }
            return buffer.toString();
        }

        private String replacement() {
            for (IScanRule rule : this.fRules) {
                String replacement = rule.evaluate(this);
                if (replacement == null) continue;
                return replacement;
            }
            return null;
        }
    }

    private static class Style {
        private int[] fForeground;
        private int[] fBackground;
        private int fFontStyle;

        public Style(int[] foreground, int[] background, int fontStyle) {
            this.fForeground = foreground;
            this.fBackground = background;
            this.fFontStyle = fontStyle;
        }

        public int[] getForeground() {
            return this.fForeground;
        }

        public int[] getBackground() {
            return this.fBackground;
        }

        public int getFontStyle() {
            return this.fFontStyle;
        }
    }
}

