/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import java.net.URLConnection;
import java.util.Locale;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;

public class InternalContentTypeUtils {
    public static String getMIMEType(String filename, IContentDescription contentDescription) {
        if (contentDescription == null) {
            return InternalContentTypeUtils.getMIMEType(filename);
        }
        return InternalContentTypeUtils.getMIMEType(filename, contentDescription.getContentType());
    }

    public static String getMIMEType(String filename, IContentType contentType) {
        String type = InternalContentTypeUtils.internalGetMIMEType(filename);
        if (type != null) {
            return type;
        }
        return InternalContentTypeUtils.internalGetMIMEType(filename, contentType);
    }

    private static String internalGetMIMEType(String filename, IContentType contentType) {
        if (contentType == null) {
            return InternalContentTypeUtils.getMIMEType(filename);
        }
        if ("org.eclipse.core.runtime.text".equals(contentType.getId())) {
            return "text/plain";
        }
        if ("org.eclipse.core.runtime.xml".equals(contentType.getId())) {
            return "text/xml";
        }
        return InternalContentTypeUtils.internalGetMIMEType(filename, contentType.getBaseType());
    }

    private static String getMIMEType(String filename) {
        String type = InternalContentTypeUtils.internalGetMIMEType(filename);
        if (type != null) {
            return type;
        }
        String fallbackGuess = URLConnection.guessContentTypeFromName(filename);
        return fallbackGuess != null ? fallbackGuess : "application/unknown";
    }

    private static String internalGetMIMEType(String filename) {
        if (filename == null) {
            return null;
        }
        if ((filename = filename.toLowerCase(Locale.ROOT)).endsWith(".jpg") || filename.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (filename.endsWith(".gif")) {
            return "image/gif";
        }
        if (filename.endsWith(".png")) {
            return "image/png";
        }
        if (filename.endsWith(".html") || filename.endsWith(".htm")) {
            return "text/html";
        }
        if (filename.endsWith(".mp4")) {
            return "video/mp4";
        }
        if (filename.endsWith(".ogg")) {
            return "video/ogg";
        }
        if (filename.endsWith(".webm")) {
            return "video/webm";
        }
        if (filename.endsWith(".pdf")) {
            return "application/pdf";
        }
        return null;
    }

    public static String guessFileExtension(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        if ("text/plain".equals(mimeType)) {
            return "txt";
        }
        int index = mimeType.lastIndexOf(47);
        if (index == -1 || index == mimeType.length() - 1) {
            return null;
        }
        return mimeType.substring(index + 1);
    }

    public static String getCharSet(IContentDescription contentDescription, String mimeType) {
        if (!InternalContentTypeUtils.isTextType(mimeType)) {
            return null;
        }
        String charset = null;
        if (contentDescription != null) {
            charset = contentDescription.getCharset();
        }
        if (charset == null || charset.length() == 0) {
            charset = System.getProperty("file.encoding");
        }
        if (charset == null || charset.length() == 0) {
            charset = "UTF-8";
        }
        return charset;
    }

    private static boolean isTextType(String mimeType) {
        return mimeType != null && mimeType.trim().toLowerCase(Locale.ROOT).startsWith("text");
    }
}

