/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.model;

import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformationRegistry;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class WorkItemLinkTypes {
    public static final String RELATED_WORK_ITEM = "com.ibm.team.workitem.linktype.relatedworkitem";
    public static final String DUPLICATE_WORK_ITEM = "com.ibm.team.workitem.linktype.duplicateworkitem";
    public static final String COPIED_WORK_ITEM = "com.ibm.team.workitem.linktype.copiedworkitem";
    public static final String RELATED_ARTIFACT = "com.ibm.team.workitem.linktype.relatedartifact";
    public static final String ATTACHMENT = "com.ibm.team.workitem.linktype.attachment";
    public static final String BLOCKS_WORK_ITEM = "com.ibm.team.workitem.linktype.blocksworkitem";
    public static final String PARENT_WORK_ITEM = "com.ibm.team.workitem.linktype.parentworkitem";
    public static final String SCHEDULE_PREDECESSOR = "com.ibm.team.workitem.linktype.schedulePredecessor";
    public static final String SCHEDULE_PREDECESSOR_TARGET = "predecessor";
    public static final String SCHEDULE_PREDECESSOR_SOURCE = "successor";
    public static final String RESOLVES_WORK_ITEM = "com.ibm.team.workitem.linktype.resolvesworkitem";
    public static final String TRACKS_WORK_ITEM = "com.ibm.team.workitem.linktype.tracksworkitem";
    public static final String CONTRIBUTES_TO_WORK_ITEM = "com.ibm.team.workitem.linktype.trackedworkitem";
    public static final String CHANGE_SET = "com.ibm.team.filesystem.workitems.change_set";
    public static final String MENTIONS = "com.ibm.team.workitem.linktype.textualReference";
    public static final String RELATED_CHANGE_MANAGEMENT = "com.ibm.team.workitem.linktype.relatedChangeManagement";
    public static final String AFFECTS_PLAN_ITEM = "com.ibm.team.workitem.linktype.cm.affectsPlanItem";
    public static final String AFFECTED_BY_DEFECT = "com.ibm.team.workitem.linktype.cm.affectedByDefect";
    public static final String TRACKS_CHANGES = "com.ibm.team.workitem.linktype.scm.tracksChanges";
    public static final String BLOCKS_EXECUTION_RECORD = "com.ibm.team.workitem.linktype.blocksTestExecutionRecord";
    public static final String AFFECTS_EXECUTION_RESULT = "com.ibm.team.workitem.linktype.affectsExecutionResult";
    public static final String TESTED_BY_TEST_CASE = "com.ibm.team.workitem.linktype.testedByTestCase";
    public static final String RELATED_TEST_CASE = "com.ibm.team.workitem.linktype.qm.relatedTestCase";
    public static final String RELATED_EXECUTION_RECORD = "com.ibm.team.workitem.linktype.qm.relatedExecutionRecord";
    public static final String RELATED_TEST_PLAN = "com.ibm.team.workitem.linktype.qm.relatedTestPlan";
    public static final String RELATED_TEST_SCRIPT = "com.ibm.team.workitem.linktype.qm.relatedTestScript";
    public static final String IMPLEMENTS_REQUIREMENT = "com.ibm.team.workitem.linktype.implementsRequirement";
    public static final String RELATED_REQUIREMENT = "com.ibm.team.workitem.linktype.rm.relatedRequirement";
    public static final String TRACKS_REQUIREMENT = "com.ibm.team.workitem.linktype.rm.tracksRequirement";
    public static final String ELABORATED_BY = "com.ibm.team.workitem.linktype.am.elaboratedBy";
    public static final String TIME_SHEET_ENTRY = "com.ibm.team.workitem.linktype.timeSheetEntry";
    public static final String TIME_SHEET_ENTRY_TARGET = "timeSheetEntry";
    public static final String CONTRIBUTES_TO_CONFIGURATION = "com.ibm.team.workitem.linktype.contributesToConfiguration";
    public static final Set<String> ALL_PLE_LINK_TYPES = new HashSet<String>(Arrays.asList("com.ibm.team.workitem.linktype.blocksTestExecutionRecord", "com.ibm.team.workitem.linktype.affectsExecutionResult", "com.ibm.team.workitem.linktype.testedByTestCase", "com.ibm.team.workitem.linktype.qm.relatedTestCase", "com.ibm.team.workitem.linktype.qm.relatedExecutionRecord", "com.ibm.team.workitem.linktype.qm.relatedTestPlan", "com.ibm.team.workitem.linktype.qm.relatedTestScript", "com.ibm.team.workitem.linktype.implementsRequirement", "com.ibm.team.workitem.linktype.rm.relatedRequirement", "com.ibm.team.workitem.linktype.rm.tracksRequirement"));
    private static final Set<String> ALL_LINK_TYPES = new HashSet<String>(Arrays.asList("com.ibm.team.workitem.linktype.relatedworkitem", "com.ibm.team.workitem.linktype.duplicateworkitem", "com.ibm.team.workitem.linktype.copiedworkitem", "com.ibm.team.workitem.linktype.relatedartifact", "com.ibm.team.workitem.linktype.attachment", "com.ibm.team.workitem.linktype.blocksworkitem", "com.ibm.team.workitem.linktype.parentworkitem", "com.ibm.team.workitem.linktype.schedulePredecessor", "com.ibm.team.workitem.linktype.resolvesworkitem", "com.ibm.team.workitem.linktype.tracksworkitem", "com.ibm.team.workitem.linktype.trackedworkitem", "com.ibm.team.workitem.linktype.textualReference", "com.ibm.team.workitem.linktype.relatedChangeManagement", "com.ibm.team.workitem.linktype.cm.affectsPlanItem", "com.ibm.team.workitem.linktype.cm.affectedByDefect", "com.ibm.team.workitem.linktype.scm.tracksChanges", "com.ibm.team.workitem.linktype.blocksTestExecutionRecord", "com.ibm.team.workitem.linktype.affectsExecutionResult", "com.ibm.team.workitem.linktype.testedByTestCase", "com.ibm.team.workitem.linktype.qm.relatedTestCase", "com.ibm.team.workitem.linktype.qm.relatedExecutionRecord", "com.ibm.team.workitem.linktype.qm.relatedTestPlan", "com.ibm.team.workitem.linktype.qm.relatedTestScript", "com.ibm.team.workitem.linktype.implementsRequirement", "com.ibm.team.workitem.linktype.rm.relatedRequirement", "com.ibm.team.workitem.linktype.rm.tracksRequirement", "com.ibm.team.workitem.linktype.am.elaboratedBy", "com.ibm.team.workitem.linktype.timeSheetEntry"));
    private static final Set<String> USER_WRITEABLE = new HashSet<String>(Arrays.asList("com.ibm.team.workitem.linktype.duplicateworkitem", "com.ibm.team.workitem.linktype.attachment", "com.ibm.team.workitem.linktype.blocksworkitem", "com.ibm.team.workitem.linktype.parentworkitem", "com.ibm.team.workitem.linktype.schedulePredecessor", "com.ibm.team.workitem.linktype.resolvesworkitem"));
    private static volatile List<IEndPointDescriptor> fgWriteableDescriptors;
    private static final Object fgLock;

    static {
        fgLock = new Object();
    }

    public static IEndPointDescriptor getEndPointDescriptor(IReference reference) {
        ILink link = reference.getLink();
        if (link == null) {
            return null;
        }
        IEndPointDescriptor descriptor = link.getThisEndpointDescriptor(reference);
        if (!WorkItemLinkTypes.isSymmetric(descriptor)) {
            return descriptor;
        }
        return link.getLinkType().getTargetEndPointDescriptor();
    }

    public static boolean isSymmetric(IEndPointDescriptor descriptor) {
        return WorkItemLinkTypes.isSymmetric(descriptor.getLinkType());
    }

    public static boolean isSymmetric(ILinkType linkType) {
        String sourceLabel = linkType.getSourceEndPointDescriptor().getDisplayName();
        String targetLabel = linkType.getTargetEndPointDescriptor().getDisplayName();
        return sourceLabel != null && sourceLabel.equals(targetLabel);
    }

    public static boolean isValidLinkType(String linkTypeId) {
        return ALL_LINK_TYPES.contains(linkTypeId);
    }

    public static boolean isUserWritable(IEndPointDescriptor descriptor) {
        return WorkItemLinkTypes.isUserWritable(descriptor.getLinkType());
    }

    public static boolean isUserWritable(ILinkType linkType) {
        return !linkType.isConstrained() && !linkType.isInternal() || USER_WRITEABLE.contains(linkType.getLinkTypeId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IEndPointDescriptor> getUserWritableDescriptors() {
        if (fgWriteableDescriptors == null) {
            Object object = fgLock;
            synchronized (object) {
                if (fgWriteableDescriptors == null) {
                    ArrayList<IEndPointDescriptor> descriptors = new ArrayList<IEndPointDescriptor>();
                    for (ILinkType linkType : ILinkTypeRegistry.INSTANCE.allEntries()) {
                        if (WorkItemLinkTypes.isUserWritable(linkType.getTargetEndPointDescriptor())) {
                            descriptors.add(linkType.getTargetEndPointDescriptor());
                        }
                        if (!WorkItemLinkTypes.isUserWritable(linkType.getSourceEndPointDescriptor())) continue;
                        descriptors.add(linkType.getSourceEndPointDescriptor());
                    }
                    fgWriteableDescriptors = descriptors;
                }
            }
        }
        return fgWriteableDescriptors;
    }

    public static IEndPointDescriptor getOther(IEndPointDescriptor endPoint) {
        ILinkType linkType = endPoint.getLinkType();
        if (linkType == null) {
            return endPoint;
        }
        return linkType.getSourceEndPointDescriptor() != endPoint ? linkType.getSourceEndPointDescriptor() : linkType.getTargetEndPointDescriptor();
    }

    public static IEndPointDescriptor findTargetEndPointDescriptor(String linkTypeId) {
        for (ILinkType linkType : ILinkTypeRegistry.INSTANCE.allEntries()) {
            if (!linkTypeId.equals(linkType.getLinkTypeId())) continue;
            return linkType.getTargetEndPointDescriptor();
        }
        return null;
    }

    public static boolean isUserDeletable(IEndPointDescriptor descriptor) {
        return WorkItemLinkTypes.isUserWritable(descriptor) || WorkItemLinkTypes.isCalmLink(descriptor);
    }

    public static boolean isCalmLink(IEndPointDescriptor type) {
        return CALMLinkTypeInformationRegistry.hasLinkTypeInformation((ILinkType)type.getLinkType());
    }

    public static List<IEndPointDescriptor> getUserDeletableDescriptors() {
        return WorkItemLinkTypes.getUserWritableDescriptors();
    }

    public static IItemReference createWorkItemReference(IWorkItem workItem) {
        return IReferenceFactory.INSTANCE.createReferenceToItem(workItem.getItemHandle(), WorkItemTextUtilities.getWorkItemText(workItem, WorkItemLinkTypes.getMaxReferenceCommentLength()));
    }

    public static IItemReference createAttachmentReference(IAttachment attachment) {
        return IReferenceFactory.INSTANCE.createReferenceToItem(attachment.getItemHandle(), WorkItemTextUtilities.getAttachmentText(attachment, WorkItemLinkTypes.getMaxReferenceCommentLength()));
    }

    public static int getMaxReferenceCommentLength() {
        return 250;
    }
}

