/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LogUtil {
    private final Log _logger;
    private final Class<?> _class;
    private static final int _indent;
    private static ThreadLocal<Integer> _callDepth;

    static {
        int indentProp = Integer.parseInt(System.getProperty("jazz.trace.indentLevel", "2"));
        if (indentProp < 0) {
            indentProp = 2;
        }
        _indent = indentProp;
        _callDepth = new ThreadLocal();
    }

    public LogUtil(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("class must not be null");
        }
        this._class = clazz;
        this._logger = LogFactory.getLog(this._class);
    }

    public Log getLog() {
        return this._logger;
    }

    public void trace(String message, Object ... args) {
        if (message == null || !this._logger.isTraceEnabled()) {
            return;
        }
        String msg = LogUtil.indentMessage(message);
        if (args == null || args.length == 0) {
            this._logger.trace((Object)msg);
        } else {
            try {
                this._logger.trace((Object)String.format(msg, args));
            }
            catch (Throwable ex) {
                this._logger.trace((Object)String.format("The arguments passed to the trace method with the msg \"%s\" caused the exception \"%s\": %s", msg, ex.getClass().getSimpleName(), ex.getMessage()));
            }
        }
    }

    public void debug(String message, Object ... args) {
        if (message == null || !this._logger.isDebugEnabled()) {
            return;
        }
        String msg = LogUtil.indentMessage(message);
        if (args == null || args.length == 0) {
            this._logger.debug((Object)msg);
        } else {
            try {
                this._logger.debug((Object)String.format(msg, args));
            }
            catch (Throwable ex) {
                this._logger.debug((Object)String.format("The arguments passed to the debug method with the msg \"%s\" caused the exception \"%s\": %s", msg, ex.getClass().getSimpleName(), ex.getMessage()));
            }
        }
    }

    public boolean isDebugEnabled() {
        return this._logger.isDebugEnabled();
    }

    public void info(String message, Object ... args) {
        if (message == null || !this._logger.isInfoEnabled()) {
            return;
        }
        String msg = LogUtil.indentMessage(message);
        if (args == null || args.length == 0) {
            this._logger.info((Object)msg);
        } else {
            try {
                this._logger.info((Object)String.format(msg, args));
            }
            catch (Throwable ex) {
                this._logger.info((Object)String.format("The arguments passed to the info method with the msg \"%s\" caused the exception \"%s\": %s", msg, ex.getClass().getSimpleName(), ex.getMessage()));
            }
        }
    }

    public void warn(String message, Object ... args) {
        if (message == null || !this._logger.isWarnEnabled()) {
            return;
        }
        String msg = LogUtil.indentMessage(message);
        if (args == null || args.length == 0) {
            this._logger.warn((Object)msg);
        } else {
            try {
                this._logger.warn((Object)String.format(msg, args));
            }
            catch (Throwable ex) {
                this._logger.warn((Object)String.format("The arguments passed to the warn method with the msg \"%s\" caused the exception \"%s\": %s", message, ex.getClass().getSimpleName(), ex.getMessage()));
            }
        }
    }

    public void error(String message, Object ... args) {
        if (message == null || !this._logger.isErrorEnabled()) {
            return;
        }
        String msg = LogUtil.indentMessage(message);
        if (args == null || args.length == 0) {
            this._logger.error((Object)msg);
        } else {
            try {
                this._logger.error((Object)String.format(msg, args));
            }
            catch (Throwable ex) {
                this._logger.error((Object)String.format("The arguments passed to the error method with the msg \"%s\" caused the exception \"%s\": %s", message, ex.getClass().getSimpleName(), ex.getMessage()));
            }
        }
    }

    public void fatal(String message, Object ... args) {
        if (message == null || !this._logger.isFatalEnabled()) {
            return;
        }
        String msg = LogUtil.indentMessage(message);
        if (args == null || args.length == 0) {
            this._logger.fatal((Object)msg);
        } else {
            try {
                this._logger.fatal((Object)String.format(msg, args));
            }
            catch (Throwable ex) {
                this._logger.fatal((Object)String.format("The arguments passed to the fatal method with the msg \"%s\" caused the exception \"%s\": %s", message, ex.getClass().getSimpleName(), ex.getMessage()));
            }
        }
    }

    public void traceEnter(String message, Object ... args) {
        if (message == null || !this._logger.isTraceEnabled()) {
            return;
        }
        LogUtil.incrementCallDepth();
        StringBuilder buf = new StringBuilder(127);
        buf.append(LogUtil.getIndentString());
        buf.append("[ENTERING] ");
        if (args == null || args.length == 0) {
            buf.append(message);
        } else {
            try {
                buf.append(String.format(message, args));
            }
            catch (Throwable ex) {
                buf.append(String.format("The arguments passed to the trace method with the msg \"%s\" caused the exception \"%s\": %s", message, ex.getClass().getSimpleName(), ex.getMessage()));
            }
        }
        this._logger.trace((Object)buf.toString());
    }

    public void traceLeave(String message, Object ... args) {
        if (message == null || !this._logger.isTraceEnabled()) {
            return;
        }
        StringBuilder buf = new StringBuilder(127);
        buf.append(LogUtil.getIndentString());
        buf.append("[EXITING]  ");
        if (args == null || args.length == 0) {
            buf.append(message);
        } else {
            try {
                buf.append(String.format(message, args));
            }
            catch (Throwable ex) {
                buf.append(String.format("The arguments passed to the trace method with the msg \"%s\" caused the exception \"%s\": %s", message, ex.getClass().getSimpleName(), ex.getMessage()));
            }
        }
        this._logger.trace((Object)buf.toString());
        LogUtil.decrementCallDepth();
    }

    private static Integer getCallDepth() {
        Integer ndx = _callDepth.get();
        if (ndx == null) {
            ndx = 0 - _indent;
            _callDepth.set(ndx);
        }
        return ndx;
    }

    private static void setCallDepth(int depth) {
        _callDepth.set(depth);
    }

    private static void incrementCallDepth() {
        int ndx = LogUtil.getCallDepth();
        LogUtil.setCallDepth(ndx += _indent);
    }

    private static void decrementCallDepth() {
        int ndx = LogUtil.getCallDepth();
        if (ndx < 0) {
            return;
        }
        LogUtil.setCallDepth(ndx -= _indent);
    }

    private static String indentMessage(String message) {
        if (LogUtil.getCallDepth() < 0) {
            return message;
        }
        LogUtil.incrementCallDepth();
        String msg = String.format("%s%s", LogUtil.getIndentString(), message);
        LogUtil.decrementCallDepth();
        return msg;
    }

    private static String getIndentString() {
        int ndx = LogUtil.getCallDepth();
        if (ndx <= 0) {
            return "";
        }
        char[] chars = new char[ndx];
        int i = 0;
        while (i < ndx) {
            chars[i] = 32;
            ++i;
        }
        return new String(chars);
    }
}

