/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.transport.client.LogUtil;
import com.ibm.team.repository.transport.internal.nls.Messages;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;

public class ReleasingAndAbortingInputStream
extends FilterInputStream {
    private HttpEntity entity;
    private static LogUtil logger = new LogUtil(ReleasingAndAbortingInputStream.class);

    public ReleasingAndAbortingInputStream(HttpEntity entity) throws IOException {
        super(entity != null ? entity.getContent() : null);
        logger.debug("Entering ReleasingAndAbortingInputStream", new Object[0]);
        this.entity = entity;
    }

    @Override
    public int read() throws IOException {
        logger.debug("Entering read", new Object[0]);
        try {
            this.assertUnderlyingInputStreamIsNotNull();
            int bytesRead = super.read();
            return bytesRead;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        logger.debug("Entering read(b, off, len)", new Object[0]);
        try {
            this.assertUnderlyingInputStreamIsNotNull();
            int bytesRead = super.read(b, off, len);
            return bytesRead;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        logger.debug("Entering read(b)", new Object[0]);
        try {
            this.assertUnderlyingInputStreamIsNotNull();
            int bytesRead = super.read(b);
            return bytesRead;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        logger.debug("Entering skip", new Object[0]);
        try {
            this.assertUnderlyingInputStreamIsNotNull();
            return super.skip(n);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    @Override
    public int available() throws IOException {
        logger.debug("Entering available", new Object[0]);
        try {
            this.assertUnderlyingInputStreamIsNotNull();
            return super.available();
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        logger.debug("Entering mark", new Object[0]);
        if (this.in != null) {
            super.mark(readlimit);
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        logger.debug("Entering reset", new Object[0]);
        try {
            this.assertUnderlyingInputStreamIsNotNull();
            super.reset();
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    @Override
    public boolean markSupported() {
        logger.debug("Entering markSupported", new Object[0]);
        if (this.in != null) {
            return super.markSupported();
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        logger.debug("Entering close", new Object[0]);
        EntityUtils.consumeQuietly((HttpEntity)this.entity);
    }

    private void assertUnderlyingInputStreamIsNotNull() throws IOException {
        if (this.in == null) {
            throw new IOException(Messages.getClientString("ReleasingAndAbortingInputStream.NoResponseBody"));
        }
    }
}

