/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.persistence;

import com.urbancode.commons.util.crypto.SecureRandomHelper;
import com.urbancode.persistence.IDGenerator;
import java.security.SecureRandom;
import java.util.UUID;

public class IDGeneratorScalableRandom
extends IDGenerator {
    private static final String SCALE_KEY = "com.urbancode.persistence.IDGeneratorScalableRandom.scale";
    private static final int SCALE_DEFAULT = 5;
    private final IDGenerator[] generators;

    static int getScale() {
        int bits = Integer.getInteger(SCALE_KEY, 5);
        if (bits < 0) {
            bits = 0;
        }
        if (bits > 30) {
            bits = 30;
        }
        return bits;
    }

    public IDGeneratorScalableRandom() {
        this(IDGeneratorScalableRandom.getScale());
    }

    public IDGeneratorScalableRandom(int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("scale < 0");
        }
        if (scale > 30) {
            throw new IllegalArgumentException("scale > 30");
        }
        this.generators = new IDGenerator[1 << scale];
        for (int i = 0; i < this.generators.length; ++i) {
            this.generators[i] = new Inner();
        }
    }

    public UUID newID() {
        return this.getGenerator(Thread.currentThread()).newID();
    }

    IDGenerator getGenerator(Thread thread) {
        return this.generators[this.getIndex(thread)];
    }

    int getIndex(Thread thread) {
        int mask = this.generators.length - 1;
        return thread.hashCode() & mask;
    }

    static final class Inner
    extends IDGenerator {
        private final SecureRandom random = SecureRandomHelper.createNewSecureRandom();
        private final byte[] bytes = new byte[16];

        Inner() {
        }

        public synchronized UUID newID() {
            this.random.nextBytes(this.bytes);
            return Inner.randomUUID(this.bytes);
        }
    }
}

