/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.query;

import com.ibm.team.fulltext.common.IQueryProvider;
import com.ibm.team.fulltext.common.ITokenGroup;
import com.ibm.team.fulltext.common.internal.StandardTokenTypes;
import java.util.Arrays;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class CamelCaseQueryProvider
implements IQueryProvider {
    @Override
    public Query createQuery(String tokenType, Analyzer analyzer, ITokenGroup tokenGroup) {
        if (StandardTokenTypes.CAMELCASE.getId().equals(tokenType)) {
            return this.createCamelcaseTypeQuery(tokenGroup);
        }
        if (StandardTokenTypes.CAMELCASE_PART.getId().equals(tokenType) || StandardTokenTypes.ACRONYM.getId().equals(tokenType)) {
            return null;
        }
        return null;
    }

    private Query createCamelcaseTypeQuery(ITokenGroup tokenGroup) {
        BooleanQuery bQuery = new BooleanQuery();
        ITokenGroup camelCaseGroup = tokenGroup.getSubGroup(StandardTokenTypes.CAMELCASE.getId());
        for (Token camelCaseToken : camelCaseGroup) {
            DisjunctionMaxQuery camelCaseQuery = new DisjunctionMaxQuery(0.0f);
            ITokenGroup compoundGroup = tokenGroup.getSubGroup(camelCaseToken, Arrays.asList(StandardTokenTypes.CAMELCASE_PART.getId(), StandardTokenTypes.ACRONYM.getId()));
            ITokenGroup acronyms = compoundGroup.getSubGroup(StandardTokenTypes.ACRONYM.getId());
            ITokenGroup camelCaseParts = compoundGroup.getSubGroup(StandardTokenTypes.CAMELCASE_PART.getId());
            TermQuery query = new TermQuery(new Term("_name", camelCaseToken.term()));
            query.setBoost(2.0f);
            camelCaseQuery.add((Query)query);
            query = new TermQuery(new Term("_content", camelCaseToken.term()));
            camelCaseQuery.add((Query)query);
            query = new PrefixQuery(new Term("_tags", camelCaseToken.term()));
            camelCaseQuery.add((Query)query);
            query = new TermQuery(new Term("_meta", camelCaseToken.term()));
            camelCaseQuery.add((Query)query);
            query = acronyms.toBooleanQuery("_name", BooleanClause.Occur.MUST, false);
            query.setBoost(2.0f);
            camelCaseQuery.add((Query)query);
            query = acronyms.toBooleanQuery("_content", BooleanClause.Occur.MUST, false);
            camelCaseQuery.add((Query)query);
            query = acronyms.toBooleanQuery("_tags", BooleanClause.Occur.MUST, true);
            camelCaseQuery.add((Query)query);
            query = acronyms.toBooleanQuery("_meta", BooleanClause.Occur.MUST, false);
            camelCaseQuery.add((Query)query);
            query = camelCaseParts.toBooleanQuery("_name", BooleanClause.Occur.MUST, false);
            query.setBoost(2.0f);
            camelCaseQuery.add((Query)query);
            query = camelCaseParts.toBooleanQuery("_content", BooleanClause.Occur.MUST, false);
            camelCaseQuery.add((Query)query);
            query = camelCaseParts.toBooleanQuery("_tags", BooleanClause.Occur.MUST, true);
            camelCaseQuery.add((Query)query);
            query = camelCaseParts.toBooleanQuery("_meta", BooleanClause.Occur.MUST, false);
            camelCaseQuery.add((Query)query);
            bQuery.add(new BooleanClause((Query)camelCaseQuery, BooleanClause.Occur.MUST));
        }
        return bQuery;
    }
}

