/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.ant;

import com.urbancode.air.plugin.ant.Util;
import com.urbancode.air.plugin.server.validation.PluginSchemaDocValidator;
import com.urbancode.air.plugin_command.validation.PluginCommandValidator;
import com.urbancode.air.plugin_command.validation.PluginZipValidator;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ValidateTask
extends Task {
    private File plugin;

    public void setPlugin(File plugin) {
        this.plugin = plugin;
    }

    public void execute() throws BuildException {
        PluginZipValidator serverValidator = this.getValidatorForServer();
        PluginZipValidator runtimeValidator = this.getValidatorForRuntime();
        try {
            ZipFile pluginZip = this.getZipFile();
            serverValidator.validateAndTransform(pluginZip);
            pluginZip = this.getZipFile();
            runtimeValidator.validateAndTransform(pluginZip);
        }
        catch (Exception e) {
            throw Util.newBuildException("Error validating plugin file " + this.plugin.getAbsolutePath(), e);
        }
        this.log("Plugin " + this.plugin.getAbsolutePath() + " is valid");
    }

    PluginZipValidator getValidatorForServer() {
        return new PluginZipValidator(new PluginSchemaDocValidator());
    }

    PluginZipValidator getValidatorForRuntime() {
        return new PluginZipValidator(new PluginCommandValidator());
    }

    ZipFile getZipFile() {
        ZipFile pluginZip;
        try {
            pluginZip = new ZipFile(this.plugin);
        }
        catch (IOException e) {
            throw Util.newBuildException("Error opening plugin file " + this.plugin.getAbsolutePath(), e);
        }
        return pluginZip;
    }
}

