/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.ant.com.urbancode.commons.util;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Formatter;

@BridgeMethodsAdded
class IODiagnosticUtil {
    private static final int FAIL = 0;
    private static final int SUCCESS_EXISTED = 1;
    private static final int SUCCESS_CREATED = 2;
    private static final String WINDOWS_INVALID_FILENAME_CHARS = "\\/:*?\"<>|";
    private static final Method canExecuteMethod;

    IODiagnosticUtil() {
    }

    static boolean createNewFile(File file) throws IOException {
        File canon = IODiagnosticUtil.fixSlashes(file);
        canon = canon.getCanonicalFile();
        File absolute = file.getAbsoluteFile();
        File parent = absolute.getParentFile();
        if (parent == null) {
            parent = absolute.getParentFile();
        }
        File parentCanon = null;
        if (parent != null) {
            parentCanon = parent.getCanonicalFile();
        }
        return IODiagnosticUtil.createNewFileMany(file, canon, parent, parentCanon);
    }

    static boolean mkdirs(File dir) throws IOException {
        File canon = IODiagnosticUtil.fixSlashes(dir);
        canon = canon.getCanonicalFile();
        return IODiagnosticUtil.mkdirsMany(dir, canon);
    }

    private static boolean canExecute(File f) {
        if (canExecuteMethod == null) {
            throw new IllegalStateException("File.canExecute() is not available on this JVM");
        }
        try {
            return (Boolean)canExecuteMethod.invoke((Object)f, (Object[])null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean createNewFileMany(File file, File canon, File parent, File parentCanon) throws IOException {
        IOResult result = IODiagnosticUtil.createNewFileOnce(file, canon, parent, parentCanon);
        if (result.status != 0) {
            return result.status == 2;
        }
        result = IODiagnosticUtil.createNewFileOnce(file, canon, parent, parentCanon);
        if (result.status != 0) {
            return result.status == 2;
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException swallow) {
            // empty catch block
        }
        result = IODiagnosticUtil.createNewFileOnce(file, canon, parent, parentCanon);
        if (result.status != 0) {
            return result.status == 2;
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException swallow) {
            // empty catch block
        }
        result = IODiagnosticUtil.createNewFileOnce(file, canon, parent, parentCanon);
        if (result.status != 0) {
            return result.status == 2;
        }
        IODiagnosticUtil.diagnoseCreateNewFileError(file, canon, parent, parentCanon, result.exception);
        throw new RuntimeException("unreachable");
    }

    private static IOResult createNewFileOnce(File file, File canon, File parent, File parentCanon) throws IOException {
        if (parentCanon == null) {
            throw IODiagnosticUtil.newExceptionFile(file, null, "it is a file-system root", new Object[0]);
        }
        parentCanon.mkdirs();
        if (!parentCanon.isDirectory()) {
            return new IOResult(0, null);
        }
        if (parentCanon.isFile()) {
            throw IODiagnosticUtil.newExceptionFile(file, null, "parent is a regular file: %s", parent);
        }
        if (parentCanon.exists() && !parentCanon.isDirectory()) {
            throw IODiagnosticUtil.newExceptionFile(file, null, "parent is a special file: %s", parent);
        }
        char c = IODiagnosticUtil.findInvalidFilenameChar(parentCanon);
        if (c != '\u0000') {
            throw IODiagnosticUtil.newExceptionDir(file, "parent name contains invalid character '%s': %s", Character.valueOf(c), parentCanon);
        }
        IOException exception = null;
        try {
            if (canon.createNewFile()) {
                return new IOResult(2, null);
            }
        }
        catch (IOException e) {
            exception = e;
        }
        if (canon.isFile()) {
            return new IOResult(1, null);
        }
        if (canon.isDirectory()) {
            throw IODiagnosticUtil.newExceptionFile(file, exception, "it is a directory", new Object[0]);
        }
        if (canon.exists() && !canon.isFile()) {
            throw IODiagnosticUtil.newExceptionFile(file, exception, "it is a special file", new Object[0]);
        }
        c = IODiagnosticUtil.findInvalidFilenameChar(canon);
        if (c != '\u0000') {
            throw IODiagnosticUtil.newExceptionFile(file, exception, "name contains invalid character '%s'", Character.valueOf(c));
        }
        return new IOResult(0, exception);
    }

    private static void diagnoseCreateNewFileError(File file, File canon, File parent, File parentCanon, IOException cause) throws IOException {
        String dir = "parent";
        while (parentCanon != null) {
            if (parentCanon.isFile()) {
                throw IODiagnosticUtil.newExceptionFile(file, cause, "%s directory \"%s\" is a regular file", dir, parentCanon);
            }
            if (parentCanon.isDirectory() && !parentCanon.canWrite()) {
                throw IODiagnosticUtil.newExceptionFile(file, cause, "cannot add child to %s directory \"%s\": write permission denied", dir, parentCanon);
            }
            if (parentCanon.isDirectory() && IODiagnosticUtil.isCanExecuteDefined() && !IODiagnosticUtil.canExecute(parentCanon)) {
                throw IODiagnosticUtil.newExceptionFile(file, cause, "cannot add child to %s directory \"%s\": execute permission denied", dir, parentCanon);
            }
            if (parentCanon.isDirectory()) {
                throw IODiagnosticUtil.newExceptionFile(file, cause, "cannot add child to %s directory \"%s\"; check permissions", dir, parentCanon);
            }
            if (parentCanon.exists()) {
                throw IODiagnosticUtil.newExceptionFile(file, cause, "%s directory \"%s\" is a special file", dir, parentCanon);
            }
            char c = IODiagnosticUtil.findInvalidFilenameChar(canon);
            if (c != '\u0000') {
                throw IODiagnosticUtil.newExceptionFile(file, cause, "%s directory \"%s\" contains invalid character '%s' in its name", dir, parentCanon, Character.valueOf(c));
            }
            dir = "ancestor";
            parentCanon = parentCanon.getParentFile();
        }
        throw IODiagnosticUtil.newExceptionFile(file, cause, "unknown cause", new Object[0]);
    }

    private static void diagnoseMkdirsError(File dir, File canon) throws IOException {
        for (File parent = canon.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (parent.isFile()) {
                throw IODiagnosticUtil.newExceptionDir(dir, "ancestor \"%s\" is a regular file", parent);
            }
            if (parent.isDirectory() && !parent.canWrite()) {
                throw IODiagnosticUtil.newExceptionDir(dir, "cannot add child to ancestor \"%s\": write permission denied", parent);
            }
            if (parent.isDirectory() && IODiagnosticUtil.isCanExecuteDefined() && !IODiagnosticUtil.canExecute(parent)) {
                throw IODiagnosticUtil.newExceptionDir(dir, "cannot add child to ancestor \"%s\": execute permission denied", parent);
            }
            if (parent.isDirectory()) {
                throw IODiagnosticUtil.newExceptionDir(dir, "cannot add child to ancestor \"%s\"; check permissions", parent);
            }
            if (parent.exists()) {
                throw IODiagnosticUtil.newExceptionDir(dir, "ancestor \"%s\" is a special file", parent);
            }
            char c = IODiagnosticUtil.findInvalidFilenameChar(canon);
            if (c == '\u0000') continue;
            throw IODiagnosticUtil.newExceptionDir(dir, "ancestor \"%s\" contains invalid character '%s' in its name", parent, Character.valueOf(c));
        }
        throw IODiagnosticUtil.newExceptionDir(dir, "unknown cause", new Object[0]);
    }

    private static char findInvalidFilenameChar(File canon) {
        if (File.separatorChar == '/') {
            return '\u0000';
        }
        String name = canon.getName();
        char result = '\u0000';
        for (int i = 0; i < WINDOWS_INVALID_FILENAME_CHARS.length(); ++i) {
            char c = WINDOWS_INVALID_FILENAME_CHARS.charAt(i);
            if (name.indexOf(c) == -1) continue;
            result = c;
            break;
        }
        return result;
    }

    private static File fixSlashes(File file) {
        String path = file.getPath();
        String fixed = path.replace('/', File.separatorChar);
        if (path != (fixed = fixed.replace('\\', File.separatorChar))) {
            file = new File(fixed);
        }
        return file;
    }

    private static boolean isCanExecuteDefined() {
        return canExecuteMethod != null;
    }

    private static boolean mkdirsMany(File dir, File canon) throws IOException {
        int status = IODiagnosticUtil.mkdirsOnce(dir, canon);
        if (status != 0) {
            return status == 2;
        }
        status = IODiagnosticUtil.mkdirsOnce(dir, canon);
        if (status != 0) {
            return status == 2;
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException swallow) {
            // empty catch block
        }
        status = IODiagnosticUtil.mkdirsOnce(dir, canon);
        if (status != 0) {
            return status == 2;
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        status = IODiagnosticUtil.mkdirsOnce(dir, canon);
        if (status != 0) {
            return status == 2;
        }
        IODiagnosticUtil.diagnoseMkdirsError(dir, canon);
        throw new RuntimeException("unreachable");
    }

    private static int mkdirsOnce(File dir, File canon) throws IOException {
        if (canon.mkdirs()) {
            return 2;
        }
        if (canon.isDirectory()) {
            return 1;
        }
        if (canon.isFile()) {
            throw IODiagnosticUtil.newExceptionDir(dir, "it is a regular file", new Object[0]);
        }
        if (canon.exists() && !canon.isDirectory()) {
            throw IODiagnosticUtil.newExceptionDir(dir, "it is a special file", new Object[0]);
        }
        char c = IODiagnosticUtil.findInvalidFilenameChar(canon);
        if (c != '\u0000') {
            throw IODiagnosticUtil.newExceptionDir(dir, "name contains invalid character '%s'", Character.valueOf(c));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IOException newExceptionDir(File dir, String msg, Object ... args) {
        Formatter f = new Formatter();
        try {
            f.format("Cannot create directory \"%s\"", dir.getAbsolutePath());
            if (msg != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (!(args[i] instanceof File)) continue;
                    args[i] = ((File)args[i]).getAbsolutePath();
                }
                f.format(": ", new Object[0]);
                f.format(msg, args);
            }
            f.format(".", new Object[0]);
            IOException iOException = new IOException(f.toString());
            return iOException;
        }
        finally {
            f.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IOException newExceptionFile(File dir, Throwable cause, String msg, Object ... args) {
        Formatter f = new Formatter();
        try {
            f.format("Cannot create file \"%s\"", dir.getAbsolutePath());
            if (msg != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (!(args[i] instanceof File)) continue;
                    args[i] = ((File)args[i]).getAbsolutePath();
                }
                f.format(": ", new Object[0]);
                f.format(msg, args);
                if (cause != null && cause.getMessage() != null) {
                    f.format(": %s", cause.getMessage());
                }
            }
            if (!(msg = f.toString()).endsWith(".")) {
                msg = msg + ".";
            }
            if (cause != null) {
                IOException iOException = (IOException)new IOException(msg).initCause(cause);
                return iOException;
            }
            IOException iOException = new IOException(msg);
            return iOException;
        }
        finally {
            f.close();
        }
    }

    static {
        Method m;
        try {
            m = File.class.getMethod("canExecute", null);
        }
        catch (Throwable t) {
            m = null;
        }
        canExecuteMethod = m;
    }

    @BridgeMethodsAdded
    private static final class IOResult {
        int status;
        IOException exception;

        IOResult(int status, IOException exception) {
            this.status = status;
            this.exception = exception;
        }
    }
}

