/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.dto;

import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.ChangeHistoryHandle;
import com.ibm.team.scm.common.internal.dto.HistoryProvider;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.dto.WorkspaceComponentPair;

public interface ServiceHistoryProvider {
    public static final IHistoryProviderFactory FACTORY = new IHistoryProviderFactory(){

        @Override
        public ServiceHistoryProvider create(IWorkspaceHandle ws, IComponentHandle c) {
            if (ws == null || c == null) {
                throw new IllegalArgumentException();
            }
            HistoryProvider p = ScmDtoFactory.eINSTANCE.createHistoryProvider();
            WorkspaceComponentPair workspaceComponentPair = ScmDtoFactory.eINSTANCE.createWorkspaceComponentPair();
            workspaceComponentPair.setWorkspace(ws);
            workspaceComponentPair.setComponent(c);
            p.setWorkspaceComponentPair(workspaceComponentPair);
            return p;
        }

        @Override
        public ServiceHistoryProvider create(IWorkspaceHandle ws, IComponentHandle c, ChangeHistoryHandle chh) {
            if (ws == null || c == null) {
                throw new IllegalArgumentException();
            }
            HistoryProvider p = ScmDtoFactory.eINSTANCE.createHistoryProvider();
            WorkspaceComponentPair workspaceComponentPair = ScmDtoFactory.eINSTANCE.createWorkspaceComponentPair();
            workspaceComponentPair.setWorkspace(ws);
            workspaceComponentPair.setComponent(c);
            p.setWorkspaceComponentPair(workspaceComponentPair);
            p.setChangeHistory(chh);
            return p;
        }

        @Override
        public ServiceHistoryProvider create(ChangeHistoryHandle chh) {
            if (chh == null) {
                throw new IllegalArgumentException();
            }
            HistoryProvider p = ScmDtoFactory.eINSTANCE.createHistoryProvider();
            p.setChangeHistory(chh);
            return p;
        }

        @Override
        public ServiceHistoryProvider create(IBaselineHandle bh) {
            if (bh == null) {
                throw new IllegalArgumentException();
            }
            HistoryProvider p = ScmDtoFactory.eINSTANCE.createHistoryProvider();
            p.setBaseline(bh);
            return p;
        }

        @Override
        public ServiceHistoryProvider create(String hgnHash) {
            if (hgnHash == null) {
                throw new IllegalArgumentException();
            }
            HistoryProvider p = ScmDtoFactory.eINSTANCE.createHistoryProvider();
            p.setGraphNodeId(hgnHash);
            return p;
        }
    };

    public static interface IHistoryProviderFactory {
        public ServiceHistoryProvider create(IWorkspaceHandle var1, IComponentHandle var2);

        public ServiceHistoryProvider create(ChangeHistoryHandle var1);

        public ServiceHistoryProvider create(IWorkspaceHandle var1, IComponentHandle var2, ChangeHistoryHandle var3);

        public ServiceHistoryProvider create(IBaselineHandle var1);

        public ServiceHistoryProvider create(String var1);
    }
}

