/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.util;

import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.dto.IVersionableIdentifier;
import com.ibm.team.scm.common.internal.dto2.ScmDto2Factory;
import com.ibm.team.scm.common.internal.dto2.VersionableIdentifier;

public class VersionableIdentifierUtil {
    private static final String DELIMITER = "@";

    private VersionableIdentifierUtil() {
    }

    public static VersionableIdentifier toVersionIdentifier(String versionString) {
        String versionNumber;
        int index = versionString.indexOf(DELIMITER);
        VersionableIdentifier identifier = ScmDto2Factory.eINSTANCE.createVersionableIdentifier();
        if (index > 0) {
            versionNumber = versionString.substring(0, index);
            versionString.substring(index + 1);
            identifier.setShortVersionId(versionNumber);
            identifier.setLongVersionId(versionString);
        } else {
            versionNumber = versionString;
        }
        try {
            Integer.parseInt(versionNumber);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
        identifier.setShortVersionId(versionNumber);
        return identifier;
    }

    public static UUID getRepositoryId(IVersionableIdentifier versionId) {
        String longVersionId = versionId.getLongVersionId();
        String[] split = longVersionId.split(DELIMITER);
        if (split == null || split.length < 2) {
            return null;
        }
        return UUID.valueOf((String)split[1]);
    }

    public static VersionableIdentifier createVersionIdentifier(String versionNumber, UUID repoId) {
        VersionableIdentifier result = ScmDto2Factory.eINSTANCE.createVersionableIdentifier();
        result.setShortVersionId(versionNumber);
        result.setLongVersionId(String.valueOf(versionNumber) + DELIMITER + repoId.getUuidValue());
        return result;
    }
}

