/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CQTask;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTResource;
import com.ibm.rational.wvcm.ct.CTTask;
import com.ibm.rational.wvcm.ct.CTVersion;
import com.ibm.rational.wvcm.ct.CTView;
import com.ibm.rational.wvcm.ri.impl.ActivityImpl;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.wvcm.Activity;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.WvcmException;

public class CTActivity
extends CTResource {
    protected static final String TASK_HLINK_NAME = "WvcmTask";
    private List<CTVersion> _activityVersionList = null;

    CTActivity(Location location, CTProvider provider) {
        super(location, provider);
    }

    @Override
    public Class<?> get_proxyClass() {
        return ActivityImpl.class;
    }

    public static CTActivity doCreateGeneratedActivity(boolean isTask, CTProvider provider, CTLocation locationHint, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        CTActivity result;
        String resultPath;
        String title = null;
        String streamSelector = null;
        String viewTag = null;
        if (locationHint.hasKind(CTLocation.Kind.WORKSPACE)) {
            viewTag = locationHint.getViewTag();
            CTLocation viewLoc = CTLocation.valueOf(CTLocation.Kind.WORKSPACE, viewTag);
            CTView view = (CTView)provider.lookup((Location)viewLoc, feedback);
            streamSelector = view.getStreamSelector(feedback);
        } else {
            String child = locationHint.lastSegment();
            if (child.equals(locationHint.getDisplayName())) {
                streamSelector = locationHint.getDisplayName();
            } else {
                streamSelector = locationHint.parent().getDisplayName();
                title = child;
            }
        }
        CCaseLib cc = provider.getCCaseLib();
        PropValue titlePV = updates.get(Activity.DISPLAY_NAME);
        if (titlePV != null) {
            title = (String)titlePV.get_value();
            updated.add(Activity.DISPLAY_NAME);
        }
        String description = null;
        PropValue descriptionPV = updates.get(Activity.COMMENT);
        if (descriptionPV != null) {
            description = (String)descriptionPV.get_value();
            updated.add(Activity.COMMENT);
        }
        String string = resultPath = viewTag == null ? cc.makeActivityInStream(streamSelector, title, description, feedback) : cc.makeActivityInView(viewTag, streamSelector, title, description, false, feedback);
        if (isTask) {
            CTLocation location = CTLocation.valueOf(CTLocation.Kind.TASK, resultPath);
            result = (CTTask)provider.lookup((Location)location, feedback);
        } else {
            CTLocation location = CTLocation.valueOf(CTLocation.Kind.ACTIVITY, resultPath);
            result = (CTActivity)provider.lookup((Location)location, feedback);
        }
        return result;
    }

    public String getActivityName(SrvcFeedback feedback) throws WvcmException {
        String result = this.getObjInfo(feedback).getPathName();
        return result;
    }

    protected String getSelectorToLock(SrvcFeedback feedback) throws WvcmException {
        return this.getUniversalSelector(feedback);
    }

    @Override
    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.provider().getCCaseLib();
        if (propertyName.equals((Object)Activity.TASK_LIST)) {
            List tasks = (List)value;
            this.setTaskList(tasks, feedback);
        } else if (propertyName.equals((Object)Activity.COMMENT)) {
            cc.setComment(CTActivity.getResourceIdentifier(this.provider(), (Location)this.location(), feedback), (String)value, feedback);
        } else if (propertyName.equals((Object)Activity.IS_COMPLETE)) {
            Boolean isComplete = (Boolean)value;
            if (isComplete.booleanValue()) {
                cc.lock(this.getSelectorToLock(feedback), feedback);
            } else {
                cc.unlock(this.getSelectorToLock(feedback), feedback);
            }
        } else if (!propertyName.equals((Object)Activity.ORIGIN_WORKSPACE)) {
            super.setPropertyFromClient(propertyName, value, initialize, feedback);
        }
    }

    void setVersionList(List<CTVersion> value) {
        this._activityVersionList = Collections.unmodifiableList(new ArrayList<CTVersion>(value));
    }

    private List<CTVersion> getVersionList(SrvcFeedback feedback) throws WvcmException {
        if (this._activityVersionList != null) {
            return this._activityVersionList;
        }
        throw new IllegalStateException("getting a version list that has not already been set is not yet supported");
    }

    private void setTaskList(List<CTTask> tasks, SrvcFeedback feedback) throws WvcmException {
        for (CTTask t : tasks) {
            this.provider().getCCaseLib().setHyperlink(TASK_HLINK_NAME, this.location().getDisplayName(), t.location().getDisplayName(), feedback);
        }
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.provider().getCCaseLib();
        if (propertyName.equals((Object)Activity.TASK_LIST)) {
            return this.getTaskList(feedback);
        }
        if (propertyName.equals((Object)Activity.COMMENT)) {
            return cc.getComment(this.location().getDisplayName(), feedback);
        }
        if (propertyName.equals((Object)Activity.DISPLAY_NAME)) {
            return cc.getDisplayName(this.location().getDisplayName(), feedback);
        }
        if (propertyName.equals((Object)Activity.IS_COMPLETE)) {
            return cc.isLocked(this.location().getDisplayName(), feedback);
        }
        if (propertyName.equals((Object)Activity.ORIGIN_WORKSPACE)) {
            return null;
        }
        if (propertyName.equals((Object)Activity.ACTIVITY_VERSION_LIST)) {
            return this.getVersionList(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private List<SrvcResource> getTaskList(SrvcFeedback feedback) throws WvcmException {
        String universalSelector;
        ArrayList<SrvcResource> results = new ArrayList<SrvcResource>();
        CTProvider provider = this.provider();
        CCaseLib cc = provider.getCCaseLib();
        List<String> targets = cc.getHyperlinkTargets(TASK_HLINK_NAME, universalSelector = this.getUniversalSelector(feedback), feedback);
        if (targets.isEmpty()) {
            if (cc.isActivityOnCQEnabledProject(universalSelector, feedback)) {
                CTLocation taskLoc = CTLocation.valueOf(CTLocation.Kind.CQTASK, universalSelector);
                results.add(new CQTask((Location)taskLoc, provider));
            } else {
                CTLocation taskLoc = CTLocation.valueOf(CTLocation.Kind.TASK, universalSelector);
                results.add(new CTTask((Location)taskLoc, provider));
            }
        } else {
            List<String> objSels = cc.getUniversalSelectors(targets, feedback);
            for (String objSel : objSels) {
                CTLocation taskLoc = CTLocation.valueOf(CTLocation.Kind.TASK, objSel);
                results.add(new CTTask((Location)taskLoc, provider));
            }
        }
        return results;
    }

    public static CTActivity valueOf(CTProvider p, String activityId, SrvcFeedback feedback) throws WvcmException {
        return (CTActivity)p.lookup((Location)CTLocation.valueOf(activityId), feedback);
    }
}

